/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui;

import java.util.List;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.core.search.JavaSearchTypeNameMatch;
import org.eclipse.jdt.internal.corext.util.OpenTypeHistory;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextListener2;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.monitor.core.StatusHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeHistoryManager
implements IInteractionContextListener2 {
    public void contextActivated(IInteractionContext context) {
        this.clearTypeHistory();
        for (IInteractionElement node : context.getInteresting()) {
            this.updateTypeHistory(node, true);
        }
    }

    private void updateTypeHistory(IInteractionElement node, boolean add) {
        IJavaElement element = JavaCore.create((String)node.getHandleIdentifier());
        if (element instanceof IType) {
            IType type = (IType)element;
            try {
                if (type.exists() && !type.isAnonymous() && !this.isAspectjType(type)) {
                    JavaSearchTypeNameMatch typeNameMatch = new JavaSearchTypeNameMatch(type, type.getFlags());
                    if (add && !OpenTypeHistory.getInstance().contains((TypeNameMatch)typeNameMatch)) {
                        OpenTypeHistory.getInstance().accessed((TypeNameMatch)typeNameMatch);
                    } else {
                        OpenTypeHistory.getInstance().remove((TypeNameMatch)typeNameMatch);
                    }
                }
            }
            catch (JavaModelException e) {
                StatusHandler.log((Throwable)e, (String)"failed to update history for a type");
            }
        }
    }

    private boolean isAspectjType(IType type) {
        return type.getHandleIdentifier().indexOf(125) != -1;
    }

    public void contextDeactivated(IInteractionContext context) {
        this.clearTypeHistory();
    }

    public void contextCleared(IInteractionContext context) {
        this.clearTypeHistory();
    }

    public void clearTypeHistory() {
        TypeNameMatch[] typeInfos = OpenTypeHistory.getInstance().getTypeInfos();
        int i = 0;
        while (i < typeInfos.length) {
            OpenTypeHistory.getInstance().remove(typeInfos[i]);
            ++i;
        }
    }

    public void interestChanged(List<IInteractionElement> nodes) {
        for (IInteractionElement node : nodes) {
            this.updateTypeHistory(node, true);
        }
    }

    public void elementDeleted(IInteractionElement node) {
        this.updateTypeHistory(node, false);
    }

    public void elementsDeleted(List<IInteractionElement> elements) {
        for (IInteractionElement element : elements) {
            this.updateTypeHistory(element, false);
        }
    }

    public void landmarkAdded(IInteractionElement node) {
    }

    public void landmarkRemoved(IInteractionElement node) {
    }

    public void relationsChanged(IInteractionElement node) {
    }

    public void contextPreActivated(IInteractionContext context) {
    }
}

