/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui.actions;

import org.eclipse.jdt.internal.junit.model.TestCaseElement;
import org.eclipse.jdt.internal.junit.model.TestElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.mylyn.internal.tasks.ui.actions.NewTaskAction;
import org.eclipse.mylyn.tasks.core.TaskSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class NewTaskFromJunitResultViewAction
implements IViewActionDelegate,
ISelectionChangedListener {
    public static final String ID = "org.eclipse.mylyn.bugzilla.actions.newTaskFromJunitResultView";
    private String traceString;
    private TestCaseElement testCaseElement;

    public void run(IAction action) {
        this.run();
    }

    public void run() {
        if (this.traceString == null || this.testCaseElement == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\n-- Error Log from JUnit --\nClass: ");
        sb.append(this.testCaseElement.getTestClassName());
        sb.append("\nMethod: ");
        sb.append(this.testCaseElement.getTestMethodName());
        sb.append("\nActual: ");
        sb.append(this.testCaseElement.getActual());
        sb.append("\nExpected: ");
        sb.append(this.testCaseElement.getExpected());
        sb.append("\nStack Trace:\n");
        sb.append(this.traceString);
        TaskSelection taskSelection = new TaskSelection("", sb.toString());
        NewTaskAction action = new NewTaskAction();
        action.showWizard(taskSelection);
    }

    public void selectionChanged(SelectionChangedEvent event) {
    }

    public void init(IViewPart view) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        TreeSelection t;
        TestElement testElement;
        this.traceString = null;
        this.testCaseElement = null;
        if (selection instanceof TreeSelection && (testElement = (TestElement)(t = (TreeSelection)selection).getFirstElement()) instanceof TestCaseElement) {
            this.testCaseElement = (TestCaseElement)testElement;
            this.traceString = this.testCaseElement.getTrace();
        }
        action.setEnabled(this.traceString != null);
    }
}

