/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.monitor.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.eclipse.mylyn.monitor.core.StatusHandler;

public abstract class AbstractMonitorLog {
    protected File outputFile;
    protected FileOutputStream outputStream;
    protected boolean started = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMonitoring() {
        AbstractMonitorLog abstractMonitorLog = this;
        synchronized (abstractMonitorLog) {
            if (this.started) {
                return;
            }
            this.started = true;
        }
        try {
            if (!this.outputFile.exists()) {
                this.outputFile.createNewFile();
            }
            this.outputStream = new FileOutputStream(this.outputFile, true);
        }
        catch (Exception e) {
            StatusHandler.fail(e, "Could not log to file: " + this.outputFile.getAbsolutePath(), true);
        }
    }

    public void stopMonitoring() {
        try {
            if (this.outputStream != null) {
                this.outputStream.flush();
                this.outputStream.close();
            }
            this.started = false;
        }
        catch (IOException e) {
            StatusHandler.fail(e, "could not close interaction event stream", false);
        }
    }

    public File moveOutputFile(String newPath) {
        this.stopMonitoring();
        File newFile = new File(newPath);
        try {
            if (this.outputFile.exists() && !newFile.exists()) {
                this.outputFile.renameTo(newFile);
            } else if (!newFile.exists()) {
                newFile.createNewFile();
                this.outputFile.delete();
            } else {
                this.outputFile.delete();
            }
            this.outputFile = newFile;
        }
        catch (Exception e) {
            StatusHandler.fail(e, "Could not set logger output file", true);
        }
        this.startMonitoring();
        return newFile;
    }

    public File getOutputFile() {
        return this.outputFile;
    }
}

