/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.monitor.ui;

import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.monitor.ui.AbstractUserActivityMonitor;
import org.eclipse.mylyn.monitor.ui.IUserAttentionListener;
import org.eclipse.mylyn.monitor.ui.MonitorUiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityContextManager {
    private int TICK = 30000;
    private int SHORT_TICK = 5000;
    private AbstractUserActivityMonitor userActivityMonitor;
    private Set<IUserAttentionListener> attentionListeners = new CopyOnWriteArraySet<IUserAttentionListener>();
    private long startTime = -1L;
    private final int timeout;
    private Object startTimeLock = new Object();
    private boolean wasTimedOut = true;
    private int wait = this.SHORT_TICK;
    private CheckActivityJob checkJob;
    private ArrayList<AbstractUserActivityMonitor> activityMonitors;

    public ActivityContextManager(int timeout, ArrayList<AbstractUserActivityMonitor> monitors) {
        this.activityMonitors = monitors;
        this.timeout = timeout;
    }

    public void fireActive(long start, long end) {
        if (end > start) {
            ContextCorePlugin.getContextManager().processActivityMetaContextEvent(new InteractionEvent(InteractionEvent.Kind.ATTENTION, this.userActivityMonitor.getStructureKind(), this.userActivityMonitor.getStructureHandle(), this.userActivityMonitor.getOriginId(), null, "added", 1.0f, new Date(start), new Date(end)));
            for (IUserAttentionListener attentionListener : this.attentionListeners) {
                attentionListener.userAttentionGained();
            }
        }
    }

    public void fireInactive() {
        for (IUserAttentionListener attentionListener : this.attentionListeners) {
            attentionListener.userAttentionLost();
        }
    }

    public void start() {
        for (AbstractUserActivityMonitor monitor : this.activityMonitors) {
            monitor.start();
        }
        this.checkJob = new CheckActivityJob();
        this.checkJob.setSystem(true);
        this.checkJob.setPriority(50);
        this.checkJob.schedule(this.TICK);
    }

    public void stop() {
        for (AbstractUserActivityMonitor monitor : this.activityMonitors) {
            monitor.stop();
        }
        if (this.checkJob != null) {
            this.checkJob.cancel();
        }
    }

    public void addListener(IUserAttentionListener listener) {
        this.attentionListeners.add(listener);
    }

    public void removeListener(IUserAttentionListener listener) {
        this.attentionListeners.remove(listener);
    }

    public long getLastEventTime() {
        for (AbstractUserActivityMonitor monitor : this.activityMonitors) {
            if (!monitor.isEnabled()) continue;
            this.userActivityMonitor = monitor;
            return this.userActivityMonitor.getLastInteractionTime();
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getStartTime() {
        Object object = this.startTimeLock;
        synchronized (object) {
            return this.startTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStartTime(long startTime) {
        Object object = this.startTimeLock;
        synchronized (object) {
            this.startTime = startTime;
        }
    }

    class CheckActivityJob
    extends Job {
        public CheckActivityJob() {
            super("Activity Monitor Job");
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                if (Platform.isRunning() && !MonitorUiPlugin.getDefault().getWorkbench().isClosing()) {
                    long localLastEventTime = ActivityContextManager.this.getLastEventTime();
                    long localStartTime = ActivityContextManager.this.getStartTime();
                    long currentTime = System.currentTimeMillis();
                    if (currentTime - localLastEventTime >= (long)ActivityContextManager.this.timeout) {
                        if (!ActivityContextManager.this.wasTimedOut) {
                            ActivityContextManager.this.fireInactive();
                            ActivityContextManager.this.wasTimedOut = true;
                        }
                        ActivityContextManager.this.wait = ActivityContextManager.this.SHORT_TICK;
                    } else {
                        if (ActivityContextManager.this.wasTimedOut) {
                            ActivityContextManager.this.wasTimedOut = false;
                            ActivityContextManager.this.setStartTime(localLastEventTime);
                        } else {
                            ActivityContextManager.this.fireActive(localStartTime, currentTime);
                            ActivityContextManager.this.setStartTime(currentTime);
                        }
                        ActivityContextManager.this.wait = ActivityContextManager.this.TICK;
                    }
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                if (Platform.isRunning()) {
                    ActivityContextManager.this.checkJob.schedule(ActivityContextManager.this.wait);
                }
            }
        }
    }
}

