/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.monitor.ui;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public abstract class AbstractCommandMonitor
implements IExecutionListener {
    public AbstractCommandMonitor() {
        try {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
            commandService.addExecutionListener((IExecutionListener)this);
        }
        catch (NullPointerException nullPointerException) {
            StatusHandler.log((String)"Monitors can not be instantiated until the workbench is active: ", (Object)this);
        }
    }

    public void dispose() {
        try {
            ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getAdapter(ICommandService.class);
            commandService.removeExecutionListener((IExecutionListener)this);
        }
        catch (NullPointerException npe) {
            StatusHandler.log((Throwable)npe, (String)"Could not dispose monitor.");
        }
    }

    public void postExecuteFailure(String commandId, ExecutionException exception) {
    }

    public void notHandled(String commandId, NotHandledException exception) {
    }

    public void postExecuteSuccess(String commandId, Object returnValue) {
    }

    public void preExecute(String commandId, ExecutionEvent event) {
        if (commandId != null) {
            this.handleCommandExecution(commandId, event);
        }
    }

    protected abstract void handleCommandExecution(String var1, ExecutionEvent var2);
}

