/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.monitor.ui;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.monitor.ui.IMonitoredWindow;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.monitor.ui.MonitorUiPlugin;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;

public abstract class AbstractUserInteractionMonitor
implements ISelectionListener {
    protected Object lastSelectedElement = null;

    public AbstractUserInteractionMonitor() {
        try {
            MonitorUiPlugin.getDefault().addWindowPostSelectionListener(this);
        }
        catch (NullPointerException nullPointerException) {
            StatusHandler.log((String)"Monitors can not be instantiated until the workbench is active", (Object)this);
        }
    }

    public void dispose() {
        try {
            MonitorUiPlugin.getDefault().removeWindowPostSelectionListener(this);
        }
        catch (NullPointerException npe) {
            StatusHandler.log((Throwable)npe, (String)"Could not dispose monitor.");
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        IWorkbenchWindow window;
        if (part.getSite() != null && part.getSite().getWorkbenchWindow() != null && (window = part.getSite().getWorkbenchWindow()) instanceof IMonitoredWindow && !((IMonitoredWindow)window).isMonitored()) {
            return;
        }
        if (selection == null || selection.isEmpty()) {
            return;
        }
        if (!ContextCorePlugin.getContextManager().isContextActive()) {
            this.handleWorkbenchPartSelection(part, selection, false);
        } else {
            this.handleWorkbenchPartSelection(part, selection, true);
        }
    }

    protected abstract void handleWorkbenchPartSelection(IWorkbenchPart var1, ISelection var2, boolean var3);

    protected InteractionEvent handleElementSelection(IWorkbenchPart part, Object selectedElement, boolean contributeToContext) {
        if (selectedElement == null || selectedElement.equals(this.lastSelectedElement)) {
            return null;
        }
        AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(selectedElement);
        String handleIdentifier = bridge.getHandleIdentifier(selectedElement);
        InteractionEvent selectionEvent = bridge.getContentType() != null ? new InteractionEvent(InteractionEvent.Kind.SELECTION, bridge.getContentType(), handleIdentifier, part.getSite().getId()) : new InteractionEvent(InteractionEvent.Kind.SELECTION, null, null, part.getSite().getId());
        if (handleIdentifier != null && contributeToContext) {
            ContextCorePlugin.getContextManager().processInteractionEvent(selectionEvent);
        }
        MonitorUiPlugin.getDefault().notifyInteractionObserved(selectionEvent);
        return selectionEvent;
    }

    protected void handleElementEdit(IWorkbenchPart part, Object selectedElement, boolean contributeToContext) {
        if (selectedElement == null) {
            return;
        }
        AbstractContextStructureBridge bridge = ContextCorePlugin.getDefault().getStructureBridge(selectedElement);
        String handleIdentifier = bridge.getHandleIdentifier(selectedElement);
        InteractionEvent editEvent = new InteractionEvent(InteractionEvent.Kind.EDIT, bridge.getContentType(), handleIdentifier, part.getSite().getId());
        if (handleIdentifier != null && contributeToContext) {
            ContextCorePlugin.getContextManager().processInteractionEvent(editEvent);
        }
        MonitorUiPlugin.getDefault().notifyInteractionObserved(editEvent);
    }

    protected void handleNavigation(IWorkbenchPart part, Object targetElement, String kind, boolean contributeToContext) {
        AbstractContextStructureBridge adapter = ContextCorePlugin.getDefault().getStructureBridge(targetElement);
        if (adapter.getContentType() != null) {
            String handleIdentifier = adapter.getHandleIdentifier(targetElement);
            InteractionEvent navigationEvent = new InteractionEvent(InteractionEvent.Kind.SELECTION, adapter.getContentType(), handleIdentifier, part.getSite().getId(), kind);
            if (handleIdentifier != null && contributeToContext) {
                ContextCorePlugin.getContextManager().processInteractionEvent(navigationEvent);
            }
            MonitorUiPlugin.getDefault().notifyInteractionObserved(navigationEvent);
        }
    }

    public InteractionEvent.Kind getEventKind() {
        return InteractionEvent.Kind.SELECTION;
    }
}

