/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.resources.ui;

import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.resources.IResource;
import org.eclipse.mylyn.context.core.AbstractContextStructureBridge;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceInterestUpdater {
    public static final String SOURCE_ID = "org.eclipse.mylyn.ide.resource.interest.updater";
    private boolean syncExec = false;

    public void addResourceToContext(final Set<IResource> resources, final InteractionEvent.Kind interactionKind) {
        try {
            if (!resources.isEmpty()) {
                if (this.syncExec) {
                    this.internalAddResourceToContext(resources, interactionKind);
                } else {
                    IWorkbench workbench = PlatformUI.getWorkbench();
                    if (!workbench.isClosing() && !workbench.getDisplay().isDisposed()) {
                        workbench.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                ResourceInterestUpdater.this.internalAddResourceToContext(resources, interactionKind);
                            }
                        });
                    }
                }
            }
        }
        catch (Throwable t) {
            StatusHandler.fail((Throwable)t, (String)("could not add resource to context: " + resources), (boolean)false);
        }
    }

    private void internalAddResourceToContext(Set<IResource> resources, InteractionEvent.Kind interactionKind) {
        ArrayList<InteractionEvent> interactionEvents = new ArrayList<InteractionEvent>();
        for (IResource resource : resources) {
            IInteractionElement element;
            AbstractContextStructureBridge bridge;
            String handle;
            if (!this.acceptResource(resource) || (handle = (bridge = ContextCorePlugin.getDefault().getStructureBridge((Object)resource)).getHandleIdentifier((Object)resource)) == null || (element = ContextCorePlugin.getContextManager().getElement(handle)) == null || element.getInterest().isInteresting()) continue;
            InteractionEvent interactionEvent = new InteractionEvent(interactionKind, bridge.getContentType(), handle, SOURCE_ID);
            interactionEvents.add(interactionEvent);
        }
        if (InteractionEvent.Kind.SELECTION.equals((Object)interactionKind)) {
            ContextCorePlugin.getContextManager().processInteractionEvents(interactionEvents, true);
        } else {
            ContextCorePlugin.getContextManager().processInteractionEvents(interactionEvents, false);
        }
    }

    private boolean acceptResource(IResource resource) {
        return resource.isAccessible() && !resource.isDerived() && !resource.isPhantom();
    }

    public void setSyncExec(boolean syncExec) {
        this.syncExec = syncExec;
    }
}

