/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import org.eclipse.mylyn.internal.tasks.core.LocalRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.TaskRepository;

public interface ITaskRepositoryFilter {
    public static final ITaskRepositoryFilter ALL = new ITaskRepositoryFilter(){

        public boolean accept(TaskRepository repository, AbstractRepositoryConnector connector) {
            return true;
        }
    };
    public static final ITaskRepositoryFilter CAN_QUERY = new ITaskRepositoryFilter(){

        public boolean accept(TaskRepository repository, AbstractRepositoryConnector connector) {
            return !(connector instanceof LocalRepositoryConnector) && !repository.isOffline();
        }
    };
    public static final ITaskRepositoryFilter CAN_CREATE_NEW_TASK = new ITaskRepositoryFilter(){

        public boolean accept(TaskRepository repository, AbstractRepositoryConnector connector) {
            return connector.canCreateNewTask(repository) && !repository.isOffline();
        }
    };
    public static final ITaskRepositoryFilter CAN_CREATE_TASK_FROM_KEY = new ITaskRepositoryFilter(){

        public boolean accept(TaskRepository repository, AbstractRepositoryConnector connector) {
            return connector.canCreateTaskFromKey(repository) && !repository.isOffline();
        }
    };
    public static final ITaskRepositoryFilter IS_USER_MANAGED = new ITaskRepositoryFilter(){

        public boolean accept(TaskRepository repository, AbstractRepositoryConnector connector) {
            return connector.isUserManaged();
        }
    };

    public boolean accept(TaskRepository var1, AbstractRepositoryConnector var2);
}

