/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskDelegate;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScheduledTaskContainer
extends AbstractTaskCategory {
    private Set<ScheduledTaskDelegate> dateRangeDelegates = new HashSet<ScheduledTaskDelegate>();
    private Calendar startDate;
    private Calendar endDate;
    private TaskActivityManager activityManager;

    public ScheduledTaskContainer(TaskActivityManager activityManager, GregorianCalendar startDate, GregorianCalendar endDate, String description) {
        super(description);
        this.activityManager = activityManager;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public ScheduledTaskContainer(TaskActivityManager activityManager, Calendar startDate, Calendar endDate, String description) {
        super(description);
        this.activityManager = activityManager;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public ScheduledTaskContainer(TaskActivityManager activityManager, Date time, Date time2, String description) {
        super(description);
        this.activityManager = activityManager;
        this.startDate = new GregorianCalendar();
        this.startDate.setTime(time);
        this.endDate = new GregorianCalendar();
        this.endDate.setTime(time2);
    }

    public boolean includes(Calendar cal) {
        return this.startDate.getTimeInMillis() <= cal.getTimeInMillis() && this.endDate.getTimeInMillis() >= cal.getTimeInMillis();
    }

    public Calendar getStart() {
        return this.startDate;
    }

    public Calendar getEnd() {
        return this.endDate;
    }

    public long getTotalElapsed() {
        long elapsed = 0L;
        for (AbstractTask task : this.getChildren()) {
            elapsed += this.activityManager.getElapsedTime(task, this.getStart(), this.getEnd());
        }
        return elapsed;
    }

    public long getElapsed(AbstractTask task) {
        return this.activityManager.getElapsedTime(task, this.getStart(), this.getEnd());
    }

    public long getTotalEstimated() {
        long totalEstimated = 0L;
        for (AbstractTask abstractTask : this.dateRangeDelegates) {
            totalEstimated += (long)abstractTask.getEstimateTimeHours();
        }
        return totalEstimated;
    }

    public boolean isArchive() {
        return false;
    }

    public void setIsArchive(boolean isArchive) {
    }

    @Override
    public String getPriority() {
        return "";
    }

    @Override
    public void setHandleIdentifier(String id) {
    }

    public Set<ScheduledTaskDelegate> getDateRangeDelegates() {
        return this.dateRangeDelegates;
    }

    public boolean isFuture() {
        return !this.isPresent() && this.getStart().after(Calendar.getInstance());
    }

    public boolean isPresent() {
        return this.getStart().before(Calendar.getInstance()) && this.getEnd().after(Calendar.getInstance());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.endDate == null ? 0 : this.endDate.hashCode());
        result = 31 * result + (this.startDate == null ? 0 : this.startDate.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ScheduledTaskContainer other = (ScheduledTaskContainer)obj;
        if (this.endDate == null ? other.endDate != null : !this.endDate.equals(other.endDate)) {
            return false;
        }
        return !(this.startDate == null ? other.startDate != null : !this.startDate.equals(other.startDate));
    }

    @Override
    public int compareTo(AbstractTaskContainer taskListElement) {
        return this.startDate.compareTo(((ScheduledTaskContainer)taskListElement).startDate);
    }

    @Override
    public boolean isUserDefined() {
        return false;
    }

    @Override
    public Set<AbstractTask> getChildren() {
        HashSet<AbstractTask> children = new HashSet<AbstractTask>();
        if (this.isPresent()) {
            Calendar beginning = Calendar.getInstance();
            beginning.setTimeInMillis(0L);
            Calendar end = Calendar.getInstance();
            end.set(5000, 12, 1);
            for (AbstractTask task : this.activityManager.getDueTasks(beginning, this.getStart())) {
                if (!this.activityManager.isOverdue(task)) continue;
                children.add(task);
            }
            for (AbstractTask task : this.activityManager.getScheduledTasks(beginning, this.getStart())) {
                if (!task.isPastReminder() || task.isCompleted()) continue;
                children.add(task);
            }
            children.addAll(this.activityManager.getScheduledTasks(this.getStart(), this.getEnd()));
            for (AbstractTask task : this.activityManager.getDueTasks(this.getStart(), this.getEnd())) {
                if (!this.activityManager.isOwnedByUser(task)) continue;
                children.add(task);
            }
            AbstractTask activeTask = this.activityManager.getActiveTask();
            if (activeTask != null && !children.contains(activeTask)) {
                Set<AbstractTask> futureScheduled = this.activityManager.getScheduledTasks(this.getStart(), end);
                for (AbstractTask task : this.activityManager.getDueTasks(this.getStart(), end)) {
                    if (!this.activityManager.isOwnedByUser(task)) continue;
                    futureScheduled.add(task);
                }
                if (!futureScheduled.contains(activeTask)) {
                    children.add(activeTask);
                }
            }
            return children;
        }
        if (this.isFuture()) {
            children.addAll(this.activityManager.getScheduledTasks(this.getStart(), this.getEnd()));
            for (AbstractTask task : this.activityManager.getDueTasks(this.getStart(), this.getEnd())) {
                if (!this.activityManager.isOwnedByUser(task)) continue;
                children.add(task);
            }
            return children;
        }
        children.addAll(this.activityManager.getActiveTasks(this.getStart(), this.getEnd()));
        return children;
    }

    @Override
    public Set<AbstractTask> getChildrenInternal() {
        return this.getChildren();
    }
}

