/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core;

import java.util.Calendar;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;

public class TaskActivityUtil {
    public static Calendar snapStartOfDay(Calendar cal) {
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.getTime();
        return cal;
    }

    public static Calendar snapStartOfHour(Calendar cal) {
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.getTime();
        return cal;
    }

    public static Calendar snapEndOfHour(Calendar cal) {
        cal.set(12, cal.getMaximum(12));
        cal.set(13, cal.getMaximum(13));
        cal.set(14, cal.getMaximum(14));
        cal.getTime();
        return cal;
    }

    public static Calendar snapEndOfDay(Calendar cal) {
        cal.set(11, cal.getMaximum(11));
        cal.set(12, cal.getMaximum(12));
        cal.set(13, cal.getMaximum(13));
        cal.set(14, cal.getMaximum(14));
        cal.getTime();
        return cal;
    }

    public static Calendar snapNextDay(Calendar cal) {
        cal.add(5, 1);
        TaskActivityUtil.snapStartOfDay(cal);
        return cal;
    }

    public static Calendar snapStartOfWorkWeek(Calendar cal) {
        cal.set(7, TaskActivityManager.getInstance().getStartDay());
        TaskActivityUtil.snapStartOfDay(cal);
        return cal;
    }

    public static Calendar snapEndOfWeek(Calendar cal) {
        if (cal.getFirstDayOfWeek() == 2) {
            cal.set(7, 1);
        } else {
            cal.set(7, 7);
        }
        TaskActivityUtil.snapEndOfDay(cal);
        return cal;
    }

    public static Calendar snapForwardNumDays(Calendar calendar, int days) {
        calendar.add(5, days);
        calendar.set(11, TaskActivityManager.getInstance().getEndHour());
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static Calendar snapEndOfWorkDay(Calendar calendar) {
        calendar.set(11, TaskActivityManager.getInstance().getEndHour());
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    public static Calendar snapNextWorkWeek(Calendar calendar) {
        calendar.add(4, 1);
        TaskActivityUtil.snapStartOfWorkWeek(calendar);
        TaskActivityUtil.snapEndOfWorkDay(calendar);
        return calendar;
    }

    public static boolean isAfterCurrentWeek(Calendar time) {
        if (time != null) {
            Calendar cal = TaskActivityUtil.getCalendar();
            return time.compareTo(TaskActivityUtil.snapNextWorkWeek(cal)) > -1;
        }
        return false;
    }

    public static boolean isFuture(Calendar time) {
        if (time != null) {
            Calendar cal = TaskActivityUtil.getCalendar();
            cal.add(4, 2);
            TaskActivityUtil.snapStartOfWorkWeek(cal);
            return time.compareTo(cal) > -1;
        }
        return false;
    }

    public static boolean isThisWeek(Calendar time) {
        if (time != null) {
            Calendar weekStart = TaskActivityUtil.getCalendar();
            TaskActivityUtil.snapStartOfWorkWeek(weekStart);
            Calendar weekEnd = TaskActivityUtil.getCalendar();
            TaskActivityUtil.snapEndOfWeek(weekEnd);
            return time.compareTo(weekStart) >= 0 && time.compareTo(weekEnd) <= 0;
        }
        return false;
    }

    public static boolean isToday(Calendar time) {
        if (time != null) {
            Calendar dayStart = TaskActivityUtil.getCalendar();
            TaskActivityUtil.snapStartOfDay(dayStart);
            Calendar midnight = TaskActivityUtil.getCalendar();
            TaskActivityUtil.snapEndOfDay(midnight);
            return time.compareTo(dayStart) >= 0 && time.compareTo(midnight) <= 0;
        }
        return false;
    }

    public static Calendar getCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.setFirstDayOfWeek(TaskActivityManager.getInstance().getStartDay());
        cal.getTime();
        return cal;
    }

    public static Calendar getStartOfCurrentWeek() {
        Calendar cal = TaskActivityUtil.getCalendar();
        return TaskActivityUtil.snapStartOfWorkWeek(cal);
    }

    public static Calendar getEndOfCurrentWeek() {
        Calendar cal = TaskActivityUtil.getCalendar();
        return TaskActivityUtil.snapEndOfWeek(cal);
    }

    public static boolean isBetween(Calendar time, Calendar start, Calendar end) {
        return time.compareTo(start) >= 0 && time.compareTo(end) <= 0;
    }
}

