/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.ITaskCollector;
import org.eclipse.mylyn.tasks.core.ITaskFactory;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryHitCollector
implements ITaskCollector {
    public static final int MAX_HITS = 5000;
    public static final String MAX_HITS_REACHED = "Max allowed number of hits returned exceeded. Some hits may not be displayed. Please narrow query scope.";
    private final Set<AbstractTask> taskResults = new HashSet<AbstractTask>();
    private final ITaskFactory taskFactory;

    public QueryHitCollector(ITaskFactory taskFactory) {
        this.taskFactory = taskFactory;
    }

    @Override
    public void accept(AbstractTask task) {
        if (task == null) {
            throw new IllegalArgumentException();
        }
        if (this.taskResults.size() < 5000) {
            this.taskResults.add(task);
        }
    }

    @Override
    public void accept(RepositoryTaskData taskData) throws CoreException {
        if (taskData == null) {
            throw new IllegalArgumentException();
        }
        AbstractTask task = this.taskFactory.createTask(taskData, (IProgressMonitor)new NullProgressMonitor());
        if (this.taskResults.size() < 5000) {
            this.taskResults.add(task);
        }
    }

    @Override
    public Set<AbstractTask> getTasks() {
        return this.taskResults;
    }
}

