/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.core;

import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TimeZone;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.web.core.AuthenticationCredentials;
import org.eclipse.mylyn.web.core.AuthenticationType;
import org.eclipse.mylyn.web.core.WebClientUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskRepository
extends PlatformObject {
    public static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    private static final String USERNAME = ".username";
    private static final String PASSWORD = ".password";
    private static final String SAVE_PASSWORD = ".savePassword";
    private static final String ENABLED = ".enabled";
    private static final String AUTH_REPOSITORY = "org.eclipse.mylyn.tasklist.repositories";
    public static final String AUTH_PASSWORD = "org.eclipse.mylyn.tasklist.repositories.password";
    public static final String AUTH_USERNAME = "org.eclipse.mylyn.tasklist.repositories.username";
    public static final String ANONYMOUS_LOGIN = "org.eclipse.mylyn.tasklist.repositories.anonymous";
    private static final String AUTH_HTTP = "org.eclipse.mylyn.tasklist.repositories.httpauth";
    public static final String AUTH_HTTP_PASSWORD = "org.eclipse.mylyn.tasklist.repositories.httpauth.password";
    public static final String AUTH_HTTP_USERNAME = "org.eclipse.mylyn.tasklist.repositories.httpauth.username";
    public static final String NO_VERSION_SPECIFIED = "unknown";
    private static final String AUTH_SCHEME = "Basic";
    private static final String AUTH_REALM = "";
    private static final URL DEFAULT_URL;
    private static final String PROPERTY_CONFIG_TIMESTAMP = "org.eclipse.mylyn.tasklist.repositories.configuration.timestamp";
    public static final String PROXY_USEDEFAULT = "org.eclipse.mylyn.tasklist.repositories.proxy.usedefault";
    public static final String PROXY_HOSTNAME = "org.eclipse.mylyn.tasklist.repositories.proxy.hostname";
    public static final String PROXY_PORT = "org.eclipse.mylyn.tasklist.repositories.proxy.port";
    private static final String AUTH_PROXY = "org.eclipse.mylyn.tasklist.repositories.proxy";
    public static final String PROXY_USERNAME = "org.eclipse.mylyn.tasklist.repositories.proxy.username";
    public static final String PROXY_PASSWORD = "org.eclipse.mylyn.tasklist.repositories.proxy.password";
    public static final String OFFLINE = "org.eclipse.mylyn.tasklist.repositories.offline";
    private static final Object LOCK;
    private static Map<String, Map<String, String>> credentials;
    private boolean isCachedUserName;
    private String cachedUserName;
    private Map<String, String> properties = new LinkedHashMap<String, String>();
    private Map<String, String> transientProperties = new HashMap<String, String>();
    private boolean isBugRepository = false;

    static {
        LOCK = new Object();
        credentials = new HashMap<String, Map<String, String>>();
        URL url = null;
        try {
            url = new URL("http://eclipse.org/mylyn");
        }
        catch (Exception exception) {}
        DEFAULT_URL = url;
    }

    public TaskRepository(String kind, String serverUrl) {
        this(kind, serverUrl, NO_VERSION_SPECIFIED);
    }

    public TaskRepository(String kind, String serverUrl, String version) {
        this(kind, serverUrl, version, DEFAULT_CHARACTER_ENCODING, TimeZone.getDefault().getID());
    }

    public TaskRepository(String kind, String serverUrl, String version, String encoding, String timeZoneId) {
        this.properties.put("kind", kind);
        this.properties.put("url", serverUrl);
        this.properties.put("version", version);
        this.properties.put("encoding", encoding);
        this.properties.put("timezone", timeZoneId);
        this.setProperty(PROXY_USEDEFAULT, new Boolean(true).toString());
        this.setProperty("org.eclipse.mylyn.tasklist.repositories.savePassword", String.valueOf(true));
        this.setProperty("org.eclipse.mylyn.tasklist.repositories.httpauth.savePassword", String.valueOf(true));
        this.setProperty("org.eclipse.mylyn.tasklist.repositories.proxy.savePassword", String.valueOf(true));
    }

    public TaskRepository(String kind, String serverUrl, Map<String, String> properties) {
        this.properties.put("kind", kind);
        this.properties.put("url", serverUrl);
        this.properties.putAll(properties);
        this.setProperty(PROXY_USEDEFAULT, new Boolean(true).toString());
    }

    public String getUrl() {
        return this.properties.get("url");
    }

    public void setUrl(String newUrl) {
        this.properties.put("url", newUrl);
    }

    public boolean hasCredentials() {
        String username = this.getUserName();
        String password = this.getPassword();
        return username != null && username.length() > 0 && password != null && password.length() > 0;
    }

    public String getUserName() {
        if (!this.isCachedUserName) {
            this.cachedUserName = this.getUserName(AuthenticationType.REPOSITORY);
            this.isCachedUserName = true;
        }
        return this.cachedUserName;
    }

    public String getPassword() {
        return this.getPassword(AuthenticationType.REPOSITORY);
    }

    public String getProxyUsername() {
        return this.getUserName(AuthenticationType.PROXY);
    }

    public String getProxyPassword() {
        return this.getPassword(AuthenticationType.PROXY);
    }

    public String getHttpUser() {
        return this.getUserName(AuthenticationType.HTTP);
    }

    public String getHttpPassword() {
        return this.getPassword(AuthenticationType.HTTP);
    }

    public void setAuthenticationCredentials(String username, String password) {
        this.setCredentials(AuthenticationType.REPOSITORY, username, password);
    }

    public void setProxyAuthenticationCredentials(String username, String password) {
        this.setCredentials(AuthenticationType.PROXY, username, password);
    }

    public void setHttpAuthenticationCredentials(String username, String password) {
        this.setCredentials(AuthenticationType.HTTP, username, password);
    }

    private void setCredentialsInternal(String username, String password, String userProperty, String passwordProperty) {
        Map<String, String> map = this.getAuthInfo();
        if (map == null) {
            map = new HashMap<String, String>();
        }
        if (username != null) {
            map.put(userProperty, username);
        }
        if (password != null) {
            map.put(passwordProperty, password);
        }
        this.addAuthInfo(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAuthenticationCredentials() {
        Object object = LOCK;
        synchronized (object) {
            this.isCachedUserName = false;
            this.transientProperties.clear();
            this.setProperty(String.valueOf(TaskRepository.getKeyPrefix(AuthenticationType.HTTP)) + ENABLED, null);
            this.setProperty(String.valueOf(TaskRepository.getKeyPrefix(AuthenticationType.PROXY)) + ENABLED, null);
            this.setProperty(String.valueOf(TaskRepository.getKeyPrefix(AuthenticationType.REPOSITORY)) + ENABLED, null);
            try {
                if (Platform.isRunning()) {
                    try {
                        Platform.flushAuthorizationInfo((URL)new URL(this.getUrl()), (String)AUTH_REALM, (String)AUTH_SCHEME);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Platform.flushAuthorizationInfo((URL)DEFAULT_URL, (String)this.getUrl(), (String)AUTH_SCHEME);
                    }
                } else {
                    Map<String, String> headlessCreds = this.getAuthInfo();
                    headlessCreds.clear();
                }
            }
            catch (CoreException e) {
                StatusHandler.fail((Throwable)e, (String)"could not flush authorization credentials", (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAuthInfo(Map<String, String> map) {
        Object object = LOCK;
        synchronized (object) {
            try {
                if (Platform.isRunning()) {
                    try {
                        Platform.addAuthorizationInfo((URL)new URL(this.getUrl()), (String)AUTH_REALM, (String)AUTH_SCHEME, map);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Platform.addAuthorizationInfo((URL)DEFAULT_URL, (String)this.getUrl(), (String)AUTH_SCHEME, map);
                    }
                } else {
                    Map<String, String> headlessCreds = this.getAuthInfo();
                    headlessCreds.putAll(map);
                }
            }
            catch (CoreException e) {
                StatusHandler.fail((Throwable)e, (String)"Could not set authorization credentials", (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getAuthInfo() {
        Object object = LOCK;
        synchronized (object) {
            if (Platform.isRunning()) {
                try {
                    return Platform.getAuthorizationInfo((URL)new URL(this.getUrl()), (String)AUTH_REALM, (String)AUTH_SCHEME);
                }
                catch (MalformedURLException malformedURLException) {
                    return Platform.getAuthorizationInfo((URL)DEFAULT_URL, (String)this.getUrl(), (String)AUTH_SCHEME);
                }
                catch (Exception e) {
                    StatusHandler.fail((Throwable)e, (String)"Could not retrieve authentication credentials", (boolean)false);
                }
            } else {
                Map<String, String> headlessCreds = credentials.get(this.getUrl());
                if (headlessCreds == null) {
                    headlessCreds = new HashMap<String, String>();
                    credentials.put(this.getUrl(), headlessCreds);
                }
                return headlessCreds;
            }
            return null;
        }
    }

    private String getAuthInfo(String property) {
        Map<String, String> map = this.getAuthInfo();
        return map == null ? null : map.get(property);
    }

    public void clearCredentials() {
    }

    public boolean equals(Object object) {
        if (object instanceof TaskRepository) {
            TaskRepository repository = (TaskRepository)((Object)object);
            if (this.getUrl() == null ? repository.getUrl() != null : !this.getUrl().equals(repository.getUrl())) {
                return false;
            }
            if (this.getConnectorKind() == null) {
                return repository.getConnectorKind() == null;
            }
            return this.getConnectorKind().equals(repository.getConnectorKind());
        }
        return super.equals(object);
    }

    public int hashCode() {
        int res = this.getUrl() == null ? 1 : this.getUrl().hashCode();
        return res * 31 + (this.getConnectorKind() == null ? 1 : this.getConnectorKind().hashCode());
    }

    public String toString() {
        return this.getUrl();
    }

    public String getConnectorKind() {
        String kind = this.properties.get("kind");
        if (kind != null) {
            return kind;
        }
        return "<unknown>";
    }

    public String getVersion() {
        String version = this.properties.get("version");
        return version == null || AUTH_REALM.equals(version) ? NO_VERSION_SPECIFIED : version;
    }

    public void setVersion(String ver) {
        this.properties.put("version", ver == null ? NO_VERSION_SPECIFIED : ver);
    }

    public String getCharacterEncoding() {
        String encoding = this.properties.get("encoding");
        return encoding == null || AUTH_REALM.equals(encoding) ? DEFAULT_CHARACTER_ENCODING : encoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.properties.put("encoding", characterEncoding == null ? DEFAULT_CHARACTER_ENCODING : characterEncoding);
    }

    public String getTimeZoneId() {
        String timeZoneId = this.properties.get("timezone");
        return timeZoneId == null || AUTH_REALM.equals(timeZoneId) ? TimeZone.getDefault().getID() : timeZoneId;
    }

    public void setTimeZoneId(String timeZoneId) {
        this.properties.put("timezone", timeZoneId == null ? TimeZone.getDefault().getID() : timeZoneId);
    }

    public String getSynchronizationTimeStamp() {
        return this.properties.get("lastsynctimestamp");
    }

    public void setSynchronizationTimeStamp(String syncTime) {
        this.properties.put("lastsynctimestamp", syncTime);
    }

    public void setRepositoryLabel(String repositoryLabel) {
        this.properties.put("label", repositoryLabel);
    }

    public String getRepositoryLabel() {
        String label = this.properties.get("label");
        if (label != null && label.length() > 0) {
            return label;
        }
        return this.getUrl();
    }

    public Map<String, String> getProperties() {
        return new LinkedHashMap<String, String>(this.properties);
    }

    public String getProperty(String name) {
        return this.properties.get(name);
    }

    public void setProperty(String name, String value) {
        this.properties.put(name, value);
    }

    public boolean hasProperty(String name) {
        String value = this.getProperty(name);
        return value != null && value.trim().length() > 0;
    }

    public void removeProperty(String key) {
        this.properties.remove(key);
    }

    public Proxy getProxy() {
        Proxy proxy = Proxy.NO_PROXY;
        if (this.isDefaultProxyEnabled()) {
            proxy = WebClientUtil.getPlatformProxy((String)this.getUrl());
        } else {
            String proxyHost = this.getProperty(PROXY_HOSTNAME);
            String proxyPort = this.getProperty(PROXY_PORT);
            String proxyUsername = AUTH_REALM;
            String proxyPassword = AUTH_REALM;
            if (proxyHost != null && proxyHost.length() > 0) {
                proxyUsername = this.getProxyUsername();
                proxyPassword = this.getProxyPassword();
            }
            proxy = WebClientUtil.getProxy((String)proxyHost, (String)proxyPort, (String)proxyUsername, (String)proxyPassword);
        }
        return proxy;
    }

    public boolean isDefaultProxyEnabled() {
        return "true".equals(this.getProperty(PROXY_USEDEFAULT));
    }

    public void setAnonymous(boolean b) {
        this.properties.put(ANONYMOUS_LOGIN, String.valueOf(b));
    }

    public boolean isAnonymous() {
        return this.getProperty(ANONYMOUS_LOGIN) == null || "true".equals(this.getProperty(ANONYMOUS_LOGIN));
    }

    public boolean isBugRepository() {
        return this.isBugRepository;
    }

    public void setBugRepository(boolean isBugRepository) {
        this.isBugRepository = isBugRepository;
    }

    public void setOffline(boolean offline) {
        this.properties.put(OFFLINE, String.valueOf(offline));
    }

    public boolean isOffline() {
        return this.getProperty(OFFLINE) != null && "true".equals(this.getProperty(OFFLINE));
    }

    public boolean getSavePassword(AuthenticationType authType) {
        String value = this.getProperty(String.valueOf(TaskRepository.getKeyPrefix(authType)) + SAVE_PASSWORD);
        return value != null && "true".equals(value);
    }

    private static String getKeyPrefix(AuthenticationType type) {
        switch (type) {
            case HTTP: {
                return AUTH_HTTP;
            }
            case PROXY: {
                return AUTH_PROXY;
            }
            case REPOSITORY: {
                return AUTH_REPOSITORY;
            }
        }
        throw new IllegalArgumentException("Unknown authentication type: " + type);
    }

    public synchronized AuthenticationCredentials getCredentials(AuthenticationType authType) {
        String key = TaskRepository.getKeyPrefix(authType);
        String enabled = this.getProperty(String.valueOf(key) + ENABLED);
        if (enabled == null || "true".equals(enabled)) {
            String userName = this.getAuthInfo(String.valueOf(key) + USERNAME);
            String savePassword = this.getProperty(String.valueOf(key) + SAVE_PASSWORD);
            String password = savePassword != null && "true".equals(savePassword) ? this.getAuthInfo(String.valueOf(key) + PASSWORD) : this.transientProperties.get(String.valueOf(key) + PASSWORD);
            if (userName == null) {
                userName = AUTH_REALM;
            }
            if (password == null) {
                password = AUTH_REALM;
            }
            if (enabled == null && userName.length() == 0) {
                return null;
            }
            return new AuthenticationCredentials(userName, password);
        }
        return null;
    }

    public synchronized void setCredentials(AuthenticationType authType, AuthenticationCredentials credentials, boolean savePassword) {
        String key = TaskRepository.getKeyPrefix(authType);
        this.setProperty(String.valueOf(key) + SAVE_PASSWORD, String.valueOf(savePassword));
        if (credentials == null) {
            this.setProperty(String.valueOf(key) + ENABLED, String.valueOf(false));
            this.transientProperties.remove(String.valueOf(key) + PASSWORD);
            this.setCredentialsInternal(AUTH_REALM, AUTH_REALM, String.valueOf(key) + USERNAME, String.valueOf(key) + PASSWORD);
        } else {
            this.setProperty(String.valueOf(key) + ENABLED, String.valueOf(true));
            if (savePassword) {
                this.setCredentialsInternal(credentials.getUserName(), credentials.getPassword(), String.valueOf(key) + USERNAME, String.valueOf(key) + PASSWORD);
                this.transientProperties.remove(String.valueOf(key) + PASSWORD);
            } else {
                this.setCredentialsInternal(credentials.getUserName(), AUTH_REALM, String.valueOf(key) + USERNAME, String.valueOf(key) + PASSWORD);
                this.transientProperties.put(String.valueOf(key) + PASSWORD, credentials.getPassword());
            }
        }
        if (authType == AuthenticationType.REPOSITORY) {
            if (credentials == null) {
                this.cachedUserName = null;
                this.isCachedUserName = false;
            } else {
                this.cachedUserName = credentials.getUserName();
                this.isCachedUserName = true;
            }
        }
    }

    private void setCredentials(AuthenticationType type, String username, String password) {
        if (username == null) {
            this.setCredentials(type, null, true);
        } else {
            this.setCredentials(type, new AuthenticationCredentials(username, password), true);
        }
    }

    private String getUserName(AuthenticationType authType) {
        AuthenticationCredentials credentials = this.getCredentials(authType);
        return credentials != null ? credentials.getUserName() : null;
    }

    private String getPassword(AuthenticationType authType) {
        AuthenticationCredentials credentials = this.getCredentials(authType);
        return credentials != null ? credentials.getPassword() : null;
    }

    public final Date getConfigurationDate() {
        Date configDate = null;
        String value = this.getProperty(PROPERTY_CONFIG_TIMESTAMP);
        try {
            configDate = new Date(Long.valueOf(value));
        }
        catch (Exception exception) {}
        return configDate;
    }

    public final void setConfigurationDate(Date date) {
        this.setProperty(PROPERTY_CONFIG_TIMESTAMP, String.valueOf(date.getTime()));
    }
}

