/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskElementLabelProvider;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

public class TaskLabelDecorator
implements ILightweightLabelDecorator {
    public void decorate(Object element, IDecoration decoration) {
        ImageDescriptor overlay;
        ImageDescriptor priorityOverlay = TaskElementLabelProvider.getPriorityImageDescriptor(element);
        if (priorityOverlay != null) {
            decoration.addOverlay(priorityOverlay, 2);
        }
        if (element instanceof AbstractRepositoryQuery) {
            AbstractRepositoryQuery query = (AbstractRepositoryQuery)element;
            String repositoryUrl = query.getRepositoryUrl();
            TaskRepository taskRepository = TasksUiPlugin.getRepositoryManager().getRepository(repositoryUrl);
            if (repositoryUrl != null && taskRepository != null) {
                if (taskRepository.getUrl().equals(taskRepository.getRepositoryLabel())) {
                    try {
                        URL url = new URL(repositoryUrl);
                        decoration.addSuffix("   [" + url.getHost() + "]");
                    }
                    catch (MalformedURLException malformedURLException) {
                        decoration.addSuffix("   [ <unknown host> ]");
                    }
                } else {
                    decoration.addSuffix("   [" + taskRepository.getRepositoryLabel() + "]");
                }
            }
        } else if (element instanceof AbstractTask) {
            AbstractTask task = (AbstractTask)element;
            if (!task.isCompleted() && TaskActivityManager.getInstance().isOverdue(task)) {
                decoration.addOverlay(TasksUiImages.OVERLAY_OVER_DUE, 1);
            } else if (!task.isCompleted() && task.getDueDate() != null) {
                decoration.addOverlay(TasksUiImages.OVERLAY_HAS_DUE, 1);
            }
        } else if (element instanceof AbstractTask) {
            AbstractTask task = (AbstractTask)element;
            if (!task.isCompleted() && TaskActivityManager.getInstance().isOverdue(task)) {
                decoration.addOverlay(TasksUiImages.OVERLAY_OVER_DUE, 1);
            }
        } else if (element instanceof TaskRepository && (overlay = TasksUiPlugin.getDefault().getOverlayIcon(((TaskRepository)element).getConnectorKind())) != null) {
            decoration.addOverlay(overlay, 3);
        }
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

