/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.internal.tasks.ui.ScheduledTaskListSynchJob;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskListSynchronizationScheduler
implements IPropertyChangeListener {
    private static final int DELAY_QUERY_REFRESH_ON_STARTUP = 20000;
    private ScheduledTaskListSynchJob refreshJob;
    private List<ScheduledTaskListSynchJob> jobs = new ArrayList<ScheduledTaskListSynchJob>();
    private List<ScheduledTaskListSynchJob> jobsQueue = Collections.synchronizedList(this.jobs);
    private final MutexRule rule = new MutexRule();

    public TaskListSynchronizationScheduler(boolean refreshOnStartup) {
        boolean enabled = TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule");
        if (refreshOnStartup && enabled) {
            this.addJobToQueue(new ScheduledTaskListSynchJob(20000L, TasksUiPlugin.getTaskListManager()));
        }
    }

    public synchronized void startSynchJob() {
        if (this.jobsQueue.size() == 0) {
            this.scheduleRegularSynchronizationJob();
        }
        if (this.jobsQueue.size() > 0) {
            this.refreshJob = this.jobsQueue.remove(0);
            if (!TasksUiPlugin.getSynchronizationManager().isForcedSyncExec()) {
                this.refreshJob.schedule(this.refreshJob.getScheduleDelay());
            } else {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

                    public void run() {
                        TaskListSynchronizationScheduler.this.refreshJob.run((IProgressMonitor)new NullProgressMonitor());
                    }
                });
            }
        }
    }

    private void scheduleRegularSynchronizationJob() {
        if (TasksUiPlugin.getDefault() == null) {
            return;
        }
        boolean enabled = TasksUiPlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule");
        if (enabled) {
            long miliseconds = TasksUiPlugin.getDefault().getPreferenceStore().getLong("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds");
            this.refreshJob = new ScheduledTaskListSynchJob(miliseconds, TasksUiPlugin.getTaskListManager());
            this.refreshJob.setRule(this.rule);
            this.addJobToQueue(this.refreshJob);
        }
    }

    private void addJobToQueue(final ScheduledTaskListSynchJob jobToAdd) {
        jobToAdd.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void done(IJobChangeEvent event) {
                ScheduledTaskListSynchJob scheduledTaskListSynchJob = TaskListSynchronizationScheduler.this.refreshJob;
                synchronized (scheduledTaskListSynchJob) {
                    if (TaskListSynchronizationScheduler.this.refreshJob == jobToAdd && event.getResult() != Status.CANCEL_STATUS) {
                        TaskListSynchronizationScheduler.this.startSynchJob();
                    }
                }
            }
        });
        this.jobsQueue.add(jobToAdd);
    }

    public void synchNow(long delay, List<TaskRepository> repositories, boolean fullSynchronization) {
        this.cancelAll();
        ScheduledTaskListSynchJob job = new ScheduledTaskListSynchJob(delay, TasksUiPlugin.getTaskListManager());
        job.setRepositories(repositories);
        job.setFullSynchronization(fullSynchronization);
        this.addJobToQueue(job);
        this.startSynchJob();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule") || event.getProperty().equals("org.eclipse.mylyn.tasks.ui.repositories.synch.schedule.miliseconds")) {
            this.cancelAll();
            this.startSynchJob();
        }
    }

    public ScheduledTaskListSynchJob getRefreshJob() {
        return this.refreshJob;
    }

    public void cancelAll() {
        this.jobsQueue.clear();
        if (this.refreshJob != null) {
            this.refreshJob.cancel();
        }
    }

    static class MutexRule
    implements ISchedulingRule {
        MutexRule() {
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

