/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoryLocation;
import org.eclipse.mylyn.internal.tasks.ui.dialogs.EditCredentialsDialog;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.web.core.AbstractWebLocation;
import org.eclipse.mylyn.web.core.AuthenticationCredentials;
import org.eclipse.mylyn.web.core.AuthenticationType;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TaskRepositoryLocationUi
extends TaskRepositoryLocation {
    private static Object lock = new Object();

    public TaskRepositoryLocationUi(TaskRepository taskRepository) {
        super(taskRepository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractWebLocation.ResultType requestCredentials(AuthenticationType authType, String message) {
        AuthenticationCredentials oldCredentials = this.taskRepository.getCredentials(authType);
        Object object = lock;
        synchronized (object) {
            if (!this.areEqual(oldCredentials, this.taskRepository.getCredentials(authType))) {
                return AbstractWebLocation.ResultType.CREDENTIALS_CHANGED;
            }
            PasswordRunner runner = new PasswordRunner(authType, message);
            PlatformUI.getWorkbench().getDisplay().syncExec((Runnable)runner);
            if (runner.isCancelled()) {
                throw new OperationCanceledException();
            }
            return runner.getResult();
        }
    }

    private boolean areEqual(AuthenticationCredentials oldCredentials, AuthenticationCredentials credentials) {
        if (oldCredentials == null) {
            return credentials == null;
        }
        return oldCredentials.equals((Object)credentials);
    }

    private class PasswordRunner
    implements Runnable {
        private final AuthenticationType authType;
        private boolean canceled;
        private AbstractWebLocation.ResultType result;
        private final String message;

        public PasswordRunner(AuthenticationType credentialType, String message) {
            this.authType = credentialType;
            this.message = message;
        }

        public boolean isCancelled() {
            return this.canceled;
        }

        public AbstractWebLocation.ResultType getResult() {
            return this.result;
        }

        public void run() {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (shell != null && !shell.isDisposed()) {
                EditCredentialsDialog dialog = new EditCredentialsDialog(shell);
                this.initializeDialog(dialog);
                if (dialog.open() == 0) {
                    this.saveDialog(dialog);
                    this.result = AbstractWebLocation.ResultType.CREDENTIALS_CHANGED;
                    this.canceled = false;
                } else {
                    this.canceled = true;
                }
            }
        }

        private void initializeDialog(EditCredentialsDialog dialog) {
            dialog.setUrl(TaskRepositoryLocationUi.this.taskRepository.getRepositoryLabel());
            AuthenticationCredentials credentials = TaskRepositoryLocationUi.this.taskRepository.getCredentials(this.authType);
            if (credentials != null) {
                dialog.setUsername(credentials.getUserName());
                dialog.setPassword(credentials.getPassword());
            }
            if (this.message != null) {
                dialog.setMessage(this.message);
            } else {
                dialog.setMessage(this.getDefaultMessage());
            }
        }

        private String getDefaultMessage() {
            if (AuthenticationType.REPOSITORY.equals((Object)this.authType)) {
                return "Please enter repository password";
            }
            if (AuthenticationType.HTTP.equals((Object)this.authType)) {
                return "Please enter HTTP password";
            }
            if (AuthenticationType.PROXY.equals((Object)this.authType)) {
                return "Please enter proxy password";
            }
            return null;
        }

        private void saveDialog(EditCredentialsDialog dialog) {
            if (AuthenticationType.REPOSITORY.equals((Object)this.authType)) {
                TaskRepositoryLocationUi.this.taskRepository.setAnonymous(false);
            }
            AuthenticationCredentials credentials = new AuthenticationCredentials(dialog.getUserName(), dialog.getPassword());
            TaskRepositoryLocationUi.this.taskRepository.setCredentials(this.authType, credentials, dialog.getSavePassword());
            TasksUiPlugin.getRepositoryManager().notifyRepositorySettingsChanged(TaskRepositoryLocationUi.this.taskRepository);
            TasksUiPlugin.getRepositoryManager().saveRepositories(TasksUiPlugin.getDefault().getRepositoriesFilePath());
        }
    }
}

