/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.mylyn.internal.tasks.ui.IDynamicSubMenuContributor;
import org.eclipse.mylyn.internal.tasks.ui.actions.ClearOutgoingAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.MarkTaskCompleteAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.MarkTaskIncompleteAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.MarkTaskReadAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.MarkTaskUnreadAction;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskStatusMenuContributor
implements IDynamicSubMenuContributor {
    private static final String LABEL = "Mark";

    @Override
    public MenuManager getSubMenuManager(List<AbstractTaskContainer> selectedElements) {
        MenuManager subMenuManager = new MenuManager(LABEL);
        AbstractTask singleTask = null;
        if (selectedElements.size() == 1 && selectedElements.get(0) instanceof AbstractTask) {
            singleTask = (AbstractTask)selectedElements.get(0);
        }
        Action action = new MarkTaskCompleteAction(selectedElements);
        if (singleTask != null && singleTask.isCompleted()) {
            action.setEnabled(false);
        }
        subMenuManager.add((IAction)action);
        action = new MarkTaskIncompleteAction(selectedElements);
        subMenuManager.add((IAction)action);
        if (singleTask != null && !singleTask.isCompleted()) {
            action.setEnabled(false);
        }
        subMenuManager.add((IContributionItem)new Separator());
        action = new MarkTaskReadAction(selectedElements);
        subMenuManager.add((IAction)action);
        action = new MarkTaskUnreadAction(selectedElements);
        subMenuManager.add((IAction)action);
        action = new ClearOutgoingAction(selectedElements);
        subMenuManager.add((IAction)action);
        return subMenuManager;
    }
}

