/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.mylyn.internal.tasks.core.LocalTask;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskArchive;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.ui.IWorkingSet;

public class TaskWorkingSetFilter
extends AbstractTaskListFilter {
    private final TaskList taskList;
    private IAdaptable[] elements;

    public TaskWorkingSetFilter(TaskList taskList) {
        this.taskList = taskList;
    }

    public boolean select(Object parent, Object element) {
        Set queries;
        Iterator iterator;
        if (parent instanceof AbstractTask || element instanceof TaskArchive) {
            return true;
        }
        if (parent == null && element instanceof AbstractTaskContainer) {
            return this.isContainedInWorkingSet((AbstractTaskContainer)element);
        }
        if (!(parent instanceof TaskArchive) && parent instanceof AbstractTaskContainer && !(parent instanceof ScheduledTaskContainer)) {
            return this.isContainedInWorkingSet((AbstractTaskContainer)parent);
        }
        if (element instanceof LocalTask && (iterator = ((LocalTask)element).getParentContainers().iterator()).hasNext()) {
            AbstractTaskContainer container = (AbstractTaskContainer)iterator.next();
            return this.isContainedInWorkingSet(container);
        }
        if (parent instanceof ScheduledTaskContainer && element instanceof AbstractTask && !(queries = this.taskList.getQueriesForHandle(((AbstractTask)element).getHandleIdentifier())).isEmpty()) {
            for (AbstractRepositoryQuery query : queries) {
                if (!this.isContainedInWorkingSet((AbstractTaskContainer)query)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isContainedInWorkingSet(AbstractTaskContainer container) {
        if (this.elements == null) {
            return true;
        }
        boolean seenTaskWorkingSets = false;
        String handleIdentifier = container.getHandleIdentifier();
        IAdaptable[] iAdaptableArray = this.elements;
        int n = this.elements.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable adaptable = iAdaptableArray[n2];
            if (adaptable instanceof AbstractTaskContainer) {
                seenTaskWorkingSets = true;
                if (handleIdentifier.equals(((AbstractTaskContainer)adaptable).getHandleIdentifier())) {
                    return true;
                }
            }
            ++n2;
        }
        return !seenTaskWorkingSets;
    }

    public boolean updateWorkingSet(IWorkingSet currentWorkingSet) {
        Object[] newElements = currentWorkingSet.getElements();
        if (!Arrays.equals(this.elements, newElements)) {
            this.elements = newElements;
            return true;
        }
        return false;
    }

    public IAdaptable[] getElements() {
        return this.elements;
    }
}

