/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import org.eclipse.jface.wizard.IWizard;
import org.eclipse.mylyn.internal.tasks.ui.actions.AbstractTaskEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizardDialog;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;

public class AttachAction
extends AbstractTaskEditorAction {
    public static final String LABEL = "Attach...";

    public AttachAction() {
        super(LABEL);
        this.setId("org.eclipse.mylyn.tasks.ui.actions.add.attachment");
        this.setImageDescriptor(WorkbenchImages.getImageDescriptor((String)"IMG_OBJ_FILE"));
    }

    public void run() {
        Object selection;
        if (this.editor != null) {
            this.editor.showBusy(true);
        }
        if ((selection = this.getStructuredSelection().getFirstElement()) instanceof AbstractTask) {
            if (this.taskDirty((AbstractTask)selection)) {
                this.openInformationDialog(LABEL, "Submit changes or synchronize task before adding attachments.");
                return;
            }
            AbstractTask repositoryTask = (AbstractTask)selection;
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(repositoryTask.getConnectorKind(), repositoryTask.getRepositoryUrl());
            NewAttachmentWizard attachmentWizard = new NewAttachmentWizard(repository, repositoryTask);
            NewAttachmentWizardDialog dialog = new NewAttachmentWizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)attachmentWizard, true);
            attachmentWizard.setDialog(dialog);
            dialog.create();
            int result = dialog.open();
            if (result != 0 && this.editor != null) {
                this.editor.showBusy(false);
            }
        }
    }
}

