/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class GoToUnreadTaskAction
extends Action
implements IViewActionDelegate,
IWorkbenchWindowActionDelegate {
    public static final String ID_NEXT = "org.eclipse.mylyn.tasklist.actions.goToNextUnread";
    public static final String ID_PREVIOUS = "org.eclipse.mylyn.tasklist.actions.goToPreviousUnread";
    private TaskListView taskListView;
    private Direction direction = Direction.DOWN;

    public void init(IViewPart view) {
        this.taskListView = (TaskListView)view;
    }

    public void run() {
        TreeViewer treeViewer;
        if (this.taskListView == null) {
            TaskListView activeTaskListView = TaskListView.getFromActivePerspective();
            if (activeTaskListView == null) {
                return;
            }
            treeViewer = activeTaskListView.getViewer();
        } else {
            treeViewer = this.taskListView.getViewer();
        }
        Tree tree = treeViewer.getTree();
        TreePath treePath = null;
        try {
            tree.setRedraw(false);
            treePath = this.getUnreadItem(treeViewer, tree);
        }
        finally {
            tree.setRedraw(true);
        }
        if (treePath != null) {
            treeViewer.expandToLevel((Object)treePath, 0);
            treeViewer.setSelection((ISelection)new TreeSelection(treePath), true);
        }
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    private TreePath getTreePath(TreeItem item) {
        ArrayList<Object> path = new ArrayList<Object>();
        do {
            path.add(0, item.getData());
        } while ((item = item.getParentItem()) != null);
        return new TreePath(path.toArray());
    }

    private TreePath getUnreadItem(TreeViewer treeViewer, Tree tree) {
        TreeItem[] selection = tree.getSelection();
        TreeItem selectedItem = selection.length > 0 ? selection[0] : null;
        Visitor visitor = new Visitor(){

            public boolean visit(Object object) {
                AbstractTask task;
                return object instanceof AbstractTask && (task = (AbstractTask)object).getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.INCOMING;
            }
        };
        TreePath unreadItem = null;
        if (selectedItem != null) {
            if (this.direction == Direction.DOWN) {
                unreadItem = this.visitChildren(treeViewer, this.getTreePath(selectedItem), selectedItem, visitor);
            }
            if (unreadItem == null) {
                unreadItem = this.visitSiblings(treeViewer, selectedItem, visitor);
            }
        } else {
            unreadItem = this.visitItems(treeViewer, TreePath.EMPTY, tree.getItems(), null, visitor);
        }
        return unreadItem;
    }

    private TreePath visitSiblings(TreeViewer viewer, TreeItem item, Visitor visitor) {
        TreePath path;
        TreeItem[] siblings;
        TreeItem parent = item.getParentItem();
        if (parent != null) {
            siblings = parent.getItems();
            path = this.getTreePath(parent);
        } else {
            siblings = viewer.getTree().getItems();
            path = TreePath.EMPTY;
        }
        return this.visitItems(viewer, path, siblings, item, visitor);
    }

    private TreePath visitItems(TreeViewer viewer, TreePath parentPath, TreeItem[] items, TreeItem visitedItem, Visitor visitor) {
        TreeItem parent;
        if (this.direction == Direction.UP) {
            Collections.reverse(Arrays.asList(items));
        }
        boolean found = visitedItem == null;
        TreeItem[] treeItemArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem item = treeItemArray[n2];
            if (!found) {
                if (item == visitedItem) {
                    found = true;
                }
            } else {
                TreePath itemPath = parentPath.createChildPath(item.getData());
                if (this.direction == Direction.DOWN && visitor.visit(item.getData())) {
                    return itemPath;
                }
                TreePath childPath = this.visitChildren(viewer, itemPath, item, visitor);
                if (childPath != null) {
                    return childPath;
                }
                if (this.direction == Direction.UP && visitor.visit(item.getData())) {
                    return itemPath;
                }
            }
            ++n2;
        }
        if (visitedItem != null && (parent = visitedItem.getParentItem()) != null) {
            if (this.direction == Direction.UP && visitor.visit(parent.getData())) {
                return parentPath;
            }
            return this.visitSiblings(viewer, parent, visitor);
        }
        return null;
    }

    private TreePath visitChildren(TreeViewer viewer, TreePath itemPath, TreeItem item, Visitor visitor) {
        TreePath childPath;
        TreeItem[] children;
        boolean expandedState = item.getExpanded();
        if (!expandedState) {
            viewer.setExpandedState((Object)itemPath, true);
        }
        if ((children = item.getItems()).length > 0 && (childPath = this.visitItems(viewer, itemPath, children, null, visitor)) != null) {
            return childPath;
        }
        viewer.setExpandedState((Object)itemPath, expandedState);
        return null;
    }

    public void run(IAction action) {
        if (ID_PREVIOUS.equals(action.getId())) {
            this.setDirection(Direction.UP);
        } else {
            this.setDirection(Direction.DOWN);
        }
        this.run();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        UP,
        DOWN;

    }

    private abstract class Visitor {
        private Visitor() {
        }

        public abstract boolean visit(Object var1);
    }
}

