/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewLocalTaskWizard;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewTaskWizard;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskSelection;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRepositoryTaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class NewTaskAction
extends Action
implements IViewActionDelegate,
IExecutableExtension {
    public static final String ID = "org.eclipse.mylyn.tasklist.ui.repositories.actions.create";
    private boolean skipRepositoryPage = false;
    private boolean localTask = false;
    private boolean supportsTaskSelection;

    public void run() {
        this.showWizard(null);
    }

    public int showWizard(TaskSelection taskSelection) {
        Wizard wizard;
        List repositories = TasksUiPlugin.getRepositoryManager().getAllRepositories();
        if (this.localTask) {
            wizard = new NewLocalTaskWizard(taskSelection);
        } else {
            TaskRepository taskRepository = null;
            if (repositories.size() == 1) {
                taskRepository = (TaskRepository)repositories.get(0);
            } else if (this.skipRepositoryPage) {
                taskRepository = TasksUiUtil.getSelectedRepository();
            }
            if (taskRepository != null) {
                AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(taskRepository.getConnectorKind());
                wizard = this.createNewTaskWizard(connectorUi, taskRepository, taskSelection);
            } else {
                wizard = new NewTaskWizard(taskSelection);
            }
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        if (shell != null && !shell.isDisposed()) {
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            dialog.setBlockOnOpen(true);
            dialog.create();
            if (!(wizard instanceof NewTaskWizard) && wizard.canFinish()) {
                wizard.performFinish();
                if (!this.supportsTaskSelection) {
                    this.handleSelection(taskSelection);
                }
                return 0;
            }
            int result = dialog.open();
            if (result == 0) {
                if (wizard instanceof NewTaskWizard) {
                    this.supportsTaskSelection = ((NewTaskWizard)wizard).supportsTaskSelection();
                }
                if (!this.supportsTaskSelection) {
                    this.handleSelection(taskSelection);
                }
            }
            return result;
        }
        return 1;
    }

    private IWizard createNewTaskWizard(AbstractRepositoryConnectorUi connectorUi, TaskRepository taskRepository, TaskSelection taskSelection) {
        IWizard wizard = connectorUi.getNewTaskWizard(taskRepository, taskSelection);
        if (wizard == null) {
            wizard = connectorUi.getNewTaskWizard(taskRepository);
            this.supportsTaskSelection = false;
        } else {
            this.supportsTaskSelection = true;
        }
        return wizard;
    }

    private void handleSelection(final TaskSelection taskSelection) {
        if (taskSelection == null) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                TaskEditor taskEditor;
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (page == null) {
                    return;
                }
                RepositoryTaskData taskData = taskSelection.getTaskData();
                String summary = taskData.getSummary();
                String description = taskData.getDescription();
                if (page.getActiveEditor() instanceof TaskEditor && (taskEditor = (TaskEditor)page.getActiveEditor()).getActivePageInstance() instanceof AbstractRepositoryTaskEditor) {
                    AbstractRepositoryTaskEditor repositoryTaskEditor = (AbstractRepositoryTaskEditor)taskEditor.getActivePageInstance();
                    repositoryTaskEditor.setSummaryText(summary);
                    repositoryTaskEditor.setDescriptionText(description);
                    return;
                }
                Clipboard clipboard = new Clipboard(page.getWorkbenchWindow().getShell().getDisplay());
                clipboard.setContents(new Object[]{String.valueOf(summary) + "\n" + description}, new Transfer[]{TextTransfer.getInstance()});
                MessageDialog.openInformation((Shell)page.getWorkbenchWindow().getShell(), (String)"Mylyn Information", (String)"This connector does not provide a rich task editor for creating tasks.\n\nThe error contents have been placed in the clipboard so that you can paste them into the entry form.");
            }
        });
    }

    public void run(IAction action) {
        this.run();
    }

    public void init(IViewPart view) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if ("skipFirstPage".equals(data)) {
            this.skipRepositoryPage = true;
        }
        if ("local".equals(data)) {
            this.localTask = true;
        }
    }
}

