/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.RepositorySynchronizationManager;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.ActionDelegate;
import org.eclipse.ui.actions.ActionFactory;

public class SynchronizeSelectedAction
extends ActionDelegate
implements IViewActionDelegate {
    private Map<AbstractRepositoryConnector, List<AbstractRepositoryQuery>> queriesToSyncMap = new LinkedHashMap<AbstractRepositoryConnector, List<AbstractRepositoryQuery>>();
    private Map<AbstractRepositoryConnector, List<AbstractTask>> tasksToSyncMap = new LinkedHashMap<AbstractRepositoryConnector, List<AbstractTask>>();
    private IAction action;

    public void run(IAction action) {
        if (TaskListView.getFromActivePerspective() != null) {
            List<Object> queriesToSync;
            ISelection selection = TaskListView.getFromActivePerspective().getViewer().getSelection();
            for (Object obj : ((IStructuredSelection)selection).toList()) {
                Object client;
                if (obj instanceof AbstractRepositoryQuery) {
                    AbstractRepositoryQuery abstractRepositoryQuery = (AbstractRepositoryQuery)obj;
                    client = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(abstractRepositoryQuery.getRepositoryKind());
                    if (client == null) continue;
                    queriesToSync = this.queriesToSyncMap.get(client);
                    if (queriesToSync == null) {
                        queriesToSync = new ArrayList<AbstractRepositoryQuery>();
                        this.queriesToSyncMap.put((AbstractRepositoryConnector)client, queriesToSync);
                    }
                    queriesToSync.add(abstractRepositoryQuery);
                    continue;
                }
                if (obj instanceof TaskCategory) {
                    TaskCategory taskCategory = (TaskCategory)obj;
                    for (AbstractTask task : taskCategory.getChildren()) {
                        AbstractRepositoryConnector abstractRepositoryConnector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(task.getConnectorKind());
                        this.addTaskToSync(abstractRepositoryConnector, task);
                    }
                    continue;
                }
                if (!(obj instanceof AbstractTask)) continue;
                AbstractTask abstractTask = (AbstractTask)obj;
                client = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(abstractTask.getConnectorKind());
                this.addTaskToSync((AbstractRepositoryConnector)client, abstractTask);
            }
            RepositorySynchronizationManager syncManager = TasksUiPlugin.getSynchronizationManager();
            if (!this.queriesToSyncMap.isEmpty()) {
                HashMap<TaskRepository, HashSet<AbstractRepositoryQuery>> repositoriesToSync = new HashMap<TaskRepository, HashSet<AbstractRepositoryQuery>>();
                for (AbstractRepositoryConnector abstractRepositoryConnector : this.queriesToSyncMap.keySet()) {
                    queriesToSync = this.queriesToSyncMap.get(abstractRepositoryConnector);
                    if (queriesToSync == null || queriesToSync.isEmpty()) continue;
                    for (AbstractRepositoryQuery abstractRepositoryQuery : queriesToSync) {
                        TaskRepository repos = TasksUiPlugin.getRepositoryManager().getRepository(abstractRepositoryQuery.getRepositoryKind(), abstractRepositoryQuery.getRepositoryUrl());
                        HashSet<AbstractRepositoryQuery> queries = (HashSet<AbstractRepositoryQuery>)repositoriesToSync.get(repos);
                        if (queries == null) {
                            queries = new HashSet<AbstractRepositoryQuery>();
                            repositoriesToSync.put(repos, queries);
                        }
                        queries.add(abstractRepositoryQuery);
                    }
                }
                for (Map.Entry entry : repositoriesToSync.entrySet()) {
                    TaskRepository repository = (TaskRepository)entry.getKey();
                    AbstractRepositoryConnector abstractRepositoryConnector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
                    Set queries = (Set)entry.getValue();
                    syncManager.synchronize(abstractRepositoryConnector, repository, queries, null, 30, 0L, true);
                }
            }
            if (!this.tasksToSyncMap.isEmpty()) {
                for (AbstractRepositoryConnector connector : this.tasksToSyncMap.keySet()) {
                    List<AbstractTask> tasksToSync = this.tasksToSyncMap.get(connector);
                    if (tasksToSync == null || tasksToSync.size() <= 0) continue;
                    syncManager.synchronize(connector, new HashSet<AbstractTask>(tasksToSync), true, null);
                }
            }
        }
        this.queriesToSyncMap.clear();
        this.tasksToSyncMap.clear();
    }

    private void addTaskToSync(AbstractRepositoryConnector client, AbstractTask repositoryTask) {
        if (client != null) {
            List<AbstractTask> tasksToSync = this.tasksToSyncMap.get(client);
            if (tasksToSync == null) {
                tasksToSync = new ArrayList<AbstractTask>();
                this.tasksToSyncMap.put(client, tasksToSync);
            }
            tasksToSync.add(repositoryTask);
        }
    }

    public void init(IAction action) {
        this.action = action;
    }

    public void init(IViewPart view) {
        IActionBars actionBars = view.getViewSite().getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.REFRESH.getId(), this.action);
        actionBars.updateActionBars();
    }
}

