/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.actions;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.mylyn.internal.tasks.ui.TaskListColorsAndFonts;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskActivationHistory;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskDetailLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskElementLabelProvider;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.search.internal.ui.SearchDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class TaskSelectionDialog
extends FilteredItemsSelectionDialog {
    private Button openInBrowserCheck;
    private static final String TASK_SELECTION_DIALOG_SECTION = "TaskSelectionDialogSection";
    private static final String OPEN_IN_BROWSER_SETTING = "OpenInBrowser";
    private static final String SHOW_COMPLETED_TASKS_SETTING = "ShowCompletedTasks";
    private boolean openInBrowser;
    private boolean insertInHistory;
    private TaskElementLabelProvider labelProvider;
    private boolean showExtendedOpeningOptions;
    private ShowCompletedTasksAction showCompletedTasksAction = new ShowCompletedTasksAction();
    private boolean showCompletedTasks;
    private Set<AbstractTask> allTasks;

    public boolean getOpenInBrowser() {
        return this.openInBrowser;
    }

    public void setOpenInBrowser(boolean openInBrowser) {
        this.openInBrowser = openInBrowser;
    }

    public void setInsertInHistory(boolean insertInHistory) {
        this.insertInHistory = insertInHistory;
    }

    public boolean getInsertInHistory() {
        return this.insertInHistory;
    }

    public TaskSelectionDialog(Shell parent) {
        super(parent);
        this.setSelectionHistory(new TaskSelectionHistory());
        this.labelProvider = new TaskElementLabelProvider(false);
        this.setListLabelProvider((ILabelProvider)this.labelProvider);
        this.setDetailsLabelProvider(new TaskDetailLabelProvider());
        this.setSeparatorLabel("Task List matches");
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection selection = window.getSelectionService().getSelection();
        if (selection instanceof ITextSelection) {
            String text = ((ITextSelection)selection).getText();
            int n = text.indexOf(10);
            if (n > -1) {
                text.substring(0, n);
            }
            this.setInitialPattern(text);
        }
    }

    public void setShowExtendedOpeningOptions(boolean showExtendedOpeningOptions) {
        this.showExtendedOpeningOptions = showExtendedOpeningOptions;
    }

    public boolean getShowExtendedOpeningOptions() {
        return this.showExtendedOpeningOptions;
    }

    protected void fillViewMenu(IMenuManager menuManager) {
        super.fillViewMenu(menuManager);
        menuManager.add((IAction)this.showCompletedTasksAction);
    }

    protected Control createExtendedContentArea(Composite parent) {
        if (!this.showExtendedOpeningOptions) {
            return null;
        }
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 5).create());
        composite.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.openInBrowserCheck = new Button(composite, 32);
        this.openInBrowserCheck.setText("Open with &Browser");
        this.openInBrowserCheck.setSelection(this.openInBrowser);
        ImageHyperlink openHyperlink = new ImageHyperlink(composite, 0);
        openHyperlink.setText("Search repository for key or summary...");
        openHyperlink.setForeground(TaskListColorsAndFonts.COLOR_HYPERLINK_WIDGET);
        openHyperlink.setUnderlined(true);
        openHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                TaskSelectionDialog.this.getShell().close();
                new SearchDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow(), "org.eclipse.mylyn.tasks.ui.search.page").open();
            }
        });
        return composite;
    }

    public boolean close() {
        if (this.openInBrowserCheck != null) {
            this.openInBrowser = this.openInBrowserCheck.getSelection();
        }
        return super.close();
    }

    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
        return new TasksFilter(this.showCompletedTasks);
    }

    protected void fillContentProvider(FilteredItemsSelectionDialog.AbstractContentProvider contentProvider, FilteredItemsSelectionDialog.ItemsFilter itemsFilter, IProgressMonitor progressMonitor) throws CoreException {
        progressMonitor.beginTask("Search for tasks", 100);
        if (this.allTasks == null) {
            this.allTasks = new HashSet<AbstractTask>();
            TaskList taskList = TasksUiPlugin.getTaskListManager().getTaskList();
            this.allTasks.addAll(taskList.getAllTasks());
        }
        progressMonitor.worked(10);
        SubProgressMonitor subMonitor = new SubProgressMonitor(progressMonitor, 90);
        subMonitor.beginTask("Scanning tasks", this.allTasks.size());
        for (AbstractTask task : this.allTasks) {
            contentProvider.add((Object)task, itemsFilter);
            subMonitor.worked(1);
        }
        subMonitor.done();
        progressMonitor.done();
    }

    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = TasksUiPlugin.getDefault().getDialogSettings();
        IDialogSettings section = settings.getSection(TASK_SELECTION_DIALOG_SECTION);
        if (section == null) {
            section = settings.addNewSection(TASK_SELECTION_DIALOG_SECTION);
            section.put(OPEN_IN_BROWSER_SETTING, false);
            section.put(SHOW_COMPLETED_TASKS_SETTING, true);
        }
        return section;
    }

    protected void restoreDialog(IDialogSettings settings) {
        this.openInBrowser = settings.getBoolean(OPEN_IN_BROWSER_SETTING);
        this.showCompletedTasks = settings.getBoolean(SHOW_COMPLETED_TASKS_SETTING);
        this.showCompletedTasksAction.setChecked(this.showCompletedTasks);
        super.restoreDialog(settings);
    }

    protected void storeDialog(IDialogSettings settings) {
        settings.put(OPEN_IN_BROWSER_SETTING, this.openInBrowser);
        settings.put(SHOW_COMPLETED_TASKS_SETTING, this.showCompletedTasks);
        super.storeDialog(settings);
    }

    public String getElementName(Object item) {
        return this.labelProvider.getText(item);
    }

    protected Comparator getItemsComparator() {
        return new Comparator(){

            public int compare(Object o1, Object o2) {
                return TaskSelectionDialog.this.labelProvider.getText(o1).compareTo(TaskSelectionDialog.this.labelProvider.getText(o2));
            }
        };
    }

    protected IStatus validateItem(Object item) {
        if (item instanceof AbstractTask) {
            return Status.OK_STATUS;
        }
        return new Status(4, "org.eclipse.mylyn.tasks.ui", "Selected item is not a task");
    }

    private class ShowCompletedTasksAction
    extends Action {
        public ShowCompletedTasksAction() {
            super("Show &Completed Tasks", 2);
        }

        public void run() {
            TaskSelectionDialog.this.showCompletedTasks = this.isChecked();
            TaskSelectionDialog.this.applyFilter();
        }
    }

    private class TaskSelectionHistory
    extends FilteredItemsSelectionDialog.SelectionHistory {
        private TaskActivationHistory history = TasksUiPlugin.getTaskListManager().getTaskActivationHistory();

        private TaskSelectionHistory() {
        }

        public synchronized void accessed(Object object) {
            if (TaskSelectionDialog.this.insertInHistory) {
                this.history.addTask((AbstractTask)object);
            }
        }

        public synchronized boolean contains(Object object) {
            return this.history.containsTask((AbstractTask)object);
        }

        public synchronized boolean remove(Object object) {
            return this.history.removeTask((AbstractTask)object);
        }

        public synchronized boolean isEmpty() {
            return !this.history.hasPrevious();
        }

        public void load(IMemento memento) {
        }

        public void save(IMemento memento) {
        }

        protected Object restoreItemFromMemento(IMemento memento) {
            return null;
        }

        protected void storeItemToMemento(Object item, IMemento memento) {
        }

        public synchronized Object[] getHistoryItems() {
            return this.history.getPreviousTasks().toArray();
        }
    }

    private class TasksFilter
    extends FilteredItemsSelectionDialog.ItemsFilter {
        private boolean showCompletedTasks;

        public TasksFilter(boolean showCompletedTasks) {
            super((FilteredItemsSelectionDialog)TaskSelectionDialog.this, new SearchPattern());
            this.patternMatcher.setPattern("*" + this.patternMatcher.getPattern());
            this.showCompletedTasks = showCompletedTasks;
        }

        public boolean isSubFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!super.isSubFilter(filter)) {
                return false;
            }
            if (filter instanceof TasksFilter) {
                return this.showCompletedTasks == ((TasksFilter)filter).showCompletedTasks;
            }
            return true;
        }

        public boolean equalsFilter(FilteredItemsSelectionDialog.ItemsFilter filter) {
            if (!super.equalsFilter(filter)) {
                return false;
            }
            if (filter instanceof TasksFilter) {
                return this.showCompletedTasks == ((TasksFilter)filter).showCompletedTasks;
            }
            return true;
        }

        public boolean isConsistentItem(Object item) {
            return item instanceof AbstractTask;
        }

        public boolean matchItem(Object item) {
            if (!(item instanceof AbstractTask)) {
                return false;
            }
            if (!this.showCompletedTasks && ((AbstractTask)item).isCompleted()) {
                return false;
            }
            return this.matches(TaskSelectionDialog.this.labelProvider.getText(item));
        }
    }
}

