/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EditCredentialsDialog
extends Dialog {
    private static final String TITLE = "Enter Password";
    private boolean savePassword;
    private Image keyLockImage;
    private String message;
    private String username = "";
    private String password = "";
    private String url;

    public EditCredentialsDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public String getUserName() {
        return this.username;
    }

    public void setUsername(String username) {
        if (username == null) {
            throw new IllegalArgumentException();
        }
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        if (password == null) {
            throw new IllegalArgumentException();
        }
        this.password = password;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean getSavePassword() {
        return this.savePassword;
    }

    public void setSavePassword(boolean savePassword) {
        this.savePassword = savePassword;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(TITLE);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        this.keyLockImage = TasksUiPlugin.imageDescriptorFromPlugin((String)"org.eclipse.mylyn.tasks.ui", (String)"icons/wizban/keylock.gif").createImage();
        label.setImage(this.keyLockImage);
        GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)label);
        this.createCenterArea(composite);
        Dialog.applyDialogFont((Control)parent);
        return composite;
    }

    private void createCenterArea(Composite parent) {
        Label label;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(768));
        if (this.message != null) {
            label = new Label(composite, 64);
            label.setText(this.message);
            GridDataFactory.fillDefaults().align(4, 0x1000000).hint(this.convertHorizontalDLUsToPixels(300), -1).grab(true, false).span(2, 1).applyTo((Control)label);
            label = new Label(composite, 0);
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)label);
        }
        if (this.url != null) {
            label = new Label(composite, 64);
            label.setText("Repository:");
            label = new Label(composite, 0);
            label.setText(this.url);
            GridDataFactory.fillDefaults().applyTo((Control)label);
        }
        new Label(composite, 0).setText("&User name:");
        final Text usernameField = new Text(composite, 2048);
        usernameField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditCredentialsDialog.this.username = usernameField.getText();
            }
        });
        usernameField.setText(this.username);
        if (this.username.length() == 0) {
            usernameField.setFocus();
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(this.convertHorizontalDLUsToPixels(200), -1).grab(true, false).applyTo((Control)usernameField);
        new Label(composite, 0).setText("&Password:");
        final Text passwordField = new Text(composite, 0x400800);
        passwordField.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditCredentialsDialog.this.password = passwordField.getText();
            }
        });
        passwordField.setText(this.password);
        if (this.username.length() > 0) {
            passwordField.setFocus();
        }
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(this.convertHorizontalDLUsToPixels(200), -1).grab(true, false).applyTo((Control)passwordField);
        final Button savePasswordButton = new Button(composite, 32);
        savePasswordButton.setText("&Save password");
        savePasswordButton.setSelection(this.savePassword);
        savePasswordButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditCredentialsDialog.this.savePassword = savePasswordButton.getSelection();
            }
        });
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)savePasswordButton);
        this.createWarningMessage(composite);
    }

    private void createWarningMessage(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).span(2, 1).applyTo((Control)composite);
        Label label = new Label(composite, 0);
        label.setImage(EditCredentialsDialog.getImage((String)"dialog_messasge_warning_image"));
        label.setLayoutData((Object)new GridData(34));
        label = new Label(composite, 64);
        label.setText("Saved passwords are stored on your computer in a file that is difficult, but not impossible, for an intruder to read.");
        GridDataFactory.fillDefaults().align(4, 0x1000000).hint(this.convertHorizontalDLUsToPixels(300), -1).grab(true, false).applyTo((Control)label);
    }

    public boolean close() {
        if (this.keyLockImage != null) {
            this.keyLockImage.dispose();
        }
        return super.close();
    }
}

