/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.editors;

import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.editors.ContentOutlineTools;
import org.eclipse.mylyn.internal.tasks.ui.editors.IRepositoryTaskSelection;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTaskOutlineComparer;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTaskOutlineNode;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.TaskComment;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class RepositoryTaskOutlinePage
extends ContentOutlinePage {
    private RepositoryTaskOutlineNode topTreeNode;
    private TaskRepository repository;
    protected final ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).getFirstElement() instanceof IRepositoryTaskSelection) {
                if (((IStructuredSelection)RepositoryTaskOutlinePage.this.getSelection()).getFirstElement() instanceof IRepositoryTaskSelection) {
                    IRepositoryTaskSelection brs1 = (IRepositoryTaskSelection)((IStructuredSelection)RepositoryTaskOutlinePage.this.getSelection()).getFirstElement();
                    IRepositoryTaskSelection brs2 = (IRepositoryTaskSelection)((IStructuredSelection)selection).getFirstElement();
                    if (ContentOutlineTools.getHandle(brs1).compareTo(ContentOutlineTools.getHandle(brs2)) == 0) {
                        return;
                    }
                }
                RepositoryTaskOutlinePage.this.getTreeViewer().setSelection(selection, true);
            }
        }
    };
    private TreeViewer viewer;

    public RepositoryTaskOutlinePage(RepositoryTaskOutlineNode topTreeNode) {
        this.topTreeNode = topTreeNode;
        this.repository = TasksUiPlugin.getRepositoryManager().getRepository(topTreeNode.getConnectorKind(), topTreeNode.getRepositoryUrl());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.viewer = this.getTreeViewer();
        this.viewer.setContentProvider((IContentProvider)new BugTaskOutlineContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public Image getImage(Object element) {
                if (element instanceof RepositoryTaskOutlineNode) {
                    RepositoryTaskOutlineNode node = (RepositoryTaskOutlineNode)element;
                    if ("Comments".equals(node.getContents()) || "New Comment".equals(node.getContents())) {
                        return TasksUiImages.getImage(TasksUiImages.COMMENT);
                    }
                    if ("Description".equals(node.getContents())) {
                        return TasksUiImages.getImage(TasksUiImages.TASK_NOTES);
                    }
                    if (node.getComment() != null) {
                        if (RepositoryTaskOutlinePage.this.repository != null && node.getComment().getAuthor().equals(RepositoryTaskOutlinePage.this.repository.getUserName())) {
                            return TasksUiImages.getImage(TasksUiImages.PERSON_ME);
                        }
                        return TasksUiImages.getImage(TasksUiImages.PERSON);
                    }
                    return TasksUiImages.getImage(TasksUiImages.TASK);
                }
                return super.getImage(element);
            }

            public String getText(Object element) {
                if (element instanceof RepositoryTaskOutlineNode) {
                    RepositoryTaskOutlineNode node = (RepositoryTaskOutlineNode)element;
                    TaskComment comment = node.getComment();
                    if (comment == null) {
                        return node.getName();
                    }
                    int n = comment.getNumber();
                    String name = comment.getAuthorName();
                    if (name != null) {
                        String id = comment.getAuthor();
                        if (id != null) {
                            name = String.valueOf(name) + " <" + id + ">";
                        }
                    } else {
                        name = comment.getAuthor();
                    }
                    return String.valueOf(n) + ": " + name + " (" + node.getName() + ")";
                }
                return super.getText(element);
            }
        });
        try {
            this.viewer.setInput((Object)this.topTreeNode);
            this.viewer.setComparer((IElementComparer)new RepositoryTaskOutlineComparer());
            this.viewer.expandAll();
        }
        catch (Exception e) {
            StatusHandler.fail((Throwable)e, (String)"could not create bugzilla outline", (boolean)true);
        }
        this.getSite().getPage().addSelectionListener(this.selectionListener);
    }

    public void dispose() {
        super.dispose();
        this.getSite().getPage().removeSelectionListener(this.selectionListener);
    }

    public TreeViewer getOutlineTreeViewer() {
        return this.viewer;
    }

    protected static class BugTaskOutlineContentProvider
    implements ITreeContentProvider {
        protected BugTaskOutlineContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children;
            if (parentElement instanceof RepositoryTaskOutlineNode && (children = ((RepositoryTaskOutlineNode)parentElement).getChildren()).length > 0) {
                return children;
            }
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof RepositoryTaskOutlineNode) {
                return ((RepositoryTaskOutlineNode)element).getChildren().length > 0;
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            Object[] children;
            if (inputElement instanceof RepositoryTaskOutlineNode && (children = ((RepositoryTaskOutlineNode)inputElement).getChildren()).length > 0) {
                return children;
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewerChanged, Object oldInput, Object newInput) {
        }
    }
}

