/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.planner;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.mylyn.internal.tasks.ui.views.DatePickerPanel;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DateSelectionDialog
extends Dialog {
    private Date reminderDate = null;
    private String title = "Date Selection";
    private Calendar initialCalendar = GregorianCalendar.getInstance();
    private FormToolkit toolkit;

    public DateSelectionDialog(Shell parentShell, String title) {
        this(parentShell, GregorianCalendar.getInstance(), title);
    }

    public DateSelectionDialog(Shell parentShell, Calendar initialDate, String title) {
        super(parentShell);
        this.toolkit = new FormToolkit(parentShell.getDisplay());
        if (title != null) {
            this.title = title;
        }
        if (initialDate != null) {
            this.initialCalendar.setTime(initialDate.getTime());
        }
        this.reminderDate = this.initialCalendar.getTime();
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title);
        DatePickerPanel datePanel = new DatePickerPanel(parent, 0, this.initialCalendar);
        datePanel.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    DatePickerPanel.DateSelection dateSelection = (DatePickerPanel.DateSelection)event.getSelection();
                    DateSelectionDialog.this.reminderDate = dateSelection.getDate().getTime();
                }
            }
        });
        datePanel.setBackground(this.toolkit.getColors().getBackground());
        return datePanel;
    }

    public boolean close() {
        this.toolkit.dispose();
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        parent.setBackground(this.toolkit.getColors().getBackground());
        this.createButton(parent, 1025, "Clear", false);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 1025) {
            this.reminderDate = null;
            this.okPressed();
        }
    }

    public Date getDate() {
        return this.reminderDate;
    }
}

