/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.planner;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.mylyn.internal.tasks.ui.planner.ITaskCollector;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InProgressTaskCollector
implements ITaskCollector {
    private Map<String, AbstractTask> inProgressTasks = new HashMap<String, AbstractTask>();
    private Date periodStartDate;
    private Date periodEndDate;

    protected static boolean hasActivity(AbstractTask task, Date startDate, Date endDate) {
        Calendar startCal = Calendar.getInstance();
        startCal.setTime(startDate);
        Calendar endCal = Calendar.getInstance();
        endCal.setTime(endDate);
        return TasksUiPlugin.getTaskActivityManager().getElapsedTime(task, startCal, endCal) > 0L;
    }

    public InProgressTaskCollector(Date periodStartDate, Date periodEndDate) {
        this.periodStartDate = periodStartDate;
        this.periodEndDate = periodEndDate;
    }

    public String getLabel() {
        return "Tasks in Progress";
    }

    @Override
    public void consumeTask(AbstractTask task) {
        if (!task.isCompleted() && InProgressTaskCollector.hasActivity(task, this.periodStartDate, this.periodEndDate) && !this.inProgressTasks.containsKey(task.getHandleIdentifier())) {
            this.inProgressTasks.put(task.getHandleIdentifier(), task);
        }
    }

    @Override
    public Set<AbstractTask> getTasks() {
        HashSet<AbstractTask> tasks = new HashSet<AbstractTask>();
        tasks.addAll(this.inProgressTasks.values());
        return tasks;
    }
}

