/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.planner;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.tasks.ui.planner.TaskActivitySorter;
import org.eclipse.mylyn.tasks.core.AbstractTask;

public class TaskPlanSorter
extends TaskActivitySorter {
    public static final int PRIORITY = 1;
    public static final int DESCRIPTION = 2;
    public static final int DURATION = 3;
    public static final int ESTIMATE = 4;
    public static final int REMINDER = 5;
    public static final int ICON = 0;
    private int criteria;

    public TaskPlanSorter(int criteria) {
        super(criteria);
        this.criteria = criteria;
    }

    public int compare(Viewer viewer, Object obj1, Object obj2) {
        AbstractTask t1 = (AbstractTask)obj1;
        AbstractTask t2 = (AbstractTask)obj2;
        switch (this.criteria) {
            case 1: {
                return this.comparePriority(t1, t2);
            }
            case 2: {
                return this.compareDescription(t1, t2);
            }
            case 3: {
                return this.compareDuration(t1, t2);
            }
            case 4: {
                return this.compareEstimated(t1, t2);
            }
            case 5: {
                return this.compareReminder(t1, t2);
            }
        }
        return 0;
    }

    private int compareReminder(AbstractTask task1, AbstractTask task2) {
        if (task2.getScheduledForDate() == null) {
            return -1;
        }
        if (task1.getScheduledForDate() == null) {
            return 1;
        }
        if (task1.getScheduledForDate() == null && task2.getScheduledForDate() == null) {
            return 0;
        }
        return task2.getScheduledForDate().compareTo(task1.getScheduledForDate());
    }
}

