/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.planner;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskElementLabelProvider;
import org.eclipse.mylyn.monitor.core.DateUtil;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class TaskPlannerLabelProvider
extends TaskElementLabelProvider
implements ITableLabelProvider,
IColorProvider {
    private Calendar startDate;
    private Calendar endDate;
    private TreeViewer viewer;
    private TaskElementLabelProvider taskListLabelProvider = new TaskElementLabelProvider(true);

    public TaskPlannerLabelProvider(TreeViewer viewer, Date startDate, Date endDate) {
        super(true);
        this.viewer = viewer;
        this.startDate = Calendar.getInstance();
        this.startDate.setTime(startDate);
        this.endDate = Calendar.getInstance();
        this.endDate.setTime(endDate);
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return super.getImage(element);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getColumnText(Object element, int columnIndex) {
        try {
            if (element instanceof AbstractTask) {
                AbstractTask task = (AbstractTask)element;
                switch (columnIndex) {
                    case 1: {
                        return task.getPriority();
                    }
                    case 2: {
                        return task.getSummary();
                    }
                    case 3: {
                        return DateUtil.getFormattedDurationShort((long)TasksUiPlugin.getTaskActivityManager().getElapsedTime(task, this.startDate, this.endDate));
                    }
                    case 4: {
                        return String.valueOf(task.getEstimateTimeHours()) + " hours";
                    }
                    case 5: {
                        if (task.getCreationDate() != null) {
                            return DateFormat.getDateInstance(2).format(task.getCreationDate());
                        }
                        StatusHandler.log((String)("Task has no creation date: " + task.getSummary()), (Object)((Object)this));
                        return "[unknown]";
                    }
                    case 6: {
                        if (task.getCompletionDate() == null) return "";
                        return DateFormat.getDateInstance(2).format(task.getCompletionDate());
                    }
                }
                return null;
            }
            if (!(element instanceof AbstractTaskContainer)) return null;
            AbstractTaskContainer container = (AbstractTaskContainer)element;
            switch (columnIndex) {
                case 1: {
                    return null;
                }
                case 2: {
                    return container.getSummary();
                }
                case 3: {
                    ITreeContentProvider contentProvider = (ITreeContentProvider)this.viewer.getContentProvider();
                    long duration = 0L;
                    Object[] objectArray = contentProvider.getChildren((Object)container);
                    int n = objectArray.length;
                    int n2 = 0;
                    while (true) {
                        if (n2 >= n) {
                            return DateUtil.getFormattedDurationShort((long)duration);
                        }
                        Object o = objectArray[n2];
                        if (o instanceof AbstractTask) {
                            duration += TasksUiPlugin.getTaskActivityManager().getElapsedTime((AbstractTask)o, this.startDate, this.endDate);
                        }
                        ++n2;
                    }
                }
                case 4: {
                    ITreeContentProvider contentProvider = (ITreeContentProvider)this.viewer.getContentProvider();
                    long estimated = 0L;
                    Object[] objectArray = contentProvider.getChildren((Object)container);
                    int n = objectArray.length;
                    int n3 = 0;
                    while (true) {
                        if (n3 >= n) {
                            return String.valueOf(estimated) + " hours";
                        }
                        Object o = objectArray[n3];
                        if (o instanceof AbstractTask) {
                            estimated += (long)((AbstractTask)o).getEstimateTimeHours();
                        }
                        ++n3;
                    }
                }
                case 5: {
                    return null;
                }
                case 6: {
                    return null;
                }
            }
            return null;
        }
        catch (RuntimeException e) {
            StatusHandler.fail((Throwable)e, (String)"Could not produce completed task label", (boolean)false);
            return "";
        }
    }

    public Color getForeground(Object element) {
        return this.taskListLabelProvider.getForeground(element);
    }

    public Color getBackground(Object element) {
        return this.taskListLabelProvider.getBackground(element);
    }
}

