/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.monitor.core.util.ZipFileUtil;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDataExportJob
implements IRunnableWithProgress {
    private static final String JOB_LABEL = "Exporting Mylyn Task Data";
    private boolean zip;
    private boolean exportTaskList;
    private boolean exportActivationHistory;
    private boolean exportTaskContexts;
    private String destinationDirectory;
    private String zipFileName;
    private File destZipFile = null;
    private Collection<AbstractTask> tasks;

    public TaskDataExportJob(String destinationDirectory, boolean zipIt, String zipFileName) {
        this(destinationDirectory, true, true, true, zipIt, zipFileName, TasksUiPlugin.getTaskListManager().getTaskList().getAllTasks());
    }

    public TaskDataExportJob(String destinationDirectory, boolean exportTaskList, boolean exportActivationHistory, boolean exportTaskContexts, boolean zipIt, String zipFileName, Collection<AbstractTask> taskContextsToExport) {
        this.zipFileName = zipFileName;
        this.zip = zipIt;
        this.exportTaskList = exportTaskList;
        this.exportActivationHistory = exportActivationHistory;
        this.exportTaskContexts = exportTaskContexts;
        this.destinationDirectory = destinationDirectory;
        this.tasks = taskContextsToExport;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        int jobSize = 1;
        if (this.exportTaskList) {
            ++jobSize;
        }
        if (this.exportActivationHistory) {
            ++jobSize;
        }
        if (this.exportTaskContexts) {
            jobSize += this.tasks.size();
        }
        monitor.beginTask(JOB_LABEL, jobSize);
        ArrayList<File> filesToZip = new ArrayList<File>();
        HashMap filesToZipMap = new HashMap();
        String sourceContextsPath = String.valueOf(TasksUiPlugin.getDefault().getDataDirectory()) + File.separator + "contexts";
        File contextsDirectory = new File(sourceContextsPath);
        TasksUiPlugin.getRepositoryManager().saveRepositories(TasksUiPlugin.getDefault().getRepositoriesFilePath());
        String sourceRepositoriesPath = String.valueOf(TasksUiPlugin.getDefault().getDataDirectory()) + File.separator + "repositories.xml.zip";
        File sourceRepositoriesFile = new File(sourceRepositoriesPath);
        if (sourceRepositoriesFile.exists()) {
            File destRepositoriesFile = new File(String.valueOf(this.destinationDirectory) + File.separator + "repositories.xml.zip");
            if (this.zip) {
                filesToZip.add(sourceRepositoriesFile);
            } else if (!destRepositoriesFile.equals(sourceRepositoriesFile)) {
                if (destRepositoriesFile.exists()) {
                    destRepositoriesFile.delete();
                }
                if (!this.copy(sourceRepositoriesFile, destRepositoriesFile)) {
                    StatusHandler.fail((Throwable)new Exception("Export Exception"), (String)"Could not export repositories file.", (boolean)false);
                }
                monitor.worked(1);
            }
        }
        if (this.exportTaskList) {
            TasksUiPlugin.getTaskListManager().saveTaskList();
            String sourceTaskListPath = String.valueOf(TasksUiPlugin.getDefault().getDataDirectory()) + File.separator + "tasklist.xml.zip";
            File sourceTaskListFile = new File(sourceTaskListPath);
            if (sourceTaskListFile.exists()) {
                File destTaskListFile = new File(String.valueOf(this.destinationDirectory) + File.separator + "tasklist.xml.zip");
                if (this.zip) {
                    filesToZip.add(sourceTaskListFile);
                } else if (!destTaskListFile.equals(sourceTaskListFile)) {
                    if (destTaskListFile.exists()) {
                        destTaskListFile.delete();
                    }
                    if (!this.copy(sourceTaskListFile, destTaskListFile)) {
                        StatusHandler.fail((Throwable)new Exception("Export Exception"), (String)"Could not export task list file.", (boolean)false);
                    }
                    monitor.worked(1);
                }
            }
        }
        if (this.exportActivationHistory) {
            try {
                File sourceActivationHistoryFile = new File(contextsDirectory, "activity.xml.zip");
                if (sourceActivationHistoryFile.exists()) {
                    ContextCorePlugin.getContextManager().saveActivityContext();
                    File destActivationHistoryFile = new File(String.valueOf(this.destinationDirectory) + File.separator + "activity" + ".xml.zip");
                    if (this.zip) {
                        filesToZip.add(sourceActivationHistoryFile);
                    } else if (!destActivationHistoryFile.equals(sourceActivationHistoryFile)) {
                        if (destActivationHistoryFile.exists()) {
                            destActivationHistoryFile.delete();
                        }
                        this.copy(sourceActivationHistoryFile, destActivationHistoryFile);
                        monitor.worked(1);
                    }
                }
            }
            catch (RuntimeException e) {
                StatusHandler.fail((Throwable)e, (String)"Could not export activity history context file", (boolean)true);
            }
        }
        if (this.exportTaskContexts) {
            boolean errorDisplayed = false;
            for (AbstractTask task : this.tasks) {
                if (!ContextCorePlugin.getContextManager().hasContext(task.getHandleIdentifier())) continue;
                File sourceTaskContextFile = ContextCorePlugin.getContextManager().getFileForContext(task.getHandleIdentifier());
                File destTaskFile = new File(String.valueOf(this.destinationDirectory) + File.separator + sourceTaskContextFile.getName());
                if (this.zip) {
                    if (filesToZipMap.containsKey(task.getHandleIdentifier())) continue;
                    filesToZip.add(sourceTaskContextFile);
                    filesToZipMap.put(task.getHandleIdentifier(), null);
                    continue;
                }
                if (sourceTaskContextFile.equals(destTaskFile)) continue;
                if (destTaskFile.exists()) {
                    destTaskFile.delete();
                }
                if (!this.copy(sourceTaskContextFile, destTaskFile) && !errorDisplayed) {
                    StatusHandler.fail((Throwable)new Exception("Export Exception: " + sourceTaskContextFile.getPath() + " -> " + destTaskFile.getPath()), (String)"Could not export one or more task context files.", (boolean)true);
                    errorDisplayed = true;
                }
                monitor.worked(1);
            }
        }
        if (this.zip && filesToZip.size() > 0) {
            try {
                this.destZipFile = new File(String.valueOf(this.destinationDirectory) + File.separator + this.zipFileName);
                if (this.destZipFile.exists()) {
                    this.destZipFile.delete();
                }
                ZipFileUtil.createZipFile((File)this.destZipFile, filesToZip, (String)TasksUiPlugin.getDefault().getDataDirectory(), (IProgressMonitor)monitor);
            }
            catch (Exception e) {
                StatusHandler.fail((Throwable)e, (String)"Could not create zip file.", (boolean)true);
            }
        }
        monitor.done();
    }

    private boolean copy(File src, File dst) {
        try {
            int len;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

