/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.context.core.InteractionContextExternalizer;
import org.eclipse.mylyn.internal.tasks.core.TaskDataManager;
import org.eclipse.mylyn.internal.tasks.core.TaskExternalizationException;
import org.eclipse.mylyn.internal.tasks.core.TaskRepositoriesExternalizer;
import org.eclipse.mylyn.internal.tasks.ui.util.DelegatingTaskExternalizer;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.AbstractTaskListFactory;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskListWriter {
    private static final String TRANSFORM_PROPERTY_VERSION = "version";
    private static final String XML_VERSION = "1.0";
    public static final String ATTRIBUTE_VERSION = "Version";
    public static final String ELEMENT_TASK_LIST = "TaskList";
    private static final String VALUE_VERSION = "1.0.1";
    private static final String VALUE_VERSION_1_0_0 = "1.0.0";
    private static final String FILE_SUFFIX_SAVE = "save.xml";
    private List<AbstractTaskListFactory> externalizers;
    private DelegatingTaskExternalizer delagatingExternalizer;
    private TaskRepositoriesExternalizer repositoriesExternalizer;
    private InteractionContextExternalizer contextExternalizer;
    private List<Node> orphanedTaskNodes = new ArrayList<Node>();
    private List<Node> orphanedQueryNodes = new ArrayList<Node>();
    private String readVersion = "";
    private boolean hasCaughtException = false;

    public TaskListWriter() {
        this.delagatingExternalizer = new DelegatingTaskExternalizer();
        this.repositoriesExternalizer = new TaskRepositoriesExternalizer();
        this.contextExternalizer = new InteractionContextExternalizer();
    }

    public void setDelegateExternalizers(List<AbstractTaskListFactory> externalizers) {
        this.externalizers = externalizers;
        this.delagatingExternalizer.setFactories(externalizers);
    }

    public void writeTaskList(TaskList taskList, File outFile) {
        Node tempNode;
        Document doc = this.createTaskListDocument();
        if (doc == null) {
            return;
        }
        Element root = this.createTaskListRoot(doc);
        for (AbstractTaskContainer category : taskList.getCategories()) {
            this.delagatingExternalizer.createCategoryElement(category, doc, root);
        }
        for (AbstractRepositoryQuery query : taskList.getQueries()) {
            try {
                this.delagatingExternalizer.createQueryElement(query, doc, root);
            }
            catch (Throwable t) {
                StatusHandler.fail((Throwable)t, (String)("Did not externalize: " + query.getSummary()), (boolean)true);
            }
        }
        for (AbstractTask task : taskList.getAllTasks()) {
            this.delagatingExternalizer.createTaskElement(task, doc, root);
        }
        for (Node orphanedTaskNode : this.orphanedTaskNodes) {
            tempNode = doc.importNode(orphanedTaskNode, true);
            if (tempNode == null) continue;
            root.appendChild(tempNode);
        }
        for (Node orphanedQueryNode : this.orphanedQueryNodes) {
            tempNode = doc.importNode(orphanedQueryNode, true);
            if (tempNode == null) continue;
            root.appendChild(tempNode);
        }
        this.writeDOMtoFile(doc, outFile);
    }

    private void writeDOMtoFile(Document doc, File file) {
        try {
            ZipOutputStream outputStream = new ZipOutputStream(new FileOutputStream(file));
            this.writeTaskList(doc, outputStream);
            outputStream.close();
        }
        catch (Exception fnfe) {
            StatusHandler.log((Throwable)fnfe, (String)"TaskList could not be found");
        }
    }

    private void writeTaskList(Document doc, ZipOutputStream outputStream) throws IOException {
        ZipEntry zipEntry = new ZipEntry("tasklist.xml");
        outputStream.putNextEntry(zipEntry);
        outputStream.setMethod(8);
        this.writeDOMtoStream(doc, outputStream);
        outputStream.flush();
        outputStream.closeEntry();
    }

    private void writeDOMtoStream(Document doc, OutputStream outputStream) {
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(outputStream);
        Transformer xformer = null;
        try {
            xformer = TransformerFactory.newInstance().newTransformer();
            xformer.setOutputProperty(TRANSFORM_PROPERTY_VERSION, XML_VERSION);
            xformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerFactoryConfigurationError e) {
            e.printStackTrace();
        }
        catch (TransformerException e1) {
            e1.printStackTrace();
        }
    }

    public void readTaskList(TaskList taskList, File inFile, TaskDataManager taskDataManager) {
        block22: {
            this.hasCaughtException = false;
            HashMap<AbstractTask, NodeList> tasksWithSubtasks = new HashMap<AbstractTask, NodeList>();
            this.orphanedTaskNodes.clear();
            this.orphanedQueryNodes.clear();
            try {
                Object child;
                if (!inFile.exists()) {
                    return;
                }
                Document doc = this.openAsDOM(inFile, false);
                if (doc == null) {
                    this.handleException(inFile, null, (Exception)new TaskExternalizationException("TaskList was not well formed XML"));
                    return;
                }
                Element root = doc.getDocumentElement();
                this.readVersion = root.getAttribute(ATTRIBUTE_VERSION);
                if (this.readVersion.equals(VALUE_VERSION_1_0_0)) {
                    StatusHandler.log((String)("version: " + this.readVersion + " not supported"), (Object)this);
                    break block22;
                }
                NodeList list = root.getChildNodes();
                int i = 0;
                while (i < list.getLength()) {
                    child = list.item(i);
                    try {
                        if (child.getNodeName().endsWith("Category")) {
                            this.delagatingExternalizer.readCategory((Node)child, taskList);
                        }
                    }
                    catch (Exception e) {
                        this.handleException(inFile, (Node)child, e);
                    }
                    ++i;
                }
                i = 0;
                while (i < list.getLength()) {
                    child = list.item(i);
                    try {
                        if (!child.getNodeName().endsWith("Category") && !child.getNodeName().endsWith("Query")) {
                            AbstractTask task = this.delagatingExternalizer.readTask((Node)child, null, null);
                            if (task == null) {
                                this.orphanedTaskNodes.add((Node)child);
                            } else {
                                taskList.insertTask(task, null, null);
                                if (child.getChildNodes() != null && child.getChildNodes().getLength() > 0) {
                                    tasksWithSubtasks.put(task, child.getChildNodes());
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        this.handleException(inFile, (Node)child, e);
                    }
                    ++i;
                }
                for (AbstractTask task : tasksWithSubtasks.keySet()) {
                    NodeList nodes = (NodeList)tasksWithSubtasks.get(task);
                    this.delagatingExternalizer.readSubTasks(task, nodes, taskList);
                }
                i = 0;
                while (i < list.getLength()) {
                    child = list.item(i);
                    try {
                        if (child.getNodeName().endsWith("Query")) {
                            this.readQuery(taskList, (Node)child);
                        }
                    }
                    catch (Exception e) {
                        this.handleException(inFile, (Node)child, e);
                    }
                    ++i;
                }
                int largest = taskList.findLargestTaskId();
                taskList.setLastLocalTaskId(largest);
            }
            catch (Exception e) {
                this.handleException(inFile, null, e);
            }
        }
        if (this.hasCaughtException) {
            this.writeTaskList(taskList, inFile);
        }
    }

    private Document createTaskListDocument() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        Document doc = null;
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.newDocument();
        }
        catch (ParserConfigurationException e) {
            StatusHandler.log((Throwable)e, (String)"could not create document");
            return doc;
        }
        return doc;
    }

    private Element createTaskListRoot(Document doc) {
        Element root = doc.createElement(ELEMENT_TASK_LIST);
        root.setAttribute(ATTRIBUTE_VERSION, VALUE_VERSION);
        doc.appendChild(root);
        return root;
    }

    private AbstractRepositoryQuery readQuery(TaskList taskList, Node child) {
        AbstractRepositoryQuery query = null;
        for (AbstractTaskListFactory externalizer : this.externalizers) {
            String label;
            Set queryTagNames = externalizer.getQueryElementNames();
            if (queryTagNames == null || !queryTagNames.contains(child.getNodeName())) continue;
            Element childElement = (Element)child;
            String repositoryUrl = childElement.getAttribute("RepositoryUrl");
            String queryString = childElement.getAttribute("QueryString");
            if (queryString.length() == 0) {
                queryString = childElement.getAttribute("Query");
            }
            if ((label = childElement.getAttribute("Name")).length() == 0) {
                label = childElement.getAttribute("Label");
            }
            if ((query = externalizer.createQuery(repositoryUrl, queryString, label, childElement)) != null && childElement.getAttribute("LastRefreshTimeStamp") != null && !childElement.getAttribute("LastRefreshTimeStamp").equals("")) {
                query.setLastSynchronizedStamp(childElement.getAttribute("LastRefreshTimeStamp"));
            }
            if (taskList == null) break;
            if (query != null) {
                taskList.internalAddQuery(query);
            }
            NodeList queryChildren = child.getChildNodes();
            int ii = 0;
            while (ii < queryChildren.getLength()) {
                Node queryNode = queryChildren.item(ii);
                try {
                    this.delagatingExternalizer.readQueryHit((Element)queryNode, taskList, query);
                }
                catch (TaskExternalizationException taskExternalizationException) {
                    this.hasCaughtException = true;
                }
                ++ii;
            }
            break block2;
        }
        if (query == null) {
            this.orphanedQueryNodes.add(child);
        }
        return query;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Document openAsDOM(File inputFile, boolean propagateException) throws IOException {
        void var6_10;
        Document document;
        DocumentBuilder builder;
        block7: {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            builder = null;
            document = null;
            try {
                builder = factory.newDocumentBuilder();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                inputFile.renameTo(new File(String.valueOf(inputFile.getName()) + FILE_SUFFIX_SAVE));
                IOException ioe = new IOException("Failed to load XML file");
                ioe.initCause(parserConfigurationException);
                throw ioe;
            }
            Object var6_7 = null;
            if (!inputFile.getName().endsWith(".xml.zip")) break block7;
            ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(inputFile));
            ZipEntry entry = zipInputStream.getNextEntry();
            while (entry != null) {
                if ("tasklist.xml".equals(entry.getName())) break;
                entry = zipInputStream.getNextEntry();
            }
            if (entry != null) return builder.parse((InputStream)var6_10);
            return null;
        }
        try {
            FileInputStream fileInputStream = new FileInputStream(inputFile);
            return builder.parse((InputStream)var6_10);
        }
        catch (SAXException sAXException) {
            if (propagateException) {
                throw new IOException("The task list format is invalid");
            }
            MessageDialog.openWarning(null, (String)"Mylyn task list corrupt", (String)"Unable to read the Mylyn task list. Please restore from previous backup via File > Import > Mylyn Task Data");
        }
        return document;
    }

    private void handleException(File inFile, Node child, Exception e) {
        this.hasCaughtException = true;
        String name = inFile.getAbsolutePath();
        Date date = new Date();
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern("yy-MM-dd-ss");
        name = String.valueOf(name.substring(0, name.lastIndexOf(46))) + "-failed-" + sdf.format(date) + ".zip";
        File save = new File(name);
        if (save.exists() && !save.delete()) {
            StatusHandler.log((String)"Unable to delete old backup tasklist file", (Object)this);
            return;
        }
        if (!this.copy(inFile, save)) {
            inFile.renameTo(new File(name));
        }
        if (child == null) {
            StatusHandler.log((Throwable)e, (String)"Could not read task list.  Consider restoring via File -> Import -> Mylyn Task Data");
        } else {
            e.printStackTrace();
            StatusHandler.log((Throwable)e, (String)("Tasks may have been lost from " + child.getNodeName()));
        }
    }

    private boolean copy(File src, File dst) {
        try {
            int len;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dst);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    public void setDelegatingExternalizer(DelegatingTaskExternalizer delagatingExternalizer) {
        this.delagatingExternalizer = delagatingExternalizer;
    }

    public List<AbstractTaskListFactory> getExternalizers() {
        return this.externalizers;
    }

    public void writeQueries(List<AbstractRepositoryQuery> queries, File outFile) {
        HashSet<TaskRepository> repositories = new HashSet<TaskRepository>();
        for (AbstractRepositoryQuery query : queries) {
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository(query.getRepositoryUrl());
            if (repository == null) continue;
            repositories.add(repository);
        }
        Document doc = this.createQueryDocument(queries);
        if (doc != null) {
            try {
                ZipOutputStream outputStream = new ZipOutputStream(new FileOutputStream(outFile));
                this.writeTaskList(doc, outputStream);
                this.repositoriesExternalizer.writeRepositories(repositories, outputStream);
                outputStream.close();
            }
            catch (Exception fnfe) {
                StatusHandler.log((Throwable)fnfe, (String)"TaskList could not be found");
            }
        }
    }

    public Document createQueryDocument(List<AbstractRepositoryQuery> queries) {
        Document doc = this.createTaskListDocument();
        if (doc == null) {
            return null;
        }
        Element root = this.createTaskListRoot(doc);
        for (AbstractRepositoryQuery query : queries) {
            try {
                this.delagatingExternalizer.createQueryElement(query, doc, root);
            }
            catch (Throwable t) {
                StatusHandler.fail((Throwable)t, (String)("Did not externalize: " + query.getSummary()), (boolean)true);
                return null;
            }
        }
        return doc;
    }

    public List<AbstractRepositoryQuery> readQueries(File inFile) throws IOException {
        if (!inFile.exists()) {
            throw new FileNotFoundException("File does not exist: " + inFile);
        }
        Document doc = this.openAsDOM(inFile, true);
        if (doc == null) {
            throw new IOException("TaskList was not well formed XML");
        }
        return this.readQueryDocument(doc);
    }

    public List<AbstractRepositoryQuery> readQueryDocument(Document doc) {
        ArrayList<AbstractRepositoryQuery> queries = new ArrayList<AbstractRepositoryQuery>();
        Element root = doc.getDocumentElement();
        this.readVersion = root.getAttribute(ATTRIBUTE_VERSION);
        if (!this.readVersion.equals(VALUE_VERSION_1_0_0)) {
            NodeList list = root.getChildNodes();
            int i = 0;
            while (i < list.getLength()) {
                Node child = list.item(i);
                try {
                    AbstractRepositoryQuery query;
                    if (child.getNodeName().endsWith("Query") && (query = this.readQuery(null, child)) != null) {
                        queries.add(query);
                    }
                }
                catch (Exception e) {
                    StatusHandler.log((Throwable)e, (String)("Tasks may have been lost from " + child.getNodeName()));
                }
                ++i;
            }
        } else {
            StatusHandler.log((String)("version: " + this.readVersion + " not supported"), (Object)this);
        }
        return queries;
    }

    public Set<TaskRepository> readRepositories(File file) {
        HashSet repository = this.repositoriesExternalizer.readRepositoriesFromXML(file);
        if (repository == null) {
            repository = new HashSet();
        }
        return repository;
    }

    public void writeTask(AbstractTask task, File outFile) {
        Document doc;
        HashSet<TaskRepository> repositories = new HashSet<TaskRepository>();
        if (!task.isLocal()) {
            repositories.add(TasksUiPlugin.getRepositoryManager().getRepository(task.getRepositoryUrl()));
        }
        if ((doc = this.createTaskListDocument()) == null) {
            return;
        }
        Element root = this.createTaskListRoot(doc);
        this.delagatingExternalizer.createTaskElement(task, doc, root);
        try {
            ZipOutputStream outputStream = new ZipOutputStream(new FileOutputStream(outFile));
            this.writeTaskList(doc, outputStream);
            InteractionContext context = ContextCorePlugin.getContextManager().loadContext(task.getHandleIdentifier());
            this.contextExternalizer.writeContext(context, outputStream);
            if (repositories.size() > 0) {
                this.repositoriesExternalizer.writeRepositories(repositories, outputStream);
            }
            outputStream.close();
        }
        catch (Exception e) {
            StatusHandler.log((Throwable)e, (String)"Task data was not written");
        }
    }

    public List<AbstractTask> readTasks(File inFile) {
        ArrayList<AbstractTask> tasks;
        block9: {
            tasks = new ArrayList<AbstractTask>();
            try {
                if (!inFile.exists()) {
                    return tasks;
                }
                Document doc = this.openAsDOM(inFile, false);
                if (doc == null) {
                    this.handleException(inFile, null, (Exception)((Object)new TaskExternalizationException("TaskList was not well formed XML")));
                    return tasks;
                }
                Element root = doc.getDocumentElement();
                this.readVersion = root.getAttribute(ATTRIBUTE_VERSION);
                if (!this.readVersion.equals(VALUE_VERSION_1_0_0)) {
                    NodeList list = root.getChildNodes();
                    int i = 0;
                    while (i < list.getLength()) {
                        Node child = list.item(i);
                        try {
                            AbstractTask task;
                            if (!child.getNodeName().endsWith("Category") && !child.getNodeName().endsWith("Query") && (task = this.delagatingExternalizer.readTask(child, null, null)) != null) {
                                tasks.add(task);
                            }
                        }
                        catch (Exception e) {
                            StatusHandler.log((Throwable)e, (String)("Tasks may have been lost from " + child.getNodeName()));
                        }
                        ++i;
                    }
                    break block9;
                }
                StatusHandler.log((String)("version: " + this.readVersion + " not supported"), (Object)this);
            }
            catch (Exception e) {
                this.handleException(inFile, null, e);
            }
        }
        return tasks;
    }
}

