/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.lang.reflect.Field;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.views.AdaptiveRefreshPolicy;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.WorkbenchMessages;

public abstract class AbstractFilteredTree
extends FilteredTree {
    private static final int filterWidth = 69;
    public static final String LABEL_FIND = " Find:";
    private Job refreshJob;
    private AdaptiveRefreshPolicy refreshPolicy;
    private Composite progressComposite;
    private Composite searchComposite;
    private boolean showProgress = false;

    public AbstractFilteredTree(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, treeStyle, filter);
        try {
            Field refreshField = FilteredTree.class.getDeclaredField("refreshJob");
            refreshField.setAccessible(true);
            this.refreshJob = (Job)refreshField.get((Object)this);
            this.refreshPolicy = new AdaptiveRefreshPolicy(this.refreshJob, super.getFilterControl());
        }
        catch (Exception e) {
            StatusHandler.fail((Throwable)e, (String)"Could not get refresh job", (boolean)false);
        }
        this.setInitialText("");
    }

    protected void createControl(Composite parent, int treeStyle) {
        super.createControl(parent, treeStyle);
        GridLayout layout = (GridLayout)this.getLayout();
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
    }

    protected Control createTreeControl(Composite parent, int style) {
        this.progressComposite = this.createProgressComposite(parent);
        this.progressComposite.setVisible(false);
        ((GridData)this.progressComposite.getLayoutData()).exclude = true;
        this.searchComposite = this.createSearchComposite(parent);
        if (this.searchComposite != null) {
            this.searchComposite.setVisible(false);
            ((GridData)this.searchComposite.getLayoutData()).exclude = true;
        }
        return super.createTreeControl(parent, style);
    }

    protected Composite createFilterControls(Composite parent) {
        GridLayout gridLayout = new GridLayout(4, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 2;
        gridLayout.verticalSpacing = 0;
        parent.setLayout((Layout)gridLayout);
        Label label = new Label(parent, 0);
        label.setText(LABEL_FIND);
        this.createFilterText(parent);
        this.createClearText(parent);
        if (this.filterToolBar != null) {
            this.filterToolBar.update(false);
            this.filterToolBar.getControl().setVisible(false);
        }
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.minimumWidth = 69;
        this.filterText.setLayoutData((Object)gd);
        this.filterText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u001b') {
                    AbstractFilteredTree.this.setFilterText("");
                }
            }
        });
        Composite superComposite = new Composite(parent, 0);
        GridLayout superLayout = new GridLayout(4, false);
        GridData superLayoutData = new GridData(16384, 0x1000000, true, false);
        superComposite.setLayout((Layout)superLayout);
        superComposite.setLayoutData((Object)superLayoutData);
        Composite workingSetComposite = this.createActiveWorkingSetComposite(superComposite);
        workingSetComposite.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        Composite activeTaskComposite = this.createActiveTaskComposite(superComposite);
        activeTaskComposite.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        parent.layout();
        return parent;
    }

    private void createClearText(Composite parent) {
        if ((this.filterText.getStyle() & 0x100) == 0) {
            this.filterToolBar = new ToolBarManager(0x800100);
            this.filterToolBar.createControl(parent);
            Action clearTextAction = new Action("", 1){

                public void run() {
                    AbstractFilteredTree.this.clearText();
                }
            };
            clearTextAction.setToolTipText(WorkbenchMessages.FilteredTree_ClearToolTip);
            clearTextAction.setImageDescriptor(TasksUiImages.FIND_CLEAR);
            clearTextAction.setDisabledImageDescriptor(TasksUiImages.FIND_CLEAR_DISABLED);
            this.filterToolBar.add((IAction)clearTextAction);
        }
    }

    protected abstract Composite createProgressComposite(Composite var1);

    protected abstract Composite createActiveWorkingSetComposite(Composite var1);

    protected abstract Composite createActiveTaskComposite(Composite var1);

    protected Composite createSearchComposite(Composite container) {
        return null;
    }

    protected void textChanged() {
        if (this.refreshPolicy != null) {
            this.refreshPolicy.textChanged(this.filterText.getText());
        }
        this.updateToolbar(true);
    }

    protected Job getRefreshJob() {
        return this.refreshJob;
    }

    public AdaptiveRefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
        this.progressComposite.setVisible(showProgress);
        ((GridData)this.progressComposite.getLayoutData()).exclude = !showProgress;
        this.getParent().getParent().layout(true, true);
    }

    public void setShowSearch(boolean showSearch) {
        if (this.searchComposite != null) {
            this.searchComposite.setVisible(showSearch);
            ((GridData)this.searchComposite.getLayoutData()).exclude = !showSearch;
            this.getParent().getParent().layout(true, true);
        }
    }
}

