/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.ui.AbstractTaskListFilter;
import org.eclipse.mylyn.internal.tasks.ui.views.AbstractTaskListContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.IWorkingSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskListContentProvider
extends AbstractTaskListContentProvider {
    public TaskListContentProvider(TaskListView taskListView) {
        super(taskListView);
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        this.taskListView.expandToActiveTasks();
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        if (parent.equals(this.taskListView.getViewSite())) {
            return this.applyFilter(TasksUiPlugin.getTaskListManager().getTaskList().getRootElements()).toArray();
        }
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof AbstractTask) {
            Set queries = TasksUiPlugin.getTaskListManager().getTaskList().getQueriesForHandle(((AbstractTask)child).getHandleIdentifier());
            if (queries.size() > 0) {
                return queries.toArray()[0];
            }
            AbstractTaskCategory container = TasksUiPlugin.getTaskListManager().getTaskList().getContainerForHandle(((AbstractTask)child).getHandleIdentifier());
            if (container != null) {
                return container;
            }
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        return this.getFilteredChildrenFor(parent).toArray();
    }

    public boolean hasChildren(Object parent) {
        Object[] children = this.getChildren(parent);
        return children != null && children.length > 0;
    }

    protected List<AbstractTaskContainer> applyFilter(Set<AbstractTaskContainer> roots) {
        String filterText = this.taskListView.getFilteredTree().getFilterControl().getText();
        if (this.containsNoFilterText(filterText)) {
            ArrayList<AbstractTaskContainer> filteredRoots = new ArrayList<AbstractTaskContainer>();
            for (AbstractTaskContainer element : roots) {
                if (!this.selectContainer(element)) continue;
                filteredRoots.add(element);
            }
            return filteredRoots;
        }
        Set<IWorkingSet> workingSets = TaskListView.getActiveWorkingSets();
        HashSet<AbstractTaskContainer> workingSetContainers = new HashSet<AbstractTaskContainer>();
        if (workingSets.isEmpty()) {
            return new ArrayList<AbstractTaskContainer>(roots);
        }
        for (IWorkingSet workingSet : workingSets) {
            IAdaptable[] elements;
            IAdaptable[] iAdaptableArray = elements = workingSet.getElements();
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                IAdaptable adaptable = iAdaptableArray[n2];
                if (adaptable instanceof AbstractTaskContainer && roots.contains(adaptable)) {
                    workingSetContainers.add((AbstractTaskContainer)adaptable);
                }
                ++n2;
            }
        }
        return new ArrayList<AbstractTaskContainer>(workingSetContainers);
    }

    private boolean containsNoFilterText(String filterText) {
        return filterText == null || filterText.length() == 0;
    }

    private boolean selectContainer(AbstractTaskContainer container) {
        if (container instanceof ScheduledTaskContainer) {
            ScheduledTaskContainer scheduleContainer = (ScheduledTaskContainer)container;
            if (TasksUiPlugin.getTaskActivityManager().isWeekDay(scheduleContainer) && (scheduleContainer.isPresent() || scheduleContainer.isFuture())) {
                return true;
            }
            if (this.taskListView.isFocusedMode()) {
                return false;
            }
        }
        return !this.filter(null, container);
    }

    private List<AbstractTaskContainer> getFilteredChildrenFor(Object parent) {
        if (this.containsNoFilterText(this.taskListView.getFilteredTree().getFilterControl().getText())) {
            ArrayList<AbstractTaskContainer> children = new ArrayList<AbstractTaskContainer>();
            if (parent instanceof AbstractTask) {
                Set subTasks = ((AbstractTask)parent).getChildren();
                for (AbstractTask t : subTasks) {
                    if (this.filter(parent, t)) continue;
                    children.add((AbstractTaskContainer)t);
                }
                return children;
            }
            if (parent instanceof AbstractTaskContainer) {
                return this.getFilteredRootChildren((AbstractTaskContainer)parent);
            }
        } else {
            ArrayList<AbstractTaskContainer> children = new ArrayList<AbstractTaskContainer>();
            if (parent instanceof AbstractTaskContainer) {
                children.addAll(((AbstractTaskContainer)parent).getChildren());
                return children;
            }
        }
        return Collections.emptyList();
    }

    private List<AbstractTaskContainer> getFilteredRootChildren(AbstractTaskContainer parent) {
        ArrayList<AbstractTaskContainer> result = new ArrayList<AbstractTaskContainer>();
        if (TasksUiPlugin.getDefault().groupSubtasks(parent)) {
            Set parentTasks = parent.getChildren();
            HashSet<AbstractTask> parents = new HashSet<AbstractTask>();
            HashSet<AbstractTask> children = new HashSet<AbstractTask>();
            for (AbstractTask element : parentTasks) {
                for (AbstractTask abstractTask : element.getChildren()) {
                    children.add(abstractTask);
                }
            }
            for (AbstractTask task : parentTasks) {
                if (this.filter(parent, task) || children.contains(task)) continue;
                parents.add(task);
            }
            result.addAll(parents);
        } else {
            for (AbstractTaskContainer element : parent.getChildren()) {
                if (this.filter(parent, element)) continue;
                result.add(element);
            }
        }
        return result;
    }

    protected boolean filter(Object parent, Object object) {
        for (AbstractTaskListFilter filter : this.taskListView.getFilters()) {
            if (filter.select(parent, object)) continue;
            return true;
        }
        return false;
    }
}

