/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.io.File;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.mylyn.internal.tasks.ui.TaskTransfer;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyTaskDetailsAction;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TaskListDragSourceListener
implements DragSourceListener {
    static final String DELIM = ", ";
    private final TaskListView view;
    private StructuredSelection selection;

    public TaskListDragSourceListener(TaskListView view) {
        this.view = view;
    }

    public void dragStart(DragSourceEvent event) {
        StructuredSelection selection = (StructuredSelection)this.view.getViewer().getSelection();
        if (selection.isEmpty()) {
            this.selection = null;
            event.doit = false;
        } else {
            this.selection = selection;
        }
    }

    private List<File> createTaskFiles(StructuredSelection selection) {
        File tempDir = new File(String.valueOf(TasksUiPlugin.getDefault().getDataDirectory()) + File.separator + "temp");
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        ArrayList<AbstractRepositoryQuery> queries = new ArrayList<AbstractRepositoryQuery>();
        ArrayList<AbstractTask> tasks = new ArrayList<AbstractTask>();
        for (Object element : selection) {
            if (element instanceof AbstractRepositoryQuery) {
                queries.add((AbstractRepositoryQuery)element);
                continue;
            }
            if (!(element instanceof AbstractTask)) continue;
            tasks.add((AbstractTask)element);
        }
        ArrayList<File> taskFiles = new ArrayList<File>(queries.size() + tasks.size());
        try {
            File file;
            String encodedName;
            for (AbstractRepositoryQuery query : queries) {
                encodedName = URLEncoder.encode(query.getHandleIdentifier(), "UTF-8");
                file = File.createTempFile(encodedName, ".xml.zip", tempDir);
                file.deleteOnExit();
                TasksUiPlugin.getTaskListManager().getTaskListWriter().writeQueries(Collections.singletonList(query), file);
                taskFiles.add(file);
            }
            for (AbstractTask task : tasks) {
                encodedName = URLEncoder.encode(task.getHandleIdentifier(), "UTF-8");
                file = File.createTempFile(encodedName, ".xml.zip", tempDir);
                file.deleteOnExit();
                TasksUiPlugin.getTaskListManager().getTaskListWriter().writeTask(task, file);
                taskFiles.add(file);
            }
            return taskFiles;
        }
        catch (IOException e) {
            StatusHandler.fail((Throwable)e, (String)"Cannot create a temp query file for Drag&Drop", (boolean)true);
            return null;
        }
    }

    public void dragSetData(DragSourceEvent event) {
        if (this.selection == null || this.selection.isEmpty()) {
            return;
        }
        if (TaskTransfer.getInstance().isSupportedType(event.dataType)) {
            ArrayList<AbstractTask> tasks = new ArrayList<AbstractTask>();
            for (AbstractTaskContainer element : this.selection) {
                if (!(element instanceof AbstractTask)) continue;
                tasks.add((AbstractTask)element);
            }
            event.data = tasks.toArray(new AbstractTask[0]);
        } else if (FileTransfer.getInstance().isSupportedType(event.dataType)) {
            List<File> files = this.createTaskFiles(this.selection);
            if (files != null && !files.isEmpty()) {
                String[] paths = new String[files.size()];
                int i = 0;
                for (File file : files) {
                    paths[i++] = file.getAbsolutePath();
                }
                event.data = paths;
            }
        } else if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
            event.data = CopyTaskDetailsAction.getTextForTask(this.selection.getFirstElement());
        }
    }

    public void dragFinished(DragSourceEvent event) {
    }
}

