/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.internal.tasks.core.OrphanedTasksContainer;
import org.eclipse.mylyn.internal.tasks.core.ScheduledTaskContainer;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityUtil;
import org.eclipse.mylyn.internal.tasks.core.TaskCategory;
import org.eclipse.mylyn.internal.tasks.core.UnfiledCategory;
import org.eclipse.mylyn.internal.tasks.ui.RetrieveTitleFromUrlJob;
import org.eclipse.mylyn.internal.tasks.ui.TaskTransfer;
import org.eclipse.mylyn.internal.tasks.ui.actions.QueryImportAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskActivateAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.TaskImportAction;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class TaskListDropAdapter
extends ViewerDropAdapter {
    private AbstractTask newTask = null;
    private TransferData currentTransfer;

    public TaskListDropAdapter(Viewer viewer) {
        super(viewer);
        this.setFeedbackEnabled(true);
    }

    public void dragOver(DropTargetEvent event) {
        if (event.detail == 0 && (event.operations & 4) == 4) {
            event.detail = 4;
        }
        super.dragOver(event);
    }

    public boolean performDrop(Object data) {
        Object currentTarget = this.getCurrentTarget();
        ArrayList<AbstractTask> tasksToMove = new ArrayList<AbstractTask>();
        if (this.isUrl(data) && this.createTaskFromUrl(data)) {
            tasksToMove.add(this.newTask);
        } else if (TaskTransfer.getInstance().isSupportedType(this.currentTransfer) && data instanceof AbstractTask[]) {
            AbstractTask[] tasks;
            AbstractTask[] abstractTaskArray = tasks = (AbstractTask[])data;
            int n = tasks.length;
            int n2 = 0;
            while (n2 < n) {
                AbstractTask task = abstractTaskArray[n2];
                if (task != null) {
                    tasksToMove.add(task);
                }
                ++n2;
            }
        } else if (data instanceof String && this.createTaskFromString((String)data)) {
            tasksToMove.add(this.newTask);
        } else if (FileTransfer.getInstance().isSupportedType(this.currentTransfer)) {
            if (this.getCurrentTarget() instanceof AbstractTask) {
                AbstractTask targetTask = (AbstractTask)this.getCurrentTarget();
                String[] names = (String[])data;
                boolean confirmed = MessageDialog.openConfirm((Shell)this.getViewer().getControl().getShell(), (String)"Mylyn Information", (String)"Overwrite the context of the target task with the source's?");
                if (confirmed) {
                    String path = names[0];
                    File file = new File(path);
                    if (ContextCorePlugin.getContextManager().isValidContextFile(file)) {
                        ContextCorePlugin.getContextManager().copyContext(targetTask.getHandleIdentifier(), file);
                        new TaskActivateAction().run(targetTask);
                    }
                }
            } else {
                String[] names = (String[])data;
                ArrayList<AbstractRepositoryQuery> queries = new ArrayList<AbstractRepositoryQuery>();
                HashMap<AbstractTask, InteractionContext> taskContexts = new HashMap<AbstractTask, InteractionContext>();
                HashSet<TaskRepository> repositories = new HashSet<TaskRepository>();
                int i = 0;
                while (i < names.length) {
                    String path = names[i];
                    File file = new File(path);
                    if (file.isFile()) {
                        try {
                            List<AbstractRepositoryQuery> readQueries = TasksUiPlugin.getTaskListManager().getTaskListWriter().readQueries(file);
                            if (readQueries.size() > 0) {
                                queries.addAll(readQueries);
                                repositories.addAll(TasksUiPlugin.getTaskListManager().getTaskListWriter().readRepositories(file));
                            } else {
                                List<AbstractTask> readTasks = TasksUiPlugin.getTaskListManager().getTaskListWriter().readTasks(file);
                                for (AbstractTask task : readTasks) {
                                    taskContexts.put(task, ContextCorePlugin.getContextManager().loadContext(task.getHandleIdentifier(), file));
                                }
                                repositories.addAll(TasksUiPlugin.getTaskListManager().getTaskListWriter().readRepositories(file));
                            }
                        }
                        catch (IOException iOException) {
                            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    MessageDialog.openError(null, (String)"Query Import Error", (String)"The specified file is not an exported query. Please, check that you have provided the correct file.");
                                }
                            });
                        }
                    }
                    ++i;
                }
                if (queries.size() > 0) {
                    new QueryImportAction().importQueries(queries, repositories, this.getViewer().getControl().getShell());
                } else {
                    TaskImportAction action = new TaskImportAction();
                    action.importTasks(taskContexts, repositories, this.getViewer().getControl().getShell());
                    action.refreshTaskListView();
                }
            }
        }
        for (AbstractTask task : tasksToMove) {
            if (currentTarget instanceof UnfiledCategory) {
                TasksUiPlugin.getTaskListManager().getTaskList().moveTask(task, (AbstractTaskContainer)((UnfiledCategory)currentTarget));
                continue;
            }
            if (currentTarget instanceof TaskCategory) {
                TasksUiPlugin.getTaskListManager().getTaskList().moveTask(task, (AbstractTaskContainer)((TaskCategory)currentTarget));
                continue;
            }
            if (currentTarget instanceof OrphanedTasksContainer) {
                if (!((OrphanedTasksContainer)currentTarget).getRepositoryUrl().equals(task.getRepositoryUrl())) continue;
                TasksUiPlugin.getTaskListManager().getTaskList().moveTask(task, (AbstractTaskContainer)((AbstractTaskCategory)currentTarget));
                continue;
            }
            if (currentTarget instanceof AbstractTask) {
                AbstractTask targetTask = (AbstractTask)currentTarget;
                AbstractTaskCategory targetCategory = null;
                if (targetTask.getParentContainers().size() > 0) {
                    AbstractTaskContainer container = (AbstractTaskContainer)targetTask.getParentContainers().iterator().next();
                    if (container instanceof TaskCategory || container instanceof UnfiledCategory) {
                        targetCategory = (AbstractTaskCategory)container;
                    } else if (container instanceof OrphanedTasksContainer && ((OrphanedTasksContainer)container).getRepositoryUrl().equals(task.getRepositoryUrl())) {
                        targetCategory = (AbstractTaskCategory)container;
                    }
                }
                if (targetCategory == null) continue;
                TasksUiPlugin.getTaskListManager().getTaskList().moveTask(task, targetCategory);
                continue;
            }
            if (!(currentTarget instanceof ScheduledTaskContainer)) continue;
            ScheduledTaskContainer container = (ScheduledTaskContainer)currentTarget;
            Calendar newSchedule = Calendar.getInstance();
            newSchedule.setTimeInMillis(container.getStart().getTimeInMillis());
            TaskActivityUtil.snapEndOfWorkDay((Calendar)newSchedule);
            TasksUiPlugin.getTaskActivityManager().setScheduledFor(task, newSchedule.getTime());
        }
        if (this.newTask != null) {
            StructuredSelection ss = new StructuredSelection((Object)this.newTask);
            this.getViewer().setSelection((ISelection)ss);
            this.getViewer().refresh();
        }
        return true;
    }

    public boolean isUrl(Object data) {
        String uri = "";
        return data instanceof String && ((uri = (String)data).startsWith("http://") || uri.startsWith("https://"));
    }

    public boolean createTaskFromUrl(Object data) {
        if (!(data instanceof String)) {
            return false;
        }
        String[] urlTransfer = ((String)data).split("\n");
        String url = "";
        String urlTitle = "<retrieving from URL>";
        if (urlTransfer.length <= 0) {
            return false;
        }
        url = urlTransfer[0];
        AbstractRepositoryConnector connector = TasksUiPlugin.getRepositoryManager().getConnectorForRepositoryTaskUrl(url);
        if (connector != null) {
            String repositoryUrl = connector.getRepositoryUrlFromTaskUrl(url);
            String id = connector.getTaskIdFromTaskUrl(url);
            if (repositoryUrl == null || id == null) {
                return false;
            }
            for (TaskRepository repository : TasksUiPlugin.getRepositoryManager().getRepositories(connector.getConnectorKind())) {
                if (!repository.getUrl().equals(repositoryUrl)) continue;
                try {
                    this.newTask = connector.createTaskFromExistingId(repository, id, (IProgressMonitor)new NullProgressMonitor());
                    TasksUiUtil.refreshAndOpenTaskListElement((AbstractTaskContainer)this.newTask);
                    return true;
                }
                catch (CoreException e) {
                    StatusHandler.fail((Throwable)e, (String)"could not create task", (boolean)false);
                    return false;
                }
            }
            return false;
        }
        this.retrieveTaskDescription(url);
        this.newTask = TasksUiPlugin.getTaskListManager().createNewLocalTask(urlTitle);
        if (this.newTask == null) {
            return false;
        }
        this.newTask.setUrl(url);
        TasksUiUtil.openEditor(this.newTask, false);
        return true;
    }

    public boolean createTaskFromString(String title) {
        this.newTask = TasksUiPlugin.getTaskListManager().createNewLocalTask(title);
        if (this.newTask == null) {
            return false;
        }
        TasksUiUtil.openEditor(this.newTask, false);
        return true;
    }

    public boolean validateDrop(Object targetObject, int operation, TransferData transferType) {
        this.currentTransfer = transferType;
        if (FileTransfer.getInstance().isSupportedType(this.currentTransfer)) {
            return true;
        }
        if (TaskTransfer.getInstance().isSupportedType(this.currentTransfer)) {
            if (this.getCurrentTarget() instanceof UnfiledCategory || this.getCurrentTarget() instanceof TaskCategory || this.getCurrentTarget() instanceof OrphanedTasksContainer || this.getCurrentTarget() instanceof ScheduledTaskContainer) {
                return true;
            }
            return this.getCurrentTarget() instanceof AbstractTaskContainer && (this.getCurrentLocation() == 2 || this.getCurrentLocation() == 1);
        }
        return TextTransfer.getInstance().isSupportedType(transferType);
    }

    protected void retrieveTaskDescription(String url) {
        try {
            RetrieveTitleFromUrlJob job = new RetrieveTitleFromUrlJob(url){

                protected void setTitle(String pageTitle) {
                    TaskListDropAdapter.this.newTask.setSummary(pageTitle);
                    TasksUiPlugin.getTaskListManager().getTaskList().notifyTaskChanged(TaskListDropAdapter.this.newTask, false);
                }
            };
            job.schedule();
        }
        catch (RuntimeException e) {
            StatusHandler.fail((Throwable)e, (String)"could not open task web page", (boolean)false);
        }
    }
}

