/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.views;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.mylyn.internal.tasks.ui.actions.GoToUnreadTaskAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.MarkTaskReadAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.MarkTaskUnreadAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.ShowTooltipAction;
import org.eclipse.mylyn.internal.tasks.ui.views.TaskListView;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;

public class TaskListViewCommands {
    private static final String GO_TO_NEXT_UNREAD_TASK_COMMAND_ID = "org.eclipse.mylyn.tasks.ui.command.goToNextUnread";
    private static final String GO_TO_PREVIOUS_UNREAD_TASK_COMMAND_ID = "org.eclipse.mylyn.tasks.ui.command.goToPreviousUnread";
    private static final String SHOW_TOOLTIP_COMMAND_ID = "org.eclipse.mylyn.tasks.ui.command.showToolTip";
    private static final String MARK_TASK_READ_COMMAND_ID = "org.eclipse.mylyn.tasks.ui.command.markTaskRead";
    private static final String MARK_TASK_READ_GOTO_NEXT_TASK_COMMAND_ID = "org.eclipse.mylyn.tasks.ui.command.markTaskReadGoToNextUnread";
    private static final String MARK_TASK_READ_GOTO_PREVIOUS_TASK_COMMAND_ID = "org.eclipse.mylyn.tasks.ui.command.markTaskReadGoToPreviousUnread";
    private static final String MARK_TASK_UNREAD_COMMAND_ID = "org.eclipse.mylyn.tasks.ui.command.markTaskUnread";
    private final TaskListView taskListView;
    private List<AbstractHandler> handlers = new ArrayList<AbstractHandler>();

    public TaskListViewCommands(TaskListView taskListView) {
        this.taskListView = taskListView;
    }

    public void activateHandlers() {
        ICommandService commandSupport = (ICommandService)this.taskListView.getSite().getService(ICommandService.class);
        IHandlerService handlerService = (IHandlerService)this.taskListView.getSite().getService(IHandlerService.class);
        IContextService contextSupport = (IContextService)this.taskListView.getSite().getService(IContextService.class);
        if (commandSupport != null && handlerService != null && contextSupport != null) {
            contextSupport.activateContext("org.eclipse.mylyn.tasks.ui.views.tasks");
            AbstractHandler handler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    GoToUnreadTaskAction action = new GoToUnreadTaskAction();
                    action.init((IViewPart)TaskListViewCommands.this.taskListView);
                    action.run();
                    return null;
                }
            };
            this.handlers.add(handler);
            handlerService.activateHandler(GO_TO_NEXT_UNREAD_TASK_COMMAND_ID, (IHandler)handler);
            handler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    GoToUnreadTaskAction action = new GoToUnreadTaskAction();
                    action.init((IViewPart)TaskListViewCommands.this.taskListView);
                    action.setDirection(GoToUnreadTaskAction.Direction.UP);
                    action.run();
                    return null;
                }
            };
            this.handlers.add(handler);
            handlerService.activateHandler(GO_TO_PREVIOUS_UNREAD_TASK_COMMAND_ID, (IHandler)handler);
            handler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    ShowTooltipAction action = new ShowTooltipAction();
                    action.init((IViewPart)TaskListViewCommands.this.taskListView);
                    action.run();
                    return null;
                }
            };
            this.handlers.add(handler);
            handlerService.activateHandler(SHOW_TOOLTIP_COMMAND_ID, (IHandler)handler);
            handler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    MarkTaskReadAction action = new MarkTaskReadAction(TaskListViewCommands.this.taskListView.getSelectedTaskContainers());
                    if (action.isEnabled()) {
                        action.run();
                    }
                    return null;
                }
            };
            this.handlers.add(handler);
            handlerService.activateHandler(MARK_TASK_READ_COMMAND_ID, (IHandler)handler);
            handler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    return TaskListViewCommands.this.markReadGotoUnread(GoToUnreadTaskAction.Direction.DOWN);
                }
            };
            this.handlers.add(handler);
            handlerService.activateHandler(MARK_TASK_READ_GOTO_NEXT_TASK_COMMAND_ID, (IHandler)handler);
            handler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    return TaskListViewCommands.this.markReadGotoUnread(GoToUnreadTaskAction.Direction.UP);
                }
            };
            this.handlers.add(handler);
            handlerService.activateHandler(MARK_TASK_READ_GOTO_PREVIOUS_TASK_COMMAND_ID, (IHandler)handler);
            handler = new AbstractHandler(){

                public Object execute(ExecutionEvent event) throws ExecutionException {
                    MarkTaskUnreadAction action = new MarkTaskUnreadAction(TaskListViewCommands.this.taskListView.getSelectedTaskContainers());
                    if (action.isEnabled()) {
                        action.run();
                    }
                    return null;
                }
            };
            this.handlers.add(handler);
            handlerService.activateHandler(MARK_TASK_UNREAD_COMMAND_ID, (IHandler)handler);
        }
    }

    public void dispose() {
        for (AbstractHandler handler : this.handlers) {
            handler.dispose();
        }
        this.handlers.clear();
    }

    private Object markReadGotoUnread(GoToUnreadTaskAction.Direction direction) {
        MarkTaskReadAction markReadAction = new MarkTaskReadAction(this.taskListView.getSelectedTaskContainers());
        if (markReadAction.isEnabled()) {
            markReadAction.run();
            GoToUnreadTaskAction goToAction = new GoToUnreadTaskAction();
            goToAction.setDirection(direction);
            goToAction.init((IViewPart)this.taskListView);
            goToAction.run();
        }
        return null;
    }
}

