/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class EditRepositoryWizard
extends Wizard
implements INewWizard {
    private static final String TITLE = "Task Repository Settings";
    private AbstractRepositorySettingsPage abstractRepositorySettingsPage;
    private TaskRepository repository;

    public EditRepositoryWizard(TaskRepository repository) {
        this.repository = repository;
        AbstractRepositoryConnectorUi connectorUi = TasksUiPlugin.getConnectorUi(repository.getConnectorKind());
        this.abstractRepositorySettingsPage = connectorUi.getSettingsPage();
        this.abstractRepositorySettingsPage.setRepository(repository);
        this.abstractRepositorySettingsPage.setVersion(repository.getVersion());
        this.abstractRepositorySettingsPage.setWizard((IWizard)this);
        this.setNeedsProgressMonitor(true);
        this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY_SETTINGS);
        this.setWindowTitle(TITLE);
    }

    public boolean performFinish() {
        if (this.canFinish()) {
            String oldUrl = this.repository.getUrl();
            String newUrl = this.abstractRepositorySettingsPage.getServerUrl();
            TasksUiPlugin.getTaskListManager().refactorRepositoryUrl(oldUrl, newUrl);
            this.repository.flushAuthenticationCredentials();
            this.repository.setUrl(newUrl);
            this.abstractRepositorySettingsPage.applyTo(this.repository);
            this.abstractRepositorySettingsPage.updateProperties(this.repository);
            TasksUiPlugin.getRepositoryManager().notifyRepositorySettingsChanged(this.repository);
            TasksUiPlugin.getRepositoryManager().saveRepositories(TasksUiPlugin.getDefault().getRepositoriesFilePath());
            return true;
        }
        return false;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.addPage((IWizardPage)this.abstractRepositorySettingsPage);
    }

    public boolean canFinish() {
        return this.abstractRepositorySettingsPage.isPageComplete();
    }

    public AbstractRepositorySettingsPage getSettingsPage() {
        return this.abstractRepositorySettingsPage;
    }

    public TaskRepository getRepository() {
        return this.repository;
    }
}

