/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.internal.tasks.core.LocalAttachment;
import org.eclipse.mylyn.internal.tasks.core.RepositoryTaskHandleUtil;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.wizards.InputAttachmentSourcePage;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentPage;
import org.eclipse.mylyn.internal.tasks.ui.wizards.NewAttachmentWizardDialog;
import org.eclipse.mylyn.internal.tasks.ui.wizards.ScreenshotAttachmentPage;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractAttachmentHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.ITaskAttachment;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRepositoryTaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class NewAttachmentWizard
extends Wizard {
    private static final String DIALOG_SETTINGS_KEY = "AttachmentWizard";
    protected static final String CLIPBOARD_FILENAME = "clipboard.txt";
    protected static final String SCREENSHOT_FILENAME = "screenshot.jpg";
    private LocalAttachment attachment;
    private InputAttachmentSourcePage inputPage;
    private NewAttachmentPage attachPage;
    private NewAttachmentWizardDialog dialog;
    private ScreenshotAttachmentPage shotPage;
    private boolean hasNewDialogSettings;
    private TaskRepository repository;
    private AbstractTask task;
    private boolean screenshotMode;

    public NewAttachmentWizard(TaskRepository repository, AbstractTask task, boolean screenshotMode) {
        this.task = task;
        this.repository = repository;
        this.screenshotMode = screenshotMode;
        if (screenshotMode) {
            this.setWindowTitle("Attach Screenshot");
            this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_SCREENSHOT);
        } else {
            this.setWindowTitle("Add Attachment");
            this.setDefaultPageImageDescriptor(TasksUiImages.BANNER_REPOSITORY);
        }
        this.inputPage = new InputAttachmentSourcePage(this);
        this.attachment = new LocalAttachment();
        this.attachment.setFilePath("");
        this.setNeedsProgressMonitor(true);
        IDialogSettings workbenchSettings = TasksUiPlugin.getDefault().getDialogSettings();
        IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
        if (section == null) {
            this.hasNewDialogSettings = true;
        } else {
            this.hasNewDialogSettings = false;
            this.setDialogSettings(section);
        }
    }

    public NewAttachmentWizard(TaskRepository repository, AbstractTask task) {
        this(repository, task, false);
    }

    public NewAttachmentWizard(TaskRepository repository, AbstractTask task, File attachFile) {
        this(repository, task, false);
        this.attachment.setFilePath(attachFile.getAbsolutePath());
    }

    public NewAttachmentWizard(TaskRepository repository, AbstractTask task, String attachContents) {
        this(repository, task, false);
        this.inputPage.setUseClipboard(true);
        this.inputPage.setClipboardContents(attachContents);
        this.attachment.setFilePath("<Clipboard>");
    }

    public boolean performFinish() {
        AbstractRepositoryConnector connector;
        AbstractAttachmentHandler attachmentHandler;
        this.attachPage.populateAttachment();
        final String path = this.inputPage.getAbsoluteAttachmentPath();
        if (this.hasNewDialogSettings) {
            IDialogSettings workbenchSettings = TasksUiPlugin.getDefault().getDialogSettings();
            IDialogSettings section = workbenchSettings.getSection(DIALOG_SETTINGS_KEY);
            section = workbenchSettings.addNewSection(DIALOG_SETTINGS_KEY);
            this.setDialogSettings(section);
        }
        if ((attachmentHandler = (connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.repository.getConnectorKind())).getAttachmentHandler()) == null) {
            return false;
        }
        final boolean attachContext = this.attachPage.getAttachContext();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        if (monitor == null) {
                            monitor = new NullProgressMonitor();
                        }
                        monitor.beginTask("Attaching file...", 2);
                        NewAttachmentWizard.this.task.setSubmitting(true);
                        NewAttachmentWizard.this.task.setSynchronizationState(AbstractTask.RepositoryTaskSyncState.OUTGOING);
                        if (NewAttachmentWizard.this.screenshotMode || "<Screenshot>".equals(path)) {
                            Image image = NewAttachmentWizard.this.shotPage.getScreenshotImage();
                            if (image == null) {
                                throw new InvocationTargetException(new CoreException((IStatus)new RepositoryStatus(4, "org.eclipse.mylyn.tasks.ui", 7, "Screenshot is empty", null)));
                            }
                            String path2 = TasksUiPlugin.getDefault().getDefaultDataDirectory();
                            ImageLoader loader = new ImageLoader();
                            loader.data = new ImageData[]{image.getImageData()};
                            String fileName = String.valueOf(path2) + "/" + NewAttachmentWizard.SCREENSHOT_FILENAME;
                            loader.save(fileName, 4);
                            NewAttachmentWizard.this.attachment.setFile(new File(fileName));
                            NewAttachmentWizard.this.attachment.setFilename(NewAttachmentWizard.SCREENSHOT_FILENAME);
                        } else if ("<Clipboard>".equals(path)) {
                            String contents = NewAttachmentWizard.this.inputPage.getClipboardContents();
                            if (contents == null) {
                                throw new InvocationTargetException(new CoreException((IStatus)new RepositoryStatus(4, "org.eclipse.mylyn.tasks.ui", 7, "Clipboard is empty", null)));
                            }
                            NewAttachmentWizard.this.attachment.setContent(contents.getBytes());
                            NewAttachmentWizard.this.attachment.setFilename(NewAttachmentWizard.CLIPBOARD_FILENAME);
                        } else {
                            File file = new File(path);
                            NewAttachmentWizard.this.attachment.setFile(file);
                            NewAttachmentWizard.this.attachment.setFilename(file.getName());
                        }
                        attachmentHandler.uploadAttachment(NewAttachmentWizard.this.repository, NewAttachmentWizard.this.task, (ITaskAttachment)NewAttachmentWizard.this.attachment, NewAttachmentWizard.this.attachment.getComment(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        if (attachContext && connector.getAttachmentHandler() != null) {
                            connector.getAttachmentHandler().attachContext(NewAttachmentWizard.this.repository, NewAttachmentWizard.this.task, "", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, op);
            TasksUiPlugin.getSynchronizationManager().synchronize(connector, this.task, false, (IJobChangeListener)new JobChangeAdapter(){

                public void done(final IJobChangeEvent event) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            if (event.getResult().getException() != null) {
                                MessageDialog.openError((Shell)Display.getDefault().getActiveShell(), (String)"Mylyn Information", (String)event.getResult().getMessage());
                            }
                            NewAttachmentWizard.forceRefreshInplace(NewAttachmentWizard.this.task);
                        }
                    });
                }
            });
        }
        catch (InvocationTargetException e1) {
            this.task.setSubmitting(false);
            this.task.setSynchronizationState(AbstractTask.RepositoryTaskSyncState.SYNCHRONIZED);
            if (e1.getCause() != null && e1.getCause() instanceof CoreException) {
                this.handleSubmitError((CoreException)e1.getCause());
            } else {
                StatusHandler.fail((Throwable)e1, (String)"Attachment failure", (boolean)true);
            }
            return false;
        }
        catch (InterruptedException interruptedException) {
            this.task.setSubmitting(false);
            this.task.setSynchronizationState(AbstractTask.RepositoryTaskSyncState.SYNCHRONIZED);
        }
        return true;
    }

    public static boolean forceRefreshInplace(AbstractTask task) {
        if (task != null) {
            String handleTarget = task.getHandleIdentifier();
            for (TaskEditor editor : TasksUiUtil.getActiveRepositoryTaskEditors()) {
                Object input;
                if (editor.getEditorInput() instanceof AbstractRepositoryTaskEditorInput) {
                    String handle;
                    input = (AbstractRepositoryTaskEditorInput)editor.getEditorInput();
                    if (((AbstractRepositoryTaskEditorInput)input).getTaskData() == null || !(handle = RepositoryTaskHandleUtil.getHandle((String)((AbstractRepositoryTaskEditorInput)input).getTaskData().getRepositoryUrl(), (String)((AbstractRepositoryTaskEditorInput)input).getTaskData().getId())).equals(handleTarget)) continue;
                    editor.refreshEditorContents();
                    editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
                    return true;
                }
                if (!(editor.getEditorInput() instanceof TaskEditorInput) || !((TaskEditorInput)(input = (TaskEditorInput)editor.getEditorInput())).getTask().getHandleIdentifier().equals(handleTarget)) continue;
                editor.refreshEditorContents();
                editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
                return true;
            }
        }
        return false;
    }

    private void handleSubmitError(CoreException exception) {
        if (exception.getStatus().getCode() == 3) {
            TasksUiUtil.openEditRepositoryWizard(this.repository);
        } else {
            StatusHandler.displayStatus((String)"Attachment failed", (IStatus)exception.getStatus());
        }
    }

    protected boolean hasContext() {
        return ContextCorePlugin.getContextManager().hasContext(this.task.getHandleIdentifier());
    }

    public boolean canFinish() {
        if (this.screenshotMode) {
            return this.shotPage.isPageComplete();
        }
        return this.attachPage.isPageComplete();
    }

    public void addPages() {
        super.addPages();
        if (this.screenshotMode) {
            this.shotPage = new ScreenshotAttachmentPage(this.attachment);
            this.addPage((IWizardPage)this.shotPage);
            this.attachPage = new NewAttachmentPage(this.attachment);
            this.addPage((IWizardPage)this.attachPage);
        } else {
            if ("".equals(this.attachment.getFilePath())) {
                this.addPage((IWizardPage)this.inputPage);
            }
            this.attachPage = new NewAttachmentPage(this.attachment);
            this.addPage((IWizardPage)this.attachPage);
        }
    }

    public LocalAttachment getAttachment() {
        return this.attachment;
    }

    protected String getFilePath() {
        return this.inputPage.getAttachmentName();
    }

    public IWizardPage getNextPage(IWizardPage page) {
        if (page == this.inputPage) {
            this.attachPage.setFilePath(this.inputPage.getAttachmentName());
        }
        return super.getNextPage(page);
    }

    public void showPage(IWizardPage page) {
        this.dialog.showPage(page);
    }

    public void setDialog(NewAttachmentWizardDialog dialog) {
        this.dialog = dialog;
    }

    public String getClipboardContents() {
        return this.inputPage.getClipboardContents();
    }

    public boolean needsPreviousAndNextButtons() {
        return true;
    }
}

