/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.ui.wizards;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mylyn.internal.monitor.core.util.ZipFileUtil;
import org.eclipse.mylyn.internal.tasks.ui.wizards.TaskDataImportWizardPage;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class TaskDataImportWizard
extends Wizard
implements IImportWizard {
    private static final String SETTINGS_SECTION = "org.eclipse.mylyn.tasklist.ui.importWizard";
    private static final String WINDOW_TITLE = "Import";
    private TaskDataImportWizardPage importPage = null;

    public TaskDataImportWizard() {
        IDialogSettings masterSettings = TasksUiPlugin.getDefault().getDialogSettings();
        this.setDialogSettings(this.getSettingsSection(masterSettings));
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(WINDOW_TITLE);
    }

    public IDialogSettings getSettingsSection(IDialogSettings master) {
        IDialogSettings settings = master.getSection(SETTINGS_SECTION);
        if (settings == null) {
            settings = master.addNewSection(SETTINGS_SECTION);
        }
        return settings;
    }

    public void addPages() {
        this.importPage = new TaskDataImportWizardPage();
        this.importPage.setWizard((IWizard)this);
        this.addPage((IWizardPage)this.importPage);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean canFinish() {
        return this.importPage.isPageComplete();
    }

    public boolean performFinish() {
        TasksUiPlugin.getTaskListManager().deactivateTask(TasksUiPlugin.getTaskListManager().getTaskList().getActiveTask());
        File sourceDirFile = null;
        File sourceZipFile = null;
        File sourceTaskListFile = null;
        File sourceRepositoriesFile = null;
        File sourceActivationHistoryFile = null;
        ArrayList<File> contextFiles = new ArrayList<File>();
        ArrayList<ZipEntry> zipFilesToExtract = new ArrayList<ZipEntry>();
        boolean overwrite = this.importPage.overwrite();
        String sourceZip = this.importPage.getSourceZipFile();
        sourceZipFile = new File(sourceZip);
        if (!sourceZipFile.exists()) {
            MessageDialog.openError((Shell)this.getShell(), (String)"File not found", (String)(String.valueOf(sourceZipFile.toString()) + " could not be found."));
            return false;
        }
        try {
            ZipFile zipFile = new ZipFile(sourceZipFile, 1);
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory() || !this.importPage.importTaskList() && entry.getName().endsWith("tasklist.xml") || !this.importPage.importActivationHistory() && entry.getName().endsWith("activity.xml") || !this.importPage.importTaskContexts() && entry.getName().matches(".*-\\d*.xml$")) continue;
                File destContextFile = new File(String.valueOf(TasksUiPlugin.getDefault().getDataDirectory()) + File.separator + entry.getName());
                if (!overwrite && destContextFile.exists()) {
                    if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)"File exists!", (String)("Overwrite existing file?\n" + destContextFile.getName()))) continue;
                    zipFilesToExtract.add(entry);
                    continue;
                }
                zipFilesToExtract.add(entry);
            }
        }
        catch (IOException e) {
            StatusHandler.fail((Throwable)e, (String)"Could not import files", (boolean)true);
        }
        FileCopyJob job = new FileCopyJob(sourceDirFile, sourceZipFile, sourceTaskListFile, sourceRepositoriesFile, sourceActivationHistoryFile, contextFiles, zipFilesToExtract);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            service.run(true, false, (IRunnableWithProgress)job);
        }
        catch (InvocationTargetException e) {
            StatusHandler.fail((Throwable)e, (String)"Could not import files", (boolean)true);
        }
        catch (InterruptedException e) {
            StatusHandler.fail((Throwable)e, (String)"Could not import files", (boolean)true);
        }
        this.importPage.saveSettings();
        return true;
    }

    private void readTaskListData() {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                TasksUiPlugin.getDefault().reloadDataDirectory(true);
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FileCopyJob
    implements IRunnableWithProgress {
        private static final String JOB_LABEL = "Importing Data";
        private File sourceZipFile = null;
        private List<ZipEntry> zipEntriesToExtract;

        public FileCopyJob(File sourceFolder, File sourceZipFile, File sourceTaskListFile, File sourceRepositoriesFile, File sourceActivationHistoryFile, List<File> contextFiles, List<ZipEntry> zipEntries) {
            this.sourceZipFile = sourceZipFile;
            this.zipEntriesToExtract = zipEntries;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor.beginTask(JOB_LABEL, this.zipEntriesToExtract.size() + 2);
            try {
                ZipFileUtil.extactEntries((File)this.sourceZipFile, this.zipEntriesToExtract, (String)TasksUiPlugin.getDefault().getDataDirectory());
            }
            catch (IOException iOException) {
                StatusHandler.fail((Throwable)new Exception("Import Exception"), (String)"Problem occured extracting from zip file.", (boolean)true);
                return;
            }
            TaskDataImportWizard.this.readTaskListData();
            monitor.done();
        }
    }
}

