/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui;

import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.monitor.core.DateUtil;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryQuery;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.ITaskCollector;
import org.eclipse.mylyn.tasks.core.ITaskFactory;
import org.eclipse.mylyn.tasks.core.QueryHitCollector;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.SynchronizeTaskJob;
import org.eclipse.mylyn.tasks.ui.TaskFactory;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SynchronizeQueryJob
extends Job {
    private final AbstractRepositoryConnector connector;
    private final TaskRepository repository;
    private final Set<AbstractRepositoryQuery> queries;
    private final TaskList taskList;
    private boolean synchronizeChangedTasks;
    private boolean forced = false;
    private HashSet<AbstractTask> tasksToBeSynchronized = new HashSet();
    private boolean fullSynchronization = true;

    public SynchronizeQueryJob(AbstractRepositoryConnector connector, TaskRepository repository, Set<AbstractRepositoryQuery> queries, TaskList taskList) {
        super("Synchronizing queries for " + repository.getRepositoryLabel());
        this.connector = connector;
        this.repository = repository;
        this.queries = queries;
        this.taskList = taskList;
    }

    public void setSynchronizeChangedTasks(boolean synchronizeChangedTasks) {
        this.synchronizeChangedTasks = synchronizeChangedTasks;
    }

    public boolean isFullSynchronization() {
        return this.fullSynchronization;
    }

    public void setFullSynchronization(boolean fullSynchronization) {
        this.fullSynchronization = fullSynchronization;
    }

    public boolean isForced() {
        return this.forced;
    }

    public void setForced(boolean forced) {
        this.forced = forced;
    }

    /*
     * Iterators could be improved
     * Loose catch block
     */
    protected IStatus run(IProgressMonitor monitor) {
        try {
            monitor.beginTask("Synchronizing " + this.queries.size() + " queries", 20 + this.queries.size() * 10 + 40);
            Set allTasks = Collections.unmodifiableSet(this.taskList.getRepositoryTasks(this.repository.getUrl()));
            for (AbstractTask task : allTasks) {
                task.setStale(false);
            }
            if (this.isFullSynchronization()) {
                try {
                    monitor.subTask("Checking for changed tasks");
                    boolean hasChangedOrNew = this.connector.markStaleTasks(this.repository, allTasks, (IProgressMonitor)new SubProgressMonitor(monitor, 20));
                    if (!hasChangedOrNew && !this.forced) {
                        this.updateQueryStatus(null);
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                }
                catch (CoreException e) {
                    this.updateQueryStatus(e.getStatus());
                    IStatus iStatus = Status.OK_STATUS;
                    monitor.done();
                    return iStatus;
                }
            }
            int n = 0;
            for (AbstractRepositoryQuery repositoryQuery : this.queries) {
                repositoryQuery.setSynchronizationStatus(null);
                monitor.setTaskName("Synchronizing " + ++n + "/" + this.queries.size() + ": " + repositoryQuery.getSummary());
                this.synchronizeQuery(repositoryQuery, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                repositoryQuery.setSynchronizing(false);
                this.taskList.notifyContainersUpdated(Collections.singleton(repositoryQuery));
            }
            if (!this.forced) {
                for (AbstractTask task : allTasks) {
                    if (!task.isStale()) continue;
                    this.tasksToBeSynchronized.add(task);
                    task.setSynchronizing(true);
                }
            }
            if (!this.tasksToBeSynchronized.isEmpty()) {
                monitor.setTaskName("Synchronizing " + this.tasksToBeSynchronized.size() + " changed tasks");
                SynchronizeTaskJob job = new SynchronizeTaskJob(this.connector, this.tasksToBeSynchronized);
                job.setForced(this.forced);
                job.run((IProgressMonitor)new SubProgressMonitor(monitor, 40));
                if (Platform.isRunning() && TasksUiPlugin.getRepositoryManager() != null && this.isFullSynchronization()) {
                    TasksUiPlugin.getRepositoryManager().setSynchronizationTime(this.repository, this.connector.getSynchronizationTimestamp(this.repository, this.tasksToBeSynchronized), TasksUiPlugin.getDefault().getRepositoriesFilePath());
                }
            }
            this.taskList.notifyContainersUpdated(null);
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
            {
                catch (OperationCanceledException operationCanceledException) {
                    IStatus iStatus2 = Status.CANCEL_STATUS;
                    return iStatus2;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    private void updateQueryStatus(final IStatus status) {
        for (AbstractRepositoryQuery repositoryQuery : this.queries) {
            repositoryQuery.setSynchronizationStatus(status);
            repositoryQuery.setSynchronizing(false);
        }
        this.taskList.notifyContainersUpdated(this.queries);
        if (status != null && this.isForced()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    StatusHandler.displayStatus((String)"Query Synchronization Failed", (IStatus)status);
                }
            });
        }
    }

    private void synchronizeQuery(AbstractRepositoryQuery repositoryQuery, IProgressMonitor monitor) {
        this.setProperty(IProgressConstants.ICON_PROPERTY, TasksUiImages.REPOSITORY_SYNCHRONIZE);
        QueryHitCollector collector = new QueryHitCollector((ITaskFactory)new TaskFactory(this.repository, true, false));
        final IStatus resultingStatus = this.connector.performQuery(repositoryQuery, this.repository, monitor, (ITaskCollector)collector);
        if (resultingStatus.getSeverity() != 8) {
            if (resultingStatus.isOK()) {
                if (collector.getTasks().size() >= 5000) {
                    StatusHandler.log((String)("Max allowed number of hits returned exceeded. Some hits may not be displayed. Please narrow query scope.\n" + repositoryQuery.getSummary()), (Object)((Object)this));
                }
                for (AbstractTask removedTask : repositoryQuery.getChildren()) {
                    this.taskList.removeFromQuery(repositoryQuery, removedTask);
                }
                for (AbstractTask hit : collector.getTasks()) {
                    AbstractTask task = this.taskList.getTask(hit.getHandleIdentifier());
                    if (task != null) {
                        boolean changed = this.connector.updateTaskFromQueryHit(this.repository, task, hit);
                        if (changed && !task.isStale() && task.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.SYNCHRONIZED) {
                            task.setSynchronizationState(AbstractTask.RepositoryTaskSyncState.INCOMING);
                        }
                        task.setSynchronizationStatus(null);
                        task.setSynchronizing(false);
                    } else {
                        task = hit;
                        task.setStale(true);
                        task.setSynchronizationState(AbstractTask.RepositoryTaskSyncState.INCOMING);
                    }
                    this.taskList.addTask(task, (AbstractTaskContainer)repositoryQuery);
                    if (!this.synchronizeChangedTasks || !task.isStale()) continue;
                    this.tasksToBeSynchronized.add(task);
                    task.setSynchronizing(true);
                }
                repositoryQuery.setLastSynchronizedStamp(DateUtil.getFormattedDate((Date)new Date(), (String)"MMM d, H:mm:ss"));
            } else {
                repositoryQuery.setSynchronizationStatus(resultingStatus);
                if (this.isForced()) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            StatusHandler.displayStatus((String)"Query Synchronization Failed", (IStatus)resultingStatus);
                        }
                    });
                }
            }
        }
    }
}

