/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui;

import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.ITaskFactory;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskList;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.RepositorySynchronizationManager;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;

public class TaskFactory
implements ITaskFactory {
    private final AbstractRepositoryConnector connector;
    private final RepositorySynchronizationManager synchManager;
    private final TaskRepository repository;
    private final TaskList taskList;
    private final AbstractTaskDataHandler dataHandler;
    private final boolean updateTasklist;
    private final boolean forced;

    public TaskFactory(TaskRepository repository, boolean updateTasklist, boolean forced) {
        this.repository = repository;
        this.updateTasklist = updateTasklist;
        this.forced = forced;
        this.connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(repository.getConnectorKind());
        this.synchManager = TasksUiPlugin.getSynchronizationManager();
        this.taskList = TasksUiPlugin.getTaskListManager().getTaskList();
        this.dataHandler = this.connector.getTaskDataHandler();
    }

    @Deprecated
    public TaskFactory(TaskRepository repository) {
        this(repository, true, false);
    }

    public AbstractTask createTask(RepositoryTaskData taskData, IProgressMonitor monitor) throws CoreException {
        AbstractTask repositoryTask = this.taskList.getTask(taskData.getRepositoryUrl(), taskData.getId());
        if (repositoryTask == null) {
            repositoryTask = this.connector.createTaskFromTaskData(this.repository, taskData, this.updateTasklist, monitor);
            repositoryTask.setSynchronizationState(AbstractTask.RepositoryTaskSyncState.INCOMING);
            if (this.updateTasklist) {
                this.taskList.addTask(repositoryTask);
                this.synchManager.saveIncoming(repositoryTask, taskData, this.forced);
            } else {
                this.synchManager.saveOffline(repositoryTask, taskData);
            }
        } else if (this.updateTasklist) {
            this.synchManager.saveIncoming(repositoryTask, taskData, this.forced);
            this.connector.updateTaskFromTaskData(this.repository, repositoryTask, taskData);
            if (this.dataHandler != null) {
                repositoryTask.clear();
                Set subTaskIds = this.dataHandler.getSubTaskIds(taskData);
                if (subTaskIds != null) {
                    for (String subId : subTaskIds) {
                        AbstractTask subTask;
                        if (subId == null || subId.trim().equals("") || (subTask = this.connector.createTaskFromExistingId(this.repository, subId, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) == null) continue;
                        this.taskList.addTask(subTask, (AbstractTaskContainer)repositoryTask);
                    }
                }
            }
        }
        return repositoryTask;
    }
}

