/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.tasks.ui.editors;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mylyn.internal.tasks.core.CommentQuoter;
import org.eclipse.mylyn.internal.tasks.ui.PersonProposalLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.PersonProposalProvider;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.tasks.ui.actions.AttachAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.AttachScreenshotAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.CopyAttachmentToClipboardJob;
import org.eclipse.mylyn.internal.tasks.ui.actions.DownloadAttachmentJob;
import org.eclipse.mylyn.internal.tasks.ui.actions.NewSubTaskAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.SynchronizeEditorAction;
import org.eclipse.mylyn.internal.tasks.ui.actions.ToggleTaskActivationAction;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttachmentTableLabelProvider;
import org.eclipse.mylyn.internal.tasks.ui.editors.AttachmentsTableContentProvider;
import org.eclipse.mylyn.internal.tasks.ui.editors.ContentOutlineTools;
import org.eclipse.mylyn.internal.tasks.ui.editors.IRepositoryTaskAttributeListener;
import org.eclipse.mylyn.internal.tasks.ui.editors.IRepositoryTaskSelection;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryAttachmentEditorInput;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTaskOutlineNode;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTaskOutlinePage;
import org.eclipse.mylyn.internal.tasks.ui.editors.RepositoryTaskSelection;
import org.eclipse.mylyn.internal.tasks.ui.editors.TaskUrlHyperlink;
import org.eclipse.mylyn.internal.tasks.ui.views.ResetRepositoryConfigurationAction;
import org.eclipse.mylyn.monitor.core.DateUtil;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.AbstractTaskCategory;
import org.eclipse.mylyn.tasks.core.AbstractTaskContainer;
import org.eclipse.mylyn.tasks.core.AbstractTaskDataHandler;
import org.eclipse.mylyn.tasks.core.ITaskListChangeListener;
import org.eclipse.mylyn.tasks.core.RepositoryAttachment;
import org.eclipse.mylyn.tasks.core.RepositoryOperation;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.RepositoryTaskAttribute;
import org.eclipse.mylyn.tasks.core.RepositoryTaskData;
import org.eclipse.mylyn.tasks.core.TaskComment;
import org.eclipse.mylyn.tasks.core.TaskContainerDelta;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.AbstractDuplicateDetector;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.TasksUiUtil;
import org.eclipse.mylyn.tasks.ui.editors.AbstractRenderingEngine;
import org.eclipse.mylyn.tasks.ui.editors.RepositoryTaskEditorDropListener;
import org.eclipse.mylyn.tasks.ui.editors.RepositoryTaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskFormPage;
import org.eclipse.mylyn.tasks.ui.search.SearchHitCollector;
import org.eclipse.osgi.util.NLS;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.fieldassist.ContentAssistCommandAdapter;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.themes.IThemeManager;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRepositoryTaskEditor
extends TaskFormPage {
    private static final String ERROR_NOCONNECTIVITY = "Unable to submit at this time. Check connectivity and retry.";
    private static final String LABEL_HISTORY = "History";
    private static final String LABEL_REPLY = "Reply";
    private static final String LABEL_JOB_SUBMIT = "Submitting to repository";
    private static final String HEADER_DATE_FORMAT = "yyyy-MM-dd HH:mm";
    private static final String ATTACHMENT_DEFAULT_NAME = "attachment";
    private static final String CTYPE_ZIP = "zip";
    private static final String CTYPE_OCTET_STREAM = "octet-stream";
    private static final String CTYPE_TEXT = "text";
    private static final String CTYPE_HTML = "html";
    private static final String LABEL_BROWSER = "Browser";
    private static final String LABEL_DEFAULT_EDITOR = "Default Editor";
    private static final String LABEL_TEXT_EDITOR = "Text Editor";
    protected static final String CONTEXT_MENU_ID = "#MylynRepositoryEditor";
    private FormToolkit toolkit;
    private ScrolledForm form;
    protected TaskRepository repository;
    private static final int RADIO_OPTION_WIDTH = 120;
    private static final Font TITLE_FONT = JFaceResources.getBannerFont();
    protected static final Font TEXT_FONT = JFaceResources.getDefaultFont();
    private static final int DESCRIPTION_WIDTH = 553;
    private static final int DESCRIPTION_HEIGHT = 140;
    protected static final int SUMMARY_HEIGHT = 20;
    private static final String LABEL_BUTTON_SUBMIT = "Submit";
    private static final String LABEL_COPY_URL_TO_CLIPBOARD = "Copy &URL";
    private static final String LABEL_COPY_TO_CLIPBOARD = "Copy Contents";
    private static final String LABEL_SAVE = "Save...";
    private static final String LABEL_SEARCH_DUPS = "Search";
    private static final String LABEL_SELECT_DETECTOR = "Duplicate Detection";
    private RepositoryTaskEditorInput editorInput;
    private TaskEditor parentEditor = null;
    private RepositoryTaskOutlineNode taskOutlineModel = null;
    private boolean expandedStateAttributes = false;
    protected Button submitButton;
    private Table attachmentsTable;
    private TableViewer attachmentsTableViewer;
    private String[] attachmentsColumns = new String[]{"Name", "Description", "Type", "Creator", "Created"};
    private int[] attachmentsColumnWidths = new int[]{140, 160, 100, 100, 100};
    private Composite editorComposite;
    protected TextViewer summaryTextViewer;
    protected Text summaryText;
    private TextViewer newCommentTextViewer;
    private List ccList;
    private Section commentsSection;
    private Color colorIncoming;
    private boolean hasAttributeChanges = false;
    private boolean showAttachments = true;
    private boolean attachContextEnabled = true;
    protected Button searchForDuplicates;
    protected CCombo duplicateDetectorChooser;
    protected Label duplicateDetectorLabel;
    private boolean ignoreLocationEvents = false;
    private TaskComment selectedComment = null;
    private java.util.List<IRepositoryTaskAttributeListener> attributesListeners = new ArrayList<IRepositoryTaskAttributeListener>();
    protected RepositoryTaskData taskData;
    protected final ISelectionProvider selectionProvider = new ISelectionProvider(){

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            AbstractRepositoryTaskEditor.this.selectionChangedListeners.add(listener);
        }

        public ISelection getSelection() {
            RepositoryTaskSelection selection = new RepositoryTaskSelection(AbstractRepositoryTaskEditor.this.taskData.getId(), AbstractRepositoryTaskEditor.this.taskData.getRepositoryUrl(), AbstractRepositoryTaskEditor.this.taskData.getRepositoryKind(), "", AbstractRepositoryTaskEditor.this.selectedComment, AbstractRepositoryTaskEditor.this.taskData.getSummary());
            selection.setIsDescription(true);
            return selection;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            AbstractRepositoryTaskEditor.this.selectionChangedListeners.remove(listener);
        }

        public void setSelection(ISelection selection) {
        }
    };
    private final ITaskListChangeListener TASKLIST_CHANGE_LISTENER = new ITaskListChangeListener(){

        public void containersChanged(Set<TaskContainerDelta> containers) {
            AbstractTask taskToRefresh = null;
            for (TaskContainerDelta taskContainerDelta : containers) {
                if (AbstractRepositoryTaskEditor.this.repositoryTask == null || !AbstractRepositoryTaskEditor.this.repositoryTask.equals((Object)taskContainerDelta.getContainer()) || !taskContainerDelta.getKind().equals((Object)TaskContainerDelta.Kind.CONTENT)) continue;
                taskToRefresh = (AbstractTask)taskContainerDelta.getContainer();
                break;
            }
            if (taskToRefresh != null) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (AbstractRepositoryTaskEditor.this.repositoryTask.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.INCOMING || AbstractRepositoryTaskEditor.this.repositoryTask.getSynchronizationState() == AbstractTask.RepositoryTaskSyncState.CONFLICT) {
                            AbstractRepositoryTaskEditor.this.parentEditor.setMessage("Task has incoming changes, synchronize to view", 2);
                            AbstractRepositoryTaskEditor.this.setSubmitEnabled(false);
                        } else {
                            AbstractRepositoryTaskEditor.this.refreshEditor();
                        }
                    }
                });
            }
        }
    };
    private java.util.List<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    private IRepositoryTaskSelection lastSelected = null;
    private final ISelectionListener selectionListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            if (part instanceof ContentOutline && selection instanceof StructuredSelection) {
                Object select = ((StructuredSelection)selection).getFirstElement();
                if (select instanceof RepositoryTaskOutlineNode) {
                    RepositoryTaskOutlineNode n = (RepositoryTaskOutlineNode)select;
                    if (AbstractRepositoryTaskEditor.this.lastSelected != null && ContentOutlineTools.getHandle(n).equals(ContentOutlineTools.getHandle(AbstractRepositoryTaskEditor.this.lastSelected))) {
                        return;
                    }
                    AbstractRepositoryTaskEditor.this.lastSelected = n;
                    boolean highlight = true;
                    if (n.getKey().equals("Comments")) {
                        highlight = false;
                    }
                    Object data = n.getData();
                    if (n.getKey().equals("New Comment")) {
                        AbstractRepositoryTaskEditor.this.selectNewComment();
                    } else if (n.getKey().equals("Description") && AbstractRepositoryTaskEditor.this.descriptionTextViewer.isEditable()) {
                        AbstractRepositoryTaskEditor.this.focusDescription();
                    } else if (data != null) {
                        AbstractRepositoryTaskEditor.this.select(data, highlight);
                    }
                }
                part.setFocus();
            }
        }
    };
    private AbstractTask repositoryTask;
    private Set<RepositoryTaskAttribute> changedAttributes;
    private Menu menu;
    private SynchronizeEditorAction synchronizeEditorAction;
    private ToggleTaskActivationAction activateAction;
    private Action historyAction;
    private Action openBrowserAction;
    private boolean firstFocus = true;
    private HashMap<Object, Control> controlBySelectableObject = new HashMap();
    private java.util.List<StyledText> commentStyleText = new ArrayList<StyledText>();
    private StyledText addCommentsTextBox = null;
    protected TextViewer descriptionTextViewer = null;
    private RepositoryTaskOutlinePage outlinePage = null;
    private Button[] radios;
    private Control[] radioOptions;
    private Button attachContextButton;
    private AbstractRepositoryConnector connector;
    private Cursor waitCursor;
    private boolean formBusy = false;
    private Composite headerInfoComposite;
    private Section attributesSection;

    protected boolean attributeChanged(RepositoryTaskAttribute attribute) {
        if (attribute == null) {
            return false;
        }
        this.changedAttributes.add(attribute);
        this.markDirty(true);
        this.validateInput();
        return true;
    }

    public void init(IEditorSite site, IEditorInput input) {
        if (!(input instanceof RepositoryTaskEditorInput)) {
            return;
        }
        this.initTaskEditor(site, (RepositoryTaskEditorInput)input);
        if (this.taskData != null) {
            this.editorInput.setToolTipText(this.taskData.getLabel());
            this.taskOutlineModel = RepositoryTaskOutlineNode.parseBugReport(this.taskData);
        }
        this.hasAttributeChanges = this.hasVisibleAttributeChanges();
        TasksUiPlugin.getTaskListManager().getTaskList().addChangeListener(this.TASKLIST_CHANGE_LISTENER);
    }

    protected void initTaskEditor(IEditorSite site, RepositoryTaskEditorInput input) {
        this.changedAttributes = new HashSet<RepositoryTaskAttribute>();
        this.editorInput = input;
        this.repositoryTask = this.editorInput.getRepositoryTask();
        this.repository = this.editorInput.getRepository();
        this.taskData = this.editorInput.getTaskData();
        this.connector = TasksUiPlugin.getRepositoryManager().getRepositoryConnector(this.repository.getConnectorKind());
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.isDirty = false;
    }

    public AbstractTask getRepositoryTask() {
        return this.repositoryTask;
    }

    protected abstract void validateInput();

    public AbstractRepositoryTaskEditor(FormEditor editor) {
        super(editor, "id", "label");
    }

    protected void createFormContent(IManagedForm managedForm) {
        IThemeManager themeManager = this.getSite().getWorkbenchWindow().getWorkbench().getThemeManager();
        this.colorIncoming = themeManager.getCurrentTheme().getColorRegistry().get("org.eclipse.mylyn.tasks.ui.colors.incoming.background");
        super.createFormContent(managedForm);
        this.form = managedForm.getForm();
        this.toolkit = managedForm.getToolkit();
        this.registerDropListener((Control)this.form);
        this.editorComposite = this.form.getBody();
        GridLayout editorLayout = new GridLayout();
        this.editorComposite.setLayout((Layout)editorLayout);
        this.editorComposite.setLayoutData((Object)new GridData(1808));
        if (this.taskData == null) {
            this.parentEditor.setMessage("Task data not available. Press synchronize button (right) to retrieve latest data.", 2);
        } else {
            this.createSections();
        }
        this.addHeaderControls();
        if (this.summaryTextViewer != null) {
            this.summaryTextViewer.getTextWidget().setFocus();
        }
    }

    private void addHeaderControls() {
        ControlContribution repositoryLabelControl = new ControlContribution("Title"){

            protected Control createControl(Composite parent) {
                Composite composite = AbstractRepositoryTaskEditor.this.toolkit.createComposite(parent);
                composite.setLayout((Layout)new RowLayout());
                composite.setBackground(null);
                String label = AbstractRepositoryTaskEditor.this.repository.getRepositoryLabel();
                if (label.indexOf("//") != -1) {
                    label = label.substring(AbstractRepositoryTaskEditor.this.repository.getUrl().indexOf("//") + 2);
                }
                Hyperlink link = new Hyperlink(composite, 0);
                link.setText(label);
                link.setFont(TITLE_FONT);
                link.setForeground(AbstractRepositoryTaskEditor.this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
                link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        TasksUiUtil.openEditRepositoryWizard((this).AbstractRepositoryTaskEditor.this.repository);
                    }
                });
                return composite;
            }
        };
        if (this.parentEditor.getTopForm() != null) {
            IToolBarManager toolBarManager = this.parentEditor.getTopForm().getToolBarManager();
            toolBarManager.removeAll();
            toolBarManager.update(true);
            toolBarManager.add((IContributionItem)repositoryLabelControl);
            this.fillToolBar(this.parentEditor.getTopForm().getToolBarManager());
            if (this.repositoryTask != null && this.taskData != null && !this.taskData.isNew()) {
                this.activateAction = new ToggleTaskActivationAction(this.repositoryTask, toolBarManager);
                toolBarManager.add((IContributionItem)new Separator("activation"));
                toolBarManager.add((IAction)this.activateAction);
            }
            toolBarManager.update(true);
        }
    }

    protected void fillToolBar(IToolBarManager toolBarManager) {
        if (this.taskData != null && !this.taskData.isNew()) {
            if (this.repositoryTask != null) {
                this.synchronizeEditorAction = new SynchronizeEditorAction();
                this.synchronizeEditorAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this));
                toolBarManager.add((IAction)this.synchronizeEditorAction);
                NewSubTaskAction newSubTaskAction = new NewSubTaskAction();
                newSubTaskAction.selectionChanged((IAction)newSubTaskAction, (ISelection)new StructuredSelection((Object)this.getRepositoryTask()));
                if (newSubTaskAction.isEnabled()) {
                    toolBarManager.add((IAction)newSubTaskAction);
                }
            }
            if (this.getHistoryUrl() != null) {
                this.historyAction = new Action(){

                    public void run() {
                        TasksUiUtil.openUrl(AbstractRepositoryTaskEditor.this.getHistoryUrl(), false);
                    }
                };
                this.historyAction.setImageDescriptor(TasksUiImages.TASK_REPOSITORY_HISTORY);
                this.historyAction.setToolTipText(LABEL_HISTORY);
                toolBarManager.add((IAction)this.historyAction);
            }
            if (this.connector != null) {
                String taskUrlToOpen;
                String taskUrl = this.connector.getTaskUrl(this.taskData.getRepositoryUrl(), this.taskData.getTaskKey());
                if (taskUrl == null && this.repositoryTask != null && this.repositoryTask.hasValidUrl()) {
                    taskUrl = this.repositoryTask.getUrl();
                }
                if ((taskUrlToOpen = taskUrl) != null) {
                    this.openBrowserAction = new Action(){

                        public void run() {
                            TasksUiUtil.openUrl(taskUrlToOpen, false);
                        }
                    };
                    this.openBrowserAction.setImageDescriptor(TasksUiImages.BROWSER_OPEN_TASK);
                    this.openBrowserAction.setToolTipText("Open with Web Browser");
                    toolBarManager.add((IAction)this.openBrowserAction);
                }
            }
        }
    }

    private void createSections() {
        this.createSummaryLayout(this.editorComposite);
        Composite attribComp = this.createAttributeSection();
        this.createAttributeLayout(attribComp);
        this.createCustomAttributeLayout(attribComp);
        this.createRelatedBugsSection(this.editorComposite);
        if (this.showAttachments) {
            this.createAttachmentLayout(this.editorComposite);
        }
        this.createDescriptionLayout(this.editorComposite);
        this.createCommentLayout(this.editorComposite);
        this.createNewCommentLayout(this.editorComposite);
        Composite bottomComposite = this.toolkit.createComposite(this.editorComposite);
        bottomComposite.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)bottomComposite);
        this.createActionsLayout(bottomComposite);
        this.createPeopleLayout(bottomComposite);
        bottomComposite.pack(true);
        this.form.reflow(true);
        this.getSite().getPage().addSelectionListener(this.selectionListener);
        this.getSite().setSelectionProvider(this.selectionProvider);
    }

    private void removeSections() {
        this.menu = this.editorComposite.getMenu();
        this.setMenu(this.editorComposite, null);
        Control[] controlArray = this.editorComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
    }

    protected void createSummaryLayout(Composite composite) {
        RepositoryTaskAttribute modifiedAttribute;
        RepositoryTaskAttribute creationAttribute;
        String idLabel;
        this.addSummaryText(composite);
        if (this.summaryTextViewer != null) {
            this.summaryTextViewer.prependVerifyKeyListener((VerifyKeyListener)new TabVerifyKeyListener());
        }
        this.headerInfoComposite = this.toolkit.createComposite(composite);
        GridLayout headerLayout = new GridLayout(11, false);
        headerLayout.verticalSpacing = 1;
        headerLayout.marginHeight = 1;
        headerLayout.marginHeight = 1;
        headerLayout.marginWidth = 1;
        headerLayout.horizontalSpacing = 6;
        this.headerInfoComposite.setLayout((Layout)headerLayout);
        RepositoryTaskAttribute statusAtribute = this.taskData.getAttribute("task.common.status");
        this.addNameValue(this.headerInfoComposite, statusAtribute);
        this.toolkit.paintBordersFor(this.headerInfoComposite);
        RepositoryTaskAttribute priorityAttribute = this.taskData.getAttribute("task.common.priority");
        this.addNameValue(this.headerInfoComposite, priorityAttribute);
        String string = idLabel = this.repositoryTask != null ? this.repositoryTask.getTaskKey() : this.taskData.getTaskKey();
        if (idLabel != null) {
            Composite nameValue = this.toolkit.createComposite(this.headerInfoComposite);
            nameValue.setLayout((Layout)new GridLayout(2, false));
            Label label = this.toolkit.createLabel(nameValue, "ID:");
            label.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            Text text = new Text(nameValue, 0x800008);
            this.toolkit.adapt((Control)text, true, true);
            text.setText(idLabel);
        }
        String openedDateString = "";
        String modifiedDateString = "";
        AbstractTaskDataHandler taskDataManager = this.connector.getTaskDataHandler();
        if (taskDataManager != null) {
            Date created = this.taskData.getAttributeFactory().getDateForAttributeType("task.common.date.created", this.taskData.getCreated());
            openedDateString = created != null ? DateUtil.getFormattedDate((Date)created, (String)HEADER_DATE_FORMAT) : "";
            Date modified = this.taskData.getAttributeFactory().getDateForAttributeType("task.common.date.modified", this.taskData.getLastModified());
            String string2 = modifiedDateString = modified != null ? DateUtil.getFormattedDate((Date)modified, (String)HEADER_DATE_FORMAT) : "";
        }
        if ((creationAttribute = this.taskData.getAttribute("task.common.date.created")) != null) {
            Composite nameValue = this.toolkit.createComposite(this.headerInfoComposite);
            nameValue.setLayout((Layout)new GridLayout(2, false));
            this.createLabel(nameValue, creationAttribute);
            Text text = new Text(nameValue, 0x800008);
            this.toolkit.adapt((Control)text, true, true);
            text.setText(openedDateString);
        }
        if ((modifiedAttribute = this.taskData.getAttribute("task.common.date.modified")) != null) {
            Composite nameValue = this.toolkit.createComposite(this.headerInfoComposite);
            nameValue.setLayout((Layout)new GridLayout(2, false));
            this.createLabel(nameValue, modifiedAttribute);
            Text text = new Text(nameValue, 0x800008);
            this.toolkit.adapt((Control)text, true, true);
            text.setText(modifiedDateString);
        }
    }

    private void addNameValue(Composite parent, RepositoryTaskAttribute attribute) {
        Composite nameValue = this.toolkit.createComposite(parent);
        nameValue.setLayout((Layout)new GridLayout(2, false));
        if (attribute != null) {
            this.createLabel(nameValue, attribute);
            this.createTextField(nameValue, attribute, 0x800008);
        }
    }

    protected Text createTextField(Composite composite, RepositoryTaskAttribute attribute, int style) {
        Text text;
        String value = attribute == null || attribute.getValue() == null ? "" : attribute.getValue();
        if ((8 & style) == 8) {
            text = new Text(composite, style);
            this.toolkit.adapt((Control)text, true, true);
            text.setData("FormWidgetFactory.drawBorder", (Object)Boolean.FALSE);
            text.setText(value);
        } else {
            text = this.toolkit.createText(composite, value, style);
        }
        if (attribute != null && !attribute.isReadOnly()) {
            text.setData((Object)attribute);
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    String newValue = text.getText();
                    RepositoryTaskAttribute attribute = (RepositoryTaskAttribute)text.getData();
                    attribute.setValue(newValue);
                    AbstractRepositoryTaskEditor.this.attributeChanged(attribute);
                }
            });
        }
        if (this.hasChanged(attribute)) {
            text.setBackground(this.colorIncoming);
        }
        return text;
    }

    protected Label createLabel(Composite composite, RepositoryTaskAttribute attribute) {
        Label label = this.hasOutgoingChange(attribute) ? this.toolkit.createLabel(composite, "*" + attribute.getName()) : this.toolkit.createLabel(composite, attribute.getName());
        label.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
        return label;
    }

    public String getSectionLabel(SECTION_NAME labelName) {
        return labelName.getPrettyName();
    }

    protected Composite createAttributeSection() {
        this.attributesSection = this.createSection(this.editorComposite, this.getSectionLabel(SECTION_NAME.ATTRIBTUES_SECTION));
        this.attributesSection.setExpanded(this.expandedStateAttributes || this.hasAttributeChanges);
        Composite toolbarComposite = this.toolkit.createComposite((Composite)this.attributesSection);
        toolbarComposite.setBackground(null);
        RowLayout rowLayout = new RowLayout();
        rowLayout.marginTop = 0;
        rowLayout.marginBottom = 0;
        toolbarComposite.setLayout((Layout)rowLayout);
        ResetRepositoryConfigurationAction repositoryConfigRefresh = new ResetRepositoryConfigurationAction(){

            public void performUpdate(TaskRepository repository, AbstractRepositoryConnector connector, IProgressMonitor monitor) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        AbstractRepositoryTaskEditor.this.setGlobalBusy(true);
                    }
                });
                try {
                    super.performUpdate(repository, connector, monitor);
                    if (connector != null) {
                        TasksUiPlugin.getSynchronizationManager().synchronize(connector, AbstractRepositoryTaskEditor.this.repositoryTask, true, (IJobChangeListener)new JobChangeAdapter(){

                            public void done(IJobChangeEvent event) {
                                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                    public void run() {
                                        AbstractRepositoryTaskEditor.this.refreshEditor();
                                    }
                                });
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            AbstractRepositoryTaskEditor.this.refreshEditor();
                        }
                    });
                }
            }
        };
        repositoryConfigRefresh.setImageDescriptor(TasksUiImages.REPOSITORY_SYNCHRONIZE);
        repositoryConfigRefresh.selectionChanged((IStructuredSelection)new StructuredSelection((Object)this.repository));
        repositoryConfigRefresh.setToolTipText("Refresh attributes");
        ToolBarManager barManager = new ToolBarManager(0x800000);
        barManager.add((IAction)repositoryConfigRefresh);
        repositoryConfigRefresh.setEnabled(this.supportsRefreshAttributes());
        barManager.add((IContributionItem)new Separator("additions"));
        barManager.createControl(toolbarComposite);
        this.attributesSection.setTextClient((Control)toolbarComposite);
        Composite attribComp = this.toolkit.createComposite((Composite)this.attributesSection);
        attribComp.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Control focus = event.display.getFocusControl();
                if (focus instanceof Text && !((Text)focus).getEditable()) {
                    AbstractRepositoryTaskEditor.this.form.setFocus();
                }
            }
        });
        this.attributesSection.setClient((Control)attribComp);
        GridLayout attributesLayout = new GridLayout();
        attributesLayout.numColumns = 4;
        attributesLayout.horizontalSpacing = 5;
        attributesLayout.verticalSpacing = 4;
        attribComp.setLayout((Layout)attributesLayout);
        GridData attributesData = new GridData(1808);
        attributesData.horizontalSpan = 1;
        attributesData.grabExcessVerticalSpace = false;
        attribComp.setLayoutData((Object)attributesData);
        return attribComp;
    }

    protected boolean supportsRefreshAttributes() {
        return true;
    }

    protected void createAttributeLayout(Composite attributesComposite) {
        int numColumns = ((GridLayout)attributesComposite.getLayout()).numColumns;
        int currentCol = 1;
        for (final RepositoryTaskAttribute attribute : this.taskData.getAttributes()) {
            Label label;
            if (attribute.isHidden()) continue;
            GridData data = new GridData(256);
            data.horizontalSpan = 1;
            if (attribute.hasOptions() && !attribute.isReadOnly()) {
                String value;
                label = this.createLabel(attributesComposite, attribute);
                GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
                final CCombo attributeCombo = new CCombo(attributesComposite, 0x800008);
                this.toolkit.adapt((Control)attributeCombo, true, true);
                attributeCombo.setFont(TEXT_FONT);
                attributeCombo.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
                if (this.hasChanged(attribute)) {
                    attributeCombo.setBackground(this.colorIncoming);
                }
                attributeCombo.setLayoutData((Object)data);
                java.util.List values = attribute.getOptions();
                if (values != null) {
                    for (String val : values) {
                        if (val == null) continue;
                        attributeCombo.add(val);
                    }
                }
                if ((value = attribute.getValue()) == null) {
                    value = "";
                }
                if (attributeCombo.indexOf(value) != -1) {
                    attributeCombo.select(attributeCombo.indexOf(value));
                }
                attributeCombo.clearSelection();
                attributeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        if (attributeCombo.getSelectionIndex() > -1) {
                            String sel = attributeCombo.getItem(attributeCombo.getSelectionIndex());
                            attribute.setValue(sel);
                            AbstractRepositoryTaskEditor.this.attributeChanged(attribute);
                            attributeCombo.clearSelection();
                        }
                    }
                });
                currentCol += 2;
            } else {
                Text text;
                label = this.createLabel(attributesComposite, attribute);
                GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
                Composite textFieldComposite = this.toolkit.createComposite(attributesComposite);
                GridLayout textLayout = new GridLayout();
                textLayout.marginWidth = 1;
                textLayout.marginHeight = 2;
                textFieldComposite.setLayout((Layout)textLayout);
                GridData textData = new GridData(256);
                textData.horizontalSpan = 1;
                textData.widthHint = 135;
                if (attribute.isReadOnly()) {
                    text = this.createTextField(textFieldComposite, attribute, 0x800008);
                    text.setLayoutData((Object)textData);
                } else {
                    text = this.createTextField(textFieldComposite, attribute, 0x800000);
                    text.setLayoutData((Object)textData);
                    this.toolkit.paintBordersFor(textFieldComposite);
                    text.setData((Object)attribute);
                    if (this.hasContentAssist(attribute)) {
                        ContentAssistCommandAdapter adapter = this.applyContentAssist(text, this.createContentProposalProvider(attribute));
                        ILabelProvider propsalLabelProvider = this.createProposalLabelProvider(attribute);
                        if (propsalLabelProvider != null) {
                            adapter.setLabelProvider(propsalLabelProvider);
                        }
                        adapter.setProposalAcceptanceStyle(2);
                    }
                }
                currentCol += 2;
            }
            if (currentCol <= numColumns) continue;
            currentCol -= numColumns;
        }
        if (currentCol > 1) {
            while (currentCol <= numColumns) {
                this.toolkit.createLabel(attributesComposite, "");
                ++currentCol;
            }
        }
        this.toolkit.paintBordersFor(attributesComposite);
    }

    protected void createRelatedBugsSection(Composite composite) {
    }

    protected SearchHitCollector getDuplicateSearchCollector(String name) {
        String duplicateDetectorName = name.equals("default") ? "Stack Trace" : name;
        Set<AbstractDuplicateDetector> allDetectors = this.getDuplicateSearchCollectorsList();
        for (AbstractDuplicateDetector detector : allDetectors) {
            if (!detector.getName().equals(duplicateDetectorName)) continue;
            return detector.getSearchHitCollector(this.repository, this.taskData);
        }
        return null;
    }

    protected Set<AbstractDuplicateDetector> getDuplicateSearchCollectorsList() {
        HashSet<AbstractDuplicateDetector> duplicateDetectors = new HashSet<AbstractDuplicateDetector>();
        for (AbstractDuplicateDetector abstractDuplicateDetector : TasksUiPlugin.getDefault().getDuplicateSearchCollectorsList()) {
            if (abstractDuplicateDetector.getKind() != null && !abstractDuplicateDetector.getKind().equals(this.getConnector().getConnectorKind())) continue;
            duplicateDetectors.add(abstractDuplicateDetector);
        }
        return duplicateDetectors;
    }

    public boolean searchForDuplicates() {
        String duplicateDetectorName = this.duplicateDetectorChooser.getItem(this.duplicateDetectorChooser.getSelectionIndex());
        SearchHitCollector collector = this.getDuplicateSearchCollector(duplicateDetectorName);
        if (collector != null) {
            NewSearchUI.runQueryInBackground((ISearchQuery)collector);
            return true;
        }
        return false;
    }

    protected ContentAssistCommandAdapter applyContentAssist(Text text, IContentProposalProvider proposalProvider) {
        ControlDecoration controlDecoration = new ControlDecoration((Control)text, 16512);
        controlDecoration.setMarginWidth(0);
        controlDecoration.setShowHover(true);
        controlDecoration.setShowOnlyOnFocus(true);
        FieldDecoration contentProposalImage = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_CONTENT_PROPOSAL");
        controlDecoration.setImage(contentProposalImage.getImage());
        TextContentAdapter textContentAdapter = new TextContentAdapter();
        ContentAssistCommandAdapter adapter = new ContentAssistCommandAdapter((Control)text, (IControlContentAdapter)textContentAdapter, proposalProvider, "org.eclipse.ui.edit.text.contentAssist.proposals", new char[0]);
        IBindingService bindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
        controlDecoration.setDescriptionText(NLS.bind((String)"Content Assist Available ({0})", (Object)bindingService.getBestActiveBindingFormattedFor(adapter.getCommandId())));
        return adapter;
    }

    protected IContentProposalProvider createContentProposalProvider(RepositoryTaskAttribute attribute) {
        return new PersonProposalProvider(this.repositoryTask, this.taskData);
    }

    protected IContentProposalProvider createContentProposalProvider(RepositoryOperation operation) {
        return new PersonProposalProvider(this.repositoryTask, this.taskData);
    }

    protected ILabelProvider createProposalLabelProvider(RepositoryTaskAttribute attribute) {
        return new PersonProposalLabelProvider();
    }

    protected ILabelProvider createProposalLabelProvider(RepositoryOperation operation) {
        return new PersonProposalLabelProvider();
    }

    protected boolean hasContentAssist(RepositoryTaskAttribute attribute) {
        return false;
    }

    protected boolean hasContentAssist(RepositoryOperation operation) {
        return false;
    }

    protected void addSummaryText(Composite attributesComposite) {
        Composite summaryComposite = this.toolkit.createComposite(attributesComposite);
        GridLayout summaryLayout = new GridLayout(2, false);
        summaryLayout.verticalSpacing = 0;
        summaryLayout.marginHeight = 2;
        summaryComposite.setLayout((Layout)summaryLayout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)summaryComposite);
        if (this.taskData != null) {
            RepositoryTaskAttribute attribute = this.taskData.getAttribute("task.common.summary");
            if (attribute == null) {
                this.taskData.setAttributeValue("task.common.summary", "");
                attribute = this.taskData.getAttribute("task.common.summary");
            }
            final RepositoryTaskAttribute summaryAttribute = attribute;
            this.summaryTextViewer = this.addTextEditor(this.repository, summaryComposite, attribute.getValue(), true, 0x800004);
            Composite hiddenComposite = new Composite(summaryComposite, 0);
            hiddenComposite.setLayout((Layout)new GridLayout());
            GridData hiddenLayout = new GridData();
            hiddenLayout.exclude = true;
            hiddenComposite.setLayoutData((Object)hiddenLayout);
            this.summaryText = new Text(hiddenComposite, 0);
            this.summaryText.setText(attribute.getValue());
            this.summaryText.addKeyListener(new KeyListener(){

                public void keyPressed(KeyEvent e) {
                    String oldValue;
                    String newValue;
                    if (AbstractRepositoryTaskEditor.this.summaryTextViewer != null && !AbstractRepositoryTaskEditor.this.summaryTextViewer.getTextWidget().isDisposed() && !(newValue = AbstractRepositoryTaskEditor.this.summaryText.getText()).equals(oldValue = AbstractRepositoryTaskEditor.this.summaryTextViewer.getTextWidget().getText())) {
                        AbstractRepositoryTaskEditor.this.summaryTextViewer.getTextWidget().setText(newValue);
                        summaryAttribute.setValue(newValue);
                        AbstractRepositoryTaskEditor.this.attributeChanged(summaryAttribute);
                    }
                }

                public void keyReleased(KeyEvent e) {
                }
            });
            this.summaryText.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    AbstractRepositoryTaskEditor.this.summaryTextViewer.getTextWidget().setFocus();
                }

                public void focusLost(FocusEvent e) {
                }
            });
            this.summaryTextViewer.setEditable(true);
            this.summaryTextViewer.getTextWidget().setIndent(2);
            GridDataFactory.fillDefaults().grab(true, false).applyTo(this.summaryTextViewer.getControl());
            if (this.hasChanged(attribute)) {
                this.summaryTextViewer.getTextWidget().setBackground(this.colorIncoming);
            }
            this.summaryTextViewer.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            this.summaryTextViewer.addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    String newValue = AbstractRepositoryTaskEditor.this.summaryTextViewer.getTextWidget().getText();
                    if (!newValue.equals(summaryAttribute.getValue())) {
                        summaryAttribute.setValue(newValue);
                        AbstractRepositoryTaskEditor.this.attributeChanged(summaryAttribute);
                    }
                    if (AbstractRepositoryTaskEditor.this.summaryText != null && !newValue.equals(AbstractRepositoryTaskEditor.this.summaryText.getText())) {
                        AbstractRepositoryTaskEditor.this.summaryText.setText(newValue);
                    }
                }
            });
        }
        this.toolkit.paintBordersFor(summaryComposite);
    }

    protected boolean supportsAttachmentDelete() {
        return false;
    }

    protected void deleteAttachment(RepositoryAttachment attachment) {
    }

    protected void createAttachmentLayout(Composite composite) {
        Section section = this.createSection(composite, this.getSectionLabel(SECTION_NAME.ATTACHMENTS_SECTION));
        section.setText(String.valueOf(section.getText()) + " (" + this.taskData.getAttachments().size() + ")");
        section.setExpanded(false);
        final Composite attachmentsComposite = this.toolkit.createComposite((Composite)section);
        attachmentsComposite.setLayout((Layout)new GridLayout(1, false));
        attachmentsComposite.setLayoutData((Object)new GridData(1808));
        section.setClient((Control)attachmentsComposite);
        if (this.taskData.getAttachments().size() > 0) {
            this.attachmentsTable = this.toolkit.createTable(attachmentsComposite, 67588);
            this.attachmentsTable.setLinesVisible(true);
            this.attachmentsTable.setHeaderVisible(true);
            this.attachmentsTable.setLayout((Layout)new GridLayout());
            GridData tableGridData = new GridData(4, 4, true, true);
            this.attachmentsTable.setLayoutData((Object)tableGridData);
            int i = 0;
            while (i < this.attachmentsColumns.length) {
                TableColumn column = new TableColumn(this.attachmentsTable, 16384, i);
                column.setText(this.attachmentsColumns[i]);
                column.setWidth(this.attachmentsColumnWidths[i]);
                ++i;
            }
            this.attachmentsTableViewer = new TableViewer(this.attachmentsTable);
            this.attachmentsTableViewer.setUseHashlookup(true);
            this.attachmentsTableViewer.setColumnProperties(this.attachmentsColumns);
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.attachmentsTableViewer, (int)2);
            AbstractTaskDataHandler offlineHandler = this.connector.getTaskDataHandler();
            if (offlineHandler != null) {
                this.attachmentsTableViewer.setSorter(new ViewerSorter(){

                    public int compare(Viewer viewer, Object e1, Object e2) {
                        RepositoryAttachment attachment1 = (RepositoryAttachment)e1;
                        RepositoryAttachment attachment2 = (RepositoryAttachment)e2;
                        Date created1 = AbstractRepositoryTaskEditor.this.taskData.getAttributeFactory().getDateForAttributeType("task.common.attachment.date", attachment1.getDateCreated());
                        Date created2 = AbstractRepositoryTaskEditor.this.taskData.getAttributeFactory().getDateForAttributeType("task.common.attachment.date", attachment2.getDateCreated());
                        if (created1 != null && created2 != null) {
                            return created1.compareTo(created2);
                        }
                        if (created1 == null && created2 != null) {
                            return -1;
                        }
                        if (created1 != null && created2 == null) {
                            return 1;
                        }
                        return 0;
                    }
                });
            }
            this.attachmentsTableViewer.setContentProvider((IContentProvider)new AttachmentsTableContentProvider(this.taskData.getAttachments()));
            this.attachmentsTableViewer.setLabelProvider((IBaseLabelProvider)new AttachmentTableLabelProvider(this, (ILabelProvider)new LabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
            this.attachmentsTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (!event.getSelection().isEmpty()) {
                        StructuredSelection selection = (StructuredSelection)event.getSelection();
                        RepositoryAttachment attachment = (RepositoryAttachment)selection.getFirstElement();
                        TasksUiUtil.openUrl(attachment.getUrl(), false);
                    }
                }
            });
            this.attachmentsTableViewer.setInput((Object)this.taskData);
            final Action openWithBrowserAction = new Action(LABEL_BROWSER){

                public void run() {
                    RepositoryAttachment attachment = (RepositoryAttachment)((StructuredSelection)AbstractRepositoryTaskEditor.this.attachmentsTableViewer.getSelection()).getFirstElement();
                    if (attachment != null) {
                        TasksUiUtil.openUrl(attachment.getUrl(), false);
                    }
                }
            };
            final Action openWithDefaultAction = new Action(LABEL_DEFAULT_EDITOR){

                public void run() {
                    RepositoryAttachment attachment = (RepositoryAttachment)((StructuredSelection)AbstractRepositoryTaskEditor.this.attachmentsTableViewer.getSelection()).getFirstElement();
                    if (attachment == null) {
                        return;
                    }
                    if (attachment.getContentType().endsWith(AbstractRepositoryTaskEditor.CTYPE_HTML)) {
                        TasksUiUtil.openUrl(attachment.getUrl(), false);
                        return;
                    }
                    RepositoryAttachmentEditorInput input = new RepositoryAttachmentEditorInput(AbstractRepositoryTaskEditor.this.repository, attachment);
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (page == null) {
                        return;
                    }
                    IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(input.getName());
                    try {
                        page.openEditor((IEditorInput)input, desc.getId());
                    }
                    catch (PartInitException e) {
                        StatusHandler.fail((Throwable)e, (String)("Unable to open editor for: " + attachment.getDescription()), (boolean)false);
                    }
                }
            };
            final Action openWithTextEditorAction = new Action(LABEL_TEXT_EDITOR){

                public void run() {
                    RepositoryAttachment attachment = (RepositoryAttachment)((StructuredSelection)AbstractRepositoryTaskEditor.this.attachmentsTableViewer.getSelection()).getFirstElement();
                    RepositoryAttachmentEditorInput input = new RepositoryAttachmentEditorInput(AbstractRepositoryTaskEditor.this.repository, attachment);
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    if (page == null) {
                        return;
                    }
                    try {
                        page.openEditor((IEditorInput)input, "org.eclipse.ui.DefaultTextEditor");
                    }
                    catch (PartInitException e) {
                        StatusHandler.fail((Throwable)e, (String)("Unable to open editor for: " + attachment.getDescription()), (boolean)false);
                    }
                }
            };
            final Action saveAction = new Action(LABEL_SAVE){

                public void run() {
                    RepositoryAttachment attachment = (RepositoryAttachment)((StructuredSelection)AbstractRepositoryTaskEditor.this.attachmentsTableViewer.getSelection()).getFirstElement();
                    FileDialog fileChooser = new FileDialog(AbstractRepositoryTaskEditor.this.attachmentsTable.getShell(), 8192);
                    String fname = attachment.getAttributeValue("filename");
                    if (fname.equals("")) {
                        String ctype = attachment.getContentType();
                        fname = ctype.endsWith(AbstractRepositoryTaskEditor.CTYPE_HTML) ? "attachment.html" : (ctype.startsWith(AbstractRepositoryTaskEditor.CTYPE_TEXT) ? "attachment.txt" : (ctype.endsWith(AbstractRepositoryTaskEditor.CTYPE_OCTET_STREAM) ? AbstractRepositoryTaskEditor.ATTACHMENT_DEFAULT_NAME : (ctype.endsWith(AbstractRepositoryTaskEditor.CTYPE_ZIP) ? "attachment.zip" : "attachment." + ctype.substring(ctype.indexOf("/") + 1))));
                    }
                    fileChooser.setFileName(fname);
                    String filePath = fileChooser.open();
                    if (filePath == null) {
                        return;
                    }
                    DownloadAttachmentJob job = new DownloadAttachmentJob(attachment, new File(filePath));
                    job.setUser(true);
                    job.schedule();
                }
            };
            final Action copyURLToClipAction = new Action(LABEL_COPY_URL_TO_CLIPBOARD){

                public void run() {
                    RepositoryAttachment attachment = (RepositoryAttachment)((StructuredSelection)AbstractRepositoryTaskEditor.this.attachmentsTableViewer.getSelection()).getFirstElement();
                    Clipboard clip = new Clipboard(PlatformUI.getWorkbench().getDisplay());
                    clip.setContents(new Object[]{attachment.getUrl()}, new Transfer[]{TextTransfer.getInstance()});
                    clip.dispose();
                }
            };
            final Action copyToClipAction = new Action(LABEL_COPY_TO_CLIPBOARD){

                public void run() {
                    RepositoryAttachment attachment = (RepositoryAttachment)((StructuredSelection)AbstractRepositoryTaskEditor.this.attachmentsTableViewer.getSelection()).getFirstElement();
                    CopyAttachmentToClipboardJob job = new CopyAttachmentToClipboardJob(attachment);
                    job.setUser(true);
                    job.schedule();
                }
            };
            final MenuManager popupMenu = new MenuManager();
            Menu menu = popupMenu.createContextMenu((Control)this.attachmentsTable);
            this.attachmentsTable.setMenu(menu);
            final MenuManager openMenu = new MenuManager("Open With");
            popupMenu.addMenuListener(new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    popupMenu.removeAll();
                    ISelection selection = AbstractRepositoryTaskEditor.this.attachmentsTableViewer.getSelection();
                    if (selection.isEmpty()) {
                        return;
                    }
                    RepositoryAttachment att = (RepositoryAttachment)((StructuredSelection)selection).getFirstElement();
                    popupMenu.add((IContributionItem)openMenu);
                    openMenu.removeAll();
                    RepositoryAttachmentEditorInput input = new RepositoryAttachmentEditorInput(AbstractRepositoryTaskEditor.this.repository, att);
                    IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(input.getName());
                    if (desc != null) {
                        openMenu.add((IAction)openWithDefaultAction);
                    }
                    openMenu.add((IAction)openWithBrowserAction);
                    openMenu.add((IAction)openWithTextEditorAction);
                    popupMenu.add((IContributionItem)new Separator());
                    popupMenu.add((IAction)saveAction);
                    popupMenu.add((IAction)copyURLToClipAction);
                    if (att.getContentType().startsWith(AbstractRepositoryTaskEditor.CTYPE_TEXT) || att.getContentType().endsWith("xml")) {
                        popupMenu.add((IAction)copyToClipAction);
                    }
                    popupMenu.add((IContributionItem)new Separator("actions"));
                    ObjectActionContributorManager.getManager().contributeObjectActions((IWorkbenchPart)AbstractRepositoryTaskEditor.this, (IMenuManager)popupMenu, (ISelectionProvider)AbstractRepositoryTaskEditor.this.attachmentsTableViewer);
                }
            });
        } else {
            Label label = this.toolkit.createLabel(attachmentsComposite, "No attachments");
            this.registerDropListener((Control)label);
        }
        Composite attachmentControlsComposite = this.toolkit.createComposite(attachmentsComposite);
        attachmentControlsComposite.setLayout((Layout)new GridLayout(2, false));
        attachmentControlsComposite.setLayoutData((Object)new GridData(1));
        Button attachFileButton = this.toolkit.createButton(attachmentControlsComposite, "Attach...", 8);
        attachFileButton.setImage(WorkbenchImages.getImage((String)"IMG_OBJ_FILE"));
        Button attachScreenshotButton = this.toolkit.createButton(attachmentControlsComposite, "Attach Screenshot...", 8);
        attachScreenshotButton.setImage(TasksUiImages.getImage(TasksUiImages.IMAGE_CAPTURE));
        final AbstractTask task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(this.repository.getUrl(), this.taskData.getId());
        if (task == null) {
            attachFileButton.setEnabled(false);
            attachScreenshotButton.setEnabled(false);
        }
        attachFileButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AttachAction attachFileAction = new AttachAction();
                attachFileAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)task));
                attachFileAction.setEditor(AbstractRepositoryTaskEditor.this.parentEditor);
                attachFileAction.run();
            }
        });
        attachScreenshotButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                AttachScreenshotAction attachScreenshotAction = new AttachScreenshotAction();
                attachScreenshotAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)task));
                attachScreenshotAction.setEditor(AbstractRepositoryTaskEditor.this.parentEditor);
                attachScreenshotAction.run();
            }
        });
        Button deleteAttachmentButton = null;
        if (this.supportsAttachmentDelete()) {
            deleteAttachmentButton = this.toolkit.createButton(attachmentControlsComposite, "Delete Attachment...", 8);
            deleteAttachmentButton.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    AbstractTask task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(AbstractRepositoryTaskEditor.this.repository.getUrl(), AbstractRepositoryTaskEditor.this.taskData.getId());
                    if (task == null) {
                        return;
                    }
                    if (AbstractRepositoryTaskEditor.this.isDirty || task.getSynchronizationState().equals((Object)AbstractTask.RepositoryTaskSyncState.OUTGOING)) {
                        MessageDialog.openInformation((Shell)attachmentsComposite.getShell(), (String)"Task not synchronized or dirty editor", (String)"Commit edits or synchronize task before deleting attachments.");
                        return;
                    }
                    if (AbstractRepositoryTaskEditor.this.attachmentsTableViewer != null && AbstractRepositoryTaskEditor.this.attachmentsTableViewer.getSelection() != null && ((StructuredSelection)AbstractRepositoryTaskEditor.this.attachmentsTableViewer.getSelection()).getFirstElement() != null) {
                        RepositoryAttachment attachment = (RepositoryAttachment)((StructuredSelection)AbstractRepositoryTaskEditor.this.attachmentsTableViewer.getSelection()).getFirstElement();
                        AbstractRepositoryTaskEditor.this.deleteAttachment(attachment);
                        AbstractRepositoryTaskEditor.this.submitToRepository();
                    }
                }
            });
        }
        this.registerDropListener((Control)section);
        this.registerDropListener((Control)attachmentsComposite);
        this.registerDropListener((Control)attachFileButton);
        if (this.supportsAttachmentDelete()) {
            this.registerDropListener((Control)deleteAttachmentButton);
        }
    }

    private void registerDropListener(Control control) {
        DropTarget target = new DropTarget(control, 17);
        TextTransfer textTransfer = TextTransfer.getInstance();
        FileTransfer fileTransfer = FileTransfer.getInstance();
        Transfer[] types = new Transfer[]{textTransfer, fileTransfer};
        target.setTransfer(types);
        target.addDropListener((DropTargetListener)new RepositoryTaskEditorDropListener(this, fileTransfer, textTransfer, control));
    }

    protected void createDescriptionLayout(Composite composite) {
        Section descriptionSection = this.createSection(composite, this.getSectionLabel(SECTION_NAME.DESCRIPTION_SECTION));
        final Composite sectionComposite = this.toolkit.createComposite((Composite)descriptionSection);
        descriptionSection.setClient((Control)sectionComposite);
        GridLayout addCommentsLayout = new GridLayout();
        addCommentsLayout.numColumns = 1;
        sectionComposite.setLayout((Layout)addCommentsLayout);
        RepositoryTaskAttribute attribute = this.taskData.getDescriptionAttribute();
        if (attribute != null && !attribute.isReadOnly()) {
            if (this.getRenderingEngine() != null) {
                Composite descriptionComposite = this.toolkit.createComposite(sectionComposite);
                descriptionComposite.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
                GridData descriptionGridData = new GridData(1808);
                descriptionGridData.widthHint = 553;
                descriptionGridData.minimumHeight = 140;
                descriptionGridData.grabExcessHorizontalSpace = true;
                descriptionComposite.setLayoutData((Object)descriptionGridData);
                StackLayout descriptionLayout = new StackLayout();
                descriptionComposite.setLayout((Layout)descriptionLayout);
                this.descriptionTextViewer = this.addTextEditor(this.repository, descriptionComposite, this.taskData.getDescription(), true, 8389186);
                descriptionLayout.topControl = this.descriptionTextViewer.getControl();
                descriptionComposite.layout();
                Composite buttonComposite = this.toolkit.createComposite(sectionComposite);
                buttonComposite.setLayout((Layout)new GridLayout());
                this.createPreviewButton(buttonComposite, this.descriptionTextViewer, descriptionComposite, descriptionLayout);
            } else {
                this.descriptionTextViewer = this.addTextEditor(this.repository, sectionComposite, this.taskData.getDescription(), true, 8389186);
                final GridData gd = new GridData(768);
                gd.widthHint = 553;
                gd.minimumHeight = 140;
                gd.grabExcessHorizontalSpace = true;
                this.descriptionTextViewer.getControl().setLayoutData((Object)gd);
                this.descriptionTextViewer.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
                sectionComposite.addControlListener((ControlListener)new ControlAdapter(){
                    private boolean first;

                    public void controlResized(ControlEvent e) {
                        if (!this.first) {
                            this.first = true;
                            int width = sectionComposite.getSize().x;
                            Point size = AbstractRepositoryTaskEditor.this.descriptionTextViewer.getTextWidget().computeSize(width, -1, true);
                            gd.widthHint = width;
                            gd.heightHint = Math.min(Math.max(140, size.y), 560);
                            sectionComposite.layout();
                        }
                    }
                });
            }
            this.descriptionTextViewer.setEditable(true);
            this.descriptionTextViewer.addTextListener(new ITextListener(){

                public void textChanged(TextEvent event) {
                    String newValue = AbstractRepositoryTaskEditor.this.descriptionTextViewer.getTextWidget().getText();
                    RepositoryTaskAttribute attribute = AbstractRepositoryTaskEditor.this.taskData.getAttribute("task.common.description");
                    if (attribute != null && !newValue.equals(attribute.getValue())) {
                        attribute.setValue(newValue);
                        AbstractRepositoryTaskEditor.this.attributeChanged(attribute);
                        AbstractRepositoryTaskEditor.this.taskData.setDescription(newValue);
                    }
                }
            });
            StyledText styledText = this.descriptionTextViewer.getTextWidget();
            this.controlBySelectableObject.put(this.taskData.getDescription(), (Control)styledText);
        } else {
            String text = this.taskData.getDescription();
            this.descriptionTextViewer = this.addTextViewer(this.repository, sectionComposite, text, 66);
            StyledText styledText = this.descriptionTextViewer.getTextWidget();
            GridDataFactory.fillDefaults().hint(553, -1).applyTo(this.descriptionTextViewer.getControl());
            this.controlBySelectableObject.put(text, (Control)styledText);
        }
        if (this.hasChanged(this.taskData.getAttribute("task.common.description"))) {
            this.descriptionTextViewer.getTextWidget().setBackground(this.colorIncoming);
        }
        this.descriptionTextViewer.getTextWidget().addListener(15, (Listener)new DescriptionListener());
        Composite replyComp = this.toolkit.createComposite((Composite)descriptionSection);
        replyComp.setLayout((Layout)new RowLayout());
        replyComp.setBackground(null);
        this.createReplyHyperlink(0, replyComp, this.taskData.getDescription());
        descriptionSection.setTextClient((Control)replyComp);
        this.addDuplicateDetection(sectionComposite);
        this.toolkit.paintBordersFor(sectionComposite);
    }

    protected ImageHyperlink createReplyHyperlink(final int commentNum, Composite composite, final String commentBody) {
        ImageHyperlink replyLink = new ImageHyperlink(composite, 0);
        this.toolkit.adapt((Control)replyLink, true, true);
        replyLink.setImage(TasksUiImages.getImage(TasksUiImages.REPLY));
        replyLink.setToolTipText(LABEL_REPLY);
        replyLink.setBackground(null);
        replyLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                String oldText = AbstractRepositoryTaskEditor.this.newCommentTextViewer.getDocument().get();
                StringBuilder strBuilder = new StringBuilder();
                strBuilder.append(oldText);
                if (strBuilder.length() != 0) {
                    strBuilder.append("\n");
                }
                strBuilder.append(" (In reply to comment #" + commentNum + ")\n");
                CommentQuoter quoter = new CommentQuoter();
                strBuilder.append(quoter.quote(commentBody));
                AbstractRepositoryTaskEditor.this.newCommentTextViewer.getDocument().set(strBuilder.toString());
                RepositoryTaskAttribute attribute = AbstractRepositoryTaskEditor.this.taskData.getAttribute("task.common.comment.new");
                if (attribute != null) {
                    attribute.setValue(strBuilder.toString());
                    AbstractRepositoryTaskEditor.this.attributeChanged(attribute);
                }
                AbstractRepositoryTaskEditor.this.selectNewComment();
                AbstractRepositoryTaskEditor.this.newCommentTextViewer.getTextWidget().setCaretOffset(strBuilder.length());
            }
        });
        return replyLink;
    }

    protected void addDuplicateDetection(Composite composite) {
        ArrayList<AbstractDuplicateDetector> allCollectors = new ArrayList<AbstractDuplicateDetector>();
        if (this.getDuplicateSearchCollectorsList() != null) {
            allCollectors.addAll(this.getDuplicateSearchCollectorsList());
        }
        if (!allCollectors.isEmpty()) {
            Section duplicatesSection = this.toolkit.createSection(composite, 514);
            duplicatesSection.setText(LABEL_SELECT_DETECTOR);
            duplicatesSection.setLayout((Layout)new GridLayout());
            GridDataFactory.fillDefaults().indent(-1, 15).applyTo((Control)duplicatesSection);
            Composite relatedBugsComposite = this.toolkit.createComposite((Composite)duplicatesSection);
            relatedBugsComposite.setLayout((Layout)new GridLayout(4, false));
            relatedBugsComposite.setLayoutData((Object)new GridData(256));
            duplicatesSection.setClient((Control)relatedBugsComposite);
            this.duplicateDetectorLabel = new Label(relatedBugsComposite, 16384);
            this.duplicateDetectorLabel.setText("Detector:");
            this.duplicateDetectorChooser = new CCombo(relatedBugsComposite, 0x800008);
            this.toolkit.adapt((Control)this.duplicateDetectorChooser, true, true);
            this.duplicateDetectorChooser.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            this.duplicateDetectorChooser.setFont(TEXT_FONT);
            this.duplicateDetectorChooser.setLayoutData((Object)GridDataFactory.swtDefaults().hint(150, -1).create());
            Collections.sort(allCollectors, new Comparator<AbstractDuplicateDetector>(){

                @Override
                public int compare(AbstractDuplicateDetector c1, AbstractDuplicateDetector c2) {
                    return c1.getName().compareToIgnoreCase(c2.getName());
                }
            });
            for (AbstractDuplicateDetector detector : allCollectors) {
                this.duplicateDetectorChooser.add(detector.getName());
            }
            this.duplicateDetectorChooser.select(0);
            this.duplicateDetectorChooser.setEnabled(true);
            this.duplicateDetectorChooser.setData(allCollectors);
            if (allCollectors.size() > 0) {
                this.searchForDuplicates = this.toolkit.createButton(relatedBugsComposite, LABEL_SEARCH_DUPS, 0);
                GridData searchDuplicatesButtonData = new GridData(32);
                this.searchForDuplicates.setLayoutData((Object)searchDuplicatesButtonData);
                this.searchForDuplicates.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        AbstractRepositoryTaskEditor.this.searchForDuplicates();
                    }
                });
            }
            this.toolkit.paintBordersFor(relatedBugsComposite);
        }
    }

    protected void createCustomAttributeLayout(Composite composite) {
    }

    protected void createPeopleLayout(Composite composite) {
        Section peopleSection = this.createSection(composite, this.getSectionLabel(SECTION_NAME.PEOPLE_SECTION));
        GridDataFactory.fillDefaults().align(4, 128).grab(true, true).applyTo((Control)peopleSection);
        Composite peopleComposite = this.toolkit.createComposite((Composite)peopleSection);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 5;
        peopleComposite.setLayout((Layout)layout);
        this.addAssignedTo(peopleComposite);
        boolean haveRealName = false;
        RepositoryTaskAttribute reporterAttribute = this.taskData.getAttribute("task.common.user.reporter.name");
        if (reporterAttribute == null) {
            reporterAttribute = this.taskData.getAttribute("task.common.user.reporter");
        } else {
            haveRealName = true;
        }
        if (reporterAttribute != null) {
            Label label = this.createLabel(peopleComposite, reporterAttribute);
            GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
            Text textField = this.createTextField(peopleComposite, reporterAttribute, 0x800008);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)textField);
            if (haveRealName) {
                textField.setText(String.valueOf(textField.getText()) + " <" + this.taskData.getAttributeValue("task.common.user.reporter") + ">");
            }
        }
        this.addSelfToCC(peopleComposite);
        this.addCCList(peopleComposite);
        this.getManagedForm().getToolkit().paintBordersFor(peopleComposite);
        peopleSection.setClient((Control)peopleComposite);
        peopleSection.setEnabled(true);
    }

    protected void addCCList(Composite attributesComposite) {
        RepositoryTaskAttribute CCattribute;
        RepositoryTaskAttribute addCCattribute = this.taskData.getAttribute("task.common.newcc");
        if (addCCattribute == null) {
            this.taskData.setAttributeValue("task.common.newcc", "");
            addCCattribute = this.taskData.getAttribute("task.common.newcc");
        }
        if (addCCattribute != null) {
            Label label = this.createLabel(attributesComposite, addCCattribute);
            GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
            Text text = this.createTextField(attributesComposite, addCCattribute, 0x800000);
            GridDataFactory.fillDefaults().hint(150, -1).applyTo((Control)text);
            if (this.hasContentAssist(addCCattribute)) {
                ContentAssistCommandAdapter adapter = this.applyContentAssist(text, this.createContentProposalProvider(addCCattribute));
                ILabelProvider propsalLabelProvider = this.createProposalLabelProvider(addCCattribute);
                if (propsalLabelProvider != null) {
                    adapter.setLabelProvider(propsalLabelProvider);
                }
                adapter.setProposalAcceptanceStyle(2);
            }
        }
        if ((CCattribute = this.taskData.getAttribute("task.common.user.cc")) != null) {
            java.util.List removedCCs;
            java.util.List ccs;
            Label label = this.createLabel(attributesComposite, CCattribute);
            GridDataFactory.fillDefaults().align(131072, 128).applyTo((Control)label);
            this.ccList = new List(attributesComposite, 514);
            this.ccList.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            this.ccList.setFont(TEXT_FONT);
            GridData ccListData = new GridData(256);
            ccListData.horizontalSpan = 1;
            ccListData.widthHint = 150;
            ccListData.heightHint = 95;
            this.ccList.setLayoutData((Object)ccListData);
            if (this.hasChanged(this.taskData.getAttribute("task.common.user.cc"))) {
                this.ccList.setBackground(this.colorIncoming);
            }
            if ((ccs = this.taskData.getCc()) != null) {
                for (String cc : ccs) {
                    this.ccList.add(cc);
                }
            }
            if ((removedCCs = this.taskData.getAttributeValues("task.common.removecc")) != null) {
                for (String item : removedCCs) {
                    int i = this.ccList.indexOf(item);
                    if (i == -1) continue;
                    this.ccList.select(i);
                }
            }
            this.ccList.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    String[] stringArray = AbstractRepositoryTaskEditor.this.ccList.getItems();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String cc = stringArray[n2];
                        int index = AbstractRepositoryTaskEditor.this.ccList.indexOf(cc);
                        if (AbstractRepositoryTaskEditor.this.ccList.isSelected(index)) {
                            java.util.List remove = AbstractRepositoryTaskEditor.this.taskData.getAttributeValues("task.common.removecc");
                            if (!remove.contains(cc)) {
                                AbstractRepositoryTaskEditor.this.taskData.addAttributeValue("task.common.removecc", cc);
                            }
                        } else {
                            AbstractRepositoryTaskEditor.this.taskData.removeAttributeValue("task.common.removecc", cc);
                        }
                        ++n2;
                    }
                    AbstractRepositoryTaskEditor.this.attributeChanged(AbstractRepositoryTaskEditor.this.taskData.getAttribute("task.common.removecc"));
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.toolkit.createLabel(attributesComposite, "");
            label = this.toolkit.createLabel(attributesComposite, "(Select to remove)");
            GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)label);
        }
    }

    protected boolean supportsCommentDelete() {
        return false;
    }

    protected void deleteComment(TaskComment comment) {
    }

    protected void createCommentLayout(Composite composite) {
        this.commentsSection = this.createSection(composite, this.getSectionLabel(SECTION_NAME.COMMENTS_SECTION));
        this.commentsSection.setText(String.valueOf(this.commentsSection.getText()) + " (" + this.taskData.getComments().size() + ")");
        if (this.taskData.getComments().size() > 0) {
            this.commentsSection.setEnabled(true);
            Composite commentsSectionClient = this.toolkit.createComposite((Composite)this.commentsSection);
            RowLayout rowLayout = new RowLayout();
            rowLayout.pack = true;
            rowLayout.marginLeft = 0;
            rowLayout.marginBottom = 0;
            rowLayout.marginTop = 0;
            commentsSectionClient.setLayout((Layout)rowLayout);
            commentsSectionClient.setBackground(null);
            ImageHyperlink collapseAllHyperlink = new ImageHyperlink(commentsSectionClient, 0);
            collapseAllHyperlink.setToolTipText("Collapse All Comments");
            this.toolkit.adapt((Control)collapseAllHyperlink, true, true);
            collapseAllHyperlink.setBackground(null);
            collapseAllHyperlink.setImage(TasksUiImages.getImage(TasksUiImages.COLLAPSE_ALL));
            collapseAllHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    AbstractRepositoryTaskEditor.this.hideAllComments();
                }
            });
            ImageHyperlink expandAllHyperlink = new ImageHyperlink(commentsSectionClient, 0);
            expandAllHyperlink.setToolTipText("Expand All Comments");
            this.toolkit.adapt((Control)expandAllHyperlink, true, true);
            expandAllHyperlink.setBackground(null);
            expandAllHyperlink.setImage(TasksUiImages.getImage(TasksUiImages.EXPAND_ALL));
            expandAllHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    AbstractRepositoryTaskEditor.this.revealAllComments();
                }
            });
            this.commentsSection.setTextClient((Control)commentsSectionClient);
        } else {
            this.commentsSection.setEnabled(false);
        }
        Composite addCommentsComposite = this.toolkit.createComposite((Composite)this.commentsSection);
        this.commentsSection.setClient((Control)addCommentsComposite);
        GridLayout addCommentsLayout = new GridLayout();
        addCommentsLayout.numColumns = 1;
        addCommentsComposite.setLayout((Layout)addCommentsLayout);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)addCommentsComposite);
        boolean foundNew = false;
        for (final TaskComment taskComment : this.taskData.getComments()) {
            final ExpandableComposite expandableComposite = this.toolkit.createExpandableComposite(addCommentsComposite, 8196);
            if (this.repositoryTask != null && this.repositoryTask.getLastReadTimeStamp() == null || this.editorInput.getOldTaskData() == null) {
                expandableComposite.setExpanded(true);
                foundNew = true;
            } else if (this.isNewComment(taskComment)) {
                expandableComposite.setBackground(this.colorIncoming);
                expandableComposite.setExpanded(true);
                foundNew = true;
            }
            expandableComposite.setTitleBarForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            expandableComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    AbstractRepositoryTaskEditor.this.resetLayout();
                }
            });
            Composite toolbarComp = this.toolkit.createComposite((Composite)expandableComposite);
            RowLayout rowLayout = new RowLayout();
            rowLayout.pack = true;
            rowLayout.marginLeft = 0;
            rowLayout.marginBottom = 0;
            rowLayout.marginTop = 0;
            toolbarComp.setLayout((Layout)rowLayout);
            toolbarComp.setBackground(null);
            ImageHyperlink formHyperlink = this.toolkit.createImageHyperlink(toolbarComp, 0);
            formHyperlink.setBackground(null);
            formHyperlink.setFont(expandableComposite.getFont());
            formHyperlink.setForeground(this.toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
            if (taskComment.getAuthor() != null && taskComment.getAuthor().equalsIgnoreCase(this.repository.getUserName())) {
                formHyperlink.setImage(TasksUiImages.getImage(TasksUiImages.PERSON_ME_NARROW));
            } else {
                formHyperlink.setImage(TasksUiImages.getImage(TasksUiImages.PERSON_NARROW));
            }
            String authorName = taskComment.getAuthorName();
            String tooltipText = taskComment.getAuthor();
            if (authorName.length() == 0) {
                authorName = taskComment.getAuthor();
                tooltipText = null;
            }
            formHyperlink.setText(String.valueOf(taskComment.getNumber()) + ": " + authorName + ", " + this.formatDate(taskComment.getCreated()));
            formHyperlink.setToolTipText(tooltipText);
            formHyperlink.setEnabled(true);
            formHyperlink.setUnderlined(false);
            final Composite toolbarButtonComp = this.toolkit.createComposite(toolbarComp);
            RowLayout buttonCompLayout = new RowLayout();
            buttonCompLayout.marginBottom = 0;
            buttonCompLayout.marginTop = 0;
            toolbarButtonComp.setLayout((Layout)buttonCompLayout);
            toolbarButtonComp.setBackground(null);
            if (this.supportsCommentDelete()) {
                ImageHyperlink deleteComment = new ImageHyperlink(toolbarButtonComp, 0);
                this.toolkit.adapt((Control)deleteComment, true, true);
                deleteComment.setImage(TasksUiImages.getImage(TasksUiImages.REMOVE));
                deleteComment.setToolTipText("Remove");
                deleteComment.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        AbstractRepositoryTaskEditor.this.deleteComment(taskComment);
                        AbstractRepositoryTaskEditor.this.submitToRepository();
                    }
                });
            }
            final ImageHyperlink replyLink = this.createReplyHyperlink(taskComment.getNumber(), toolbarButtonComp, taskComment.getText());
            expandableComposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

                public void expansionStateChanged(ExpansionEvent e) {
                    toolbarButtonComp.setVisible(expandableComposite.isExpanded());
                }
            });
            toolbarButtonComp.setVisible(expandableComposite.isExpanded());
            formHyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    expandableComposite.setExpanded(!expandableComposite.isExpanded());
                    toolbarButtonComp.setVisible(expandableComposite.isExpanded());
                    AbstractRepositoryTaskEditor.this.resetLayout();
                }

                public void linkEntered(HyperlinkEvent e) {
                    replyLink.setUnderlined(true);
                    super.linkEntered(e);
                }

                public void linkExited(HyperlinkEvent e) {
                    replyLink.setUnderlined(false);
                    super.linkExited(e);
                }
            });
            expandableComposite.setTextClient((Control)toolbarComp);
            expandableComposite.setData((Object)toolbarButtonComp);
            expandableComposite.setLayout((Layout)new GridLayout());
            expandableComposite.setLayoutData((Object)new GridData(768));
            Composite ecComposite = this.toolkit.createComposite((Composite)expandableComposite);
            GridLayout ecLayout = new GridLayout();
            ecLayout.marginHeight = 0;
            ecLayout.marginBottom = 3;
            ecLayout.marginLeft = 15;
            ecComposite.setLayout((Layout)ecLayout);
            ecComposite.setLayoutData((Object)new GridData(768));
            expandableComposite.setClient((Control)ecComposite);
            TextViewer viewer = this.addTextViewer(this.repository, ecComposite, taskComment.getText().trim(), 66);
            viewer.getTextWidget().addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    AbstractRepositoryTaskEditor.this.selectedComment = taskComment;
                }

                public void focusLost(FocusEvent e) {
                    AbstractRepositoryTaskEditor.this.selectedComment = null;
                }
            });
            StyledText styledText = viewer.getTextWidget();
            GridDataFactory.fillDefaults().hint(553, -1).applyTo((Control)styledText);
            this.commentStyleText.add(styledText);
            this.controlBySelectableObject.put(taskComment, (Control)styledText);
        }
        if (foundNew) {
            this.commentsSection.setExpanded(true);
        } else if (this.taskData.getComments() == null || this.taskData.getComments().size() == 0) {
            this.commentsSection.setExpanded(false);
        } else if (this.editorInput.getTaskData() != null && this.editorInput.getOldTaskData() != null) {
            java.util.List newTaskComments = this.editorInput.getTaskData().getComments();
            java.util.List oldTaskComments = this.editorInput.getOldTaskData().getComments();
            if (newTaskComments == null || oldTaskComments == null) {
                this.commentsSection.setExpanded(true);
            } else {
                this.commentsSection.setExpanded(newTaskComments.size() != oldTaskComments.size());
            }
        }
    }

    public String formatDate(String dateString) {
        return dateString;
    }

    private boolean isNewComment(TaskComment comment) {
        if (this.editorInput.getOldTaskData() != null) {
            return comment.getNumber() > this.editorInput.getOldTaskData().getComments().size();
        }
        return false;
    }

    protected AbstractRenderingEngine getRenderingEngine() {
        return null;
    }

    protected void createNewCommentLayout(Composite composite) {
        Section newCommentSection = this.toolkit.createSection(composite, 256);
        newCommentSection.setText(this.getSectionLabel(SECTION_NAME.NEWCOMMENT_SECTION));
        newCommentSection.setLayout((Layout)new GridLayout());
        newCommentSection.setLayoutData((Object)new GridData(1808));
        Composite newCommentsComposite = this.toolkit.createComposite((Composite)newCommentSection);
        newCommentsComposite.setLayout((Layout)new GridLayout());
        if (this.taskData.getAttribute("task.common.comment.new") == null) {
            this.taskData.setAttributeValue("task.common.comment.new", "");
        }
        final RepositoryTaskAttribute attribute = this.taskData.getAttribute("task.common.comment.new");
        if (this.getRenderingEngine() != null) {
            Composite editPreviewComposite = this.toolkit.createComposite(newCommentsComposite);
            GridData editPreviewData = new GridData(1808);
            editPreviewData.widthHint = 553;
            editPreviewData.minimumHeight = 140;
            editPreviewData.grabExcessHorizontalSpace = true;
            editPreviewComposite.setLayoutData((Object)editPreviewData);
            editPreviewComposite.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
            StackLayout editPreviewLayout = new StackLayout();
            editPreviewComposite.setLayout((Layout)editPreviewLayout);
            this.newCommentTextViewer = this.addTextEditor(this.repository, editPreviewComposite, attribute.getValue(), true, 8389186);
            editPreviewLayout.topControl = this.newCommentTextViewer.getControl();
            editPreviewComposite.layout();
            Composite buttonComposite = this.toolkit.createComposite(newCommentsComposite);
            buttonComposite.setLayout((Layout)new GridLayout());
            this.createPreviewButton(buttonComposite, this.newCommentTextViewer, editPreviewComposite, editPreviewLayout);
        } else {
            this.newCommentTextViewer = this.addTextEditor(this.repository, newCommentsComposite, attribute.getValue(), true, 8389186);
            GridData addCommentsTextData = new GridData(1808);
            addCommentsTextData.widthHint = 553;
            addCommentsTextData.minimumHeight = 140;
            addCommentsTextData.grabExcessHorizontalSpace = true;
            this.newCommentTextViewer.getControl().setLayoutData((Object)addCommentsTextData);
            this.newCommentTextViewer.getControl().setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        }
        this.newCommentTextViewer.setEditable(true);
        this.newCommentTextViewer.addTextListener(new ITextListener(){

            public void textChanged(TextEvent event) {
                String newValue = AbstractRepositoryTaskEditor.this.addCommentsTextBox.getText();
                if (!newValue.equals(attribute.getValue())) {
                    attribute.setValue(newValue);
                    AbstractRepositoryTaskEditor.this.attributeChanged(attribute);
                }
            }
        });
        this.newCommentTextViewer.getTextWidget().addListener(15, (Listener)new NewCommentListener());
        this.addCommentsTextBox = this.newCommentTextViewer.getTextWidget();
        newCommentSection.setClient((Control)newCommentsComposite);
        this.toolkit.paintBordersFor(newCommentsComposite);
    }

    private Browser addBrowser(Composite parent, int style) {
        Browser browser = new Browser(parent, style);
        browser.addLocationListener((LocationListener)new LocationAdapter(){

            public void changing(LocationEvent event) {
                if (AbstractRepositoryTaskEditor.this.ignoreLocationEvents) {
                    return;
                }
                if (event.location != null && !event.location.startsWith("about")) {
                    event.doit = false;
                    TaskUrlHyperlink link = new TaskUrlHyperlink((IRegion)new Region(0, 0), event.location);
                    link.open();
                }
            }
        });
        return browser;
    }

    private void createPreviewButton(Composite buttonComposite, TextViewer editor, Composite editorComposite, StackLayout editorLayout) {
        new Object(buttonComposite, editorComposite, editor, editorLayout){
            private static final String LABEL_BUTTON_PREVIEW = "Preview";
            private static final String LABEL_BUTTON_EDIT = "Edit";
            private int buttonState = 0;
            private Button previewButton;
            private Browser previewBrowser;
            {
                this.previewButton = AbstractRepositoryTaskEditor.this.toolkit.createButton(composite, LABEL_BUTTON_PREVIEW, 8);
                GridData previewButtonData = new GridData(32);
                previewButtonData.widthHint = 100;
                this.previewButton.setLayoutData((Object)previewButtonData);
                this.previewButton.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        if (previewBrowser == null) {
                            previewBrowser = AbstractRepositoryTaskEditor.this.addBrowser(composite2, 0);
                        }
                        41 v0 = this;
                        int n = v0.buttonState + 1;
                        v0.buttonState = n;
                        buttonState = n % 2;
                        if (buttonState == 1) {
                            AbstractRepositoryTaskEditor.this.setText(previewBrowser, "Loading preview...");
                            AbstractRepositoryTaskEditor.this.previewWiki(previewBrowser, textViewer.getTextWidget().getText());
                        }
                        previewButton.setText(buttonState == 0 ? 41.LABEL_BUTTON_PREVIEW : 41.LABEL_BUTTON_EDIT);
                        stackLayout.topControl = buttonState == 0 ? textViewer.getControl() : previewBrowser;
                        composite2.layout();
                    }
                });
            }
        };
    }

    private void setText(Browser browser, String html) {
        try {
            this.ignoreLocationEvents = true;
            browser.setText(html != null ? html : "");
        }
        finally {
            this.ignoreLocationEvents = false;
        }
    }

    private void previewWiki(final Browser browser, String sourceText) {
        final class PreviewWikiJob
        extends Job {
            private String sourceText;
            private String htmlText;
            private IStatus jobStatus;

            public PreviewWikiJob(String sourceText) {
                super("Formatting Wiki Text");
                if (sourceText == null) {
                    throw new IllegalArgumentException("source text must not be null");
                }
                this.sourceText = sourceText;
            }

            protected IStatus run(IProgressMonitor monitor) {
                AbstractRenderingEngine htmlRenderingEngine = AbstractRepositoryTaskEditor.this.getRenderingEngine();
                if (htmlRenderingEngine == null) {
                    this.jobStatus = new RepositoryStatus(AbstractRepositoryTaskEditor.this.repository, 1, "org.eclipse.mylyn.tasks.ui", 7, "The repository does not support HTML preview.");
                    return Status.OK_STATUS;
                }
                this.jobStatus = Status.OK_STATUS;
                try {
                    this.htmlText = htmlRenderingEngine.renderAsHtml(AbstractRepositoryTaskEditor.this.repository, this.sourceText, monitor);
                }
                catch (CoreException e) {
                    this.jobStatus = e.getStatus();
                }
                return Status.OK_STATUS;
            }

            public String getHtmlText() {
                return this.htmlText;
            }

            public IStatus getStatus() {
                return this.jobStatus;
            }
        }
        final PreviewWikiJob job = new PreviewWikiJob(sourceText);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){
            {
            }

            public void done(IJobChangeEvent event) {
                if (!AbstractRepositoryTaskEditor.this.form.isDisposed()) {
                    if (job.getStatus().isOK()) {
                        AbstractRepositoryTaskEditor.this.getPartControl().getDisplay().asyncExec(new Runnable(){
                            {
                            }

                            public void run() {
                                AbstractRepositoryTaskEditor.this.setText(browser, job.getHtmlText());
                                AbstractRepositoryTaskEditor.this.parentEditor.setMessage(null, 0);
                            }
                        });
                    } else {
                        AbstractRepositoryTaskEditor.this.getPartControl().getDisplay().asyncExec(new Runnable(){
                            {
                            }

                            public void run() {
                                AbstractRepositoryTaskEditor.this.parentEditor.setMessage(job.getStatus().getMessage(), 3);
                            }
                        });
                    }
                }
                super.done(event);
            }
        });
        job.setUser(true);
        job.schedule();
    }

    protected void createActionsLayout(Composite composite) {
        Section section = this.createSection(composite, this.getSectionLabel(SECTION_NAME.ACTIONS_SECTION));
        GridDataFactory.fillDefaults().align(4, 128).grab(true, true).applyTo((Control)section);
        Composite buttonComposite = this.toolkit.createComposite((Composite)section);
        GridLayout buttonLayout = new GridLayout();
        GridDataFactory.fillDefaults().align(4, 128).applyTo((Control)buttonComposite);
        buttonLayout.numColumns = 4;
        buttonComposite.setLayout((Layout)buttonLayout);
        this.addRadioButtons(buttonComposite);
        this.addActionButtons(buttonComposite);
        section.setClient((Control)buttonComposite);
    }

    protected Section createSection(Composite composite, String title) {
        Section section = this.toolkit.createSection(composite, 258);
        section.setText(title);
        section.setExpanded(true);
        section.setLayoutData((Object)new GridData(768));
        return section;
    }

    protected void addActionButtons(Composite buttonComposite) {
        this.submitButton = this.toolkit.createButton(buttonComposite, LABEL_BUTTON_SUBMIT, 0);
        GridData submitButtonData = new GridData(32);
        submitButtonData.widthHint = 100;
        this.submitButton.setImage(TasksUiImages.getImage(TasksUiImages.REPOSITORY_SUBMIT));
        this.submitButton.setLayoutData((Object)submitButtonData);
        this.submitButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                AbstractRepositoryTaskEditor.this.submitToRepository();
            }
        });
        this.setSubmitEnabled(true);
        this.toolkit.createLabel(buttonComposite, "    ");
        AbstractTask task = TasksUiPlugin.getTaskListManager().getTaskList().getTask(this.repository.getUrl(), this.taskData.getId());
        if (this.attachContextEnabled && task != null) {
            this.addAttachContextButton(buttonComposite, task);
        }
    }

    private void setSubmitEnabled(boolean enabled) {
        if (this.submitButton != null && !this.submitButton.isDisposed()) {
            this.submitButton.setEnabled(enabled);
            if (enabled) {
                this.submitButton.setToolTipText("Submit to " + this.repository.getUrl());
            }
        }
    }

    protected String getHistoryUrl() {
        return null;
    }

    protected void saveTaskOffline(IProgressMonitor progressMonitor) {
        if (this.taskData == null) {
            return;
        }
        if (this.repositoryTask != null) {
            TasksUiPlugin.getSynchronizationManager().saveOutgoing(this.repositoryTask, this.changedAttributes);
        }
        if (this.repositoryTask != null) {
            TasksUiPlugin.getTaskListManager().getTaskList().notifyTaskChanged(this.repositoryTask, false);
        }
        this.markDirty(false);
    }

    public void setFocus() {
        if (this.summaryTextViewer != null && !this.summaryTextViewer.getTextWidget().isDisposed()) {
            if (this.firstFocus) {
                this.summaryTextViewer.getTextWidget().setFocus();
                this.firstFocus = false;
            }
        } else {
            this.form.setFocus();
        }
    }

    protected void updateEditorTitle() {
        this.setPartName(this.editorInput.getName());
        ((TaskEditor)this.getEditor()).updateTitle(this.editorInput.getName());
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSave(IProgressMonitor monitor) {
        this.saveTaskOffline(monitor);
        this.updateEditorTitle();
    }

    public void doSaveAs() {
    }

    public Composite getEditorComposite() {
        return this.editorComposite;
    }

    public void dispose() {
        TasksUiPlugin.getTaskListManager().getTaskList().removeChangeListener(this.TASKLIST_CHANGE_LISTENER);
        this.getSite().getPage().removeSelectionListener(this.selectionListener);
        if (this.waitCursor != null) {
            this.waitCursor.dispose();
        }
        if (this.activateAction != null) {
            this.activateAction.dispose();
        }
        super.dispose();
    }

    protected void fireSelectionChanged(final SelectionChangedEvent event) {
        Object[] listeners = this.selectionChangedListeners.toArray();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    private void revealAllComments() {
        if (this.commentsSection != null) {
            this.commentsSection.setExpanded(true);
        }
        block0: for (StyledText text : this.commentStyleText) {
            if (text.isDisposed()) continue;
            Composite comp = text.getParent();
            while (comp != null && !comp.isDisposed()) {
                if (comp instanceof ExpandableComposite && !comp.isDisposed()) {
                    ExpandableComposite ex = (ExpandableComposite)comp;
                    ex.setExpanded(true);
                    if (ex.getData() == null || !(ex.getData() instanceof Composite)) continue block0;
                    ((Composite)ex.getData()).setVisible(true);
                    continue block0;
                }
                comp = comp.getParent();
            }
        }
        this.resetLayout();
    }

    private void hideAllComments() {
        block0: for (StyledText text : this.commentStyleText) {
            if (text.isDisposed()) continue;
            Composite comp = text.getParent();
            while (comp != null && !comp.isDisposed()) {
                if (comp instanceof ExpandableComposite && !comp.isDisposed()) {
                    ExpandableComposite ex = (ExpandableComposite)comp;
                    ex.setExpanded(false);
                    if (ex.getData() == null || !(ex.getData() instanceof Composite)) continue block0;
                    ((Composite)ex.getData()).setVisible(false);
                    continue block0;
                }
                comp = comp.getParent();
            }
        }
        this.resetLayout();
    }

    public boolean select(Object o, boolean highlight) {
        Control control = this.controlBySelectableObject.get(o);
        if (control != null) {
            Composite comp = control.getParent();
            while (comp != null) {
                if (comp instanceof ExpandableComposite) {
                    ExpandableComposite ex = (ExpandableComposite)comp;
                    ex.setExpanded(true);
                    if (ex.getData() != null && ex.getData() instanceof Composite) {
                        ((Composite)ex.getData()).setVisible(true);
                    }
                }
                comp = comp.getParent();
            }
            this.focusOn(control, highlight);
        } else if (o instanceof RepositoryTaskData) {
            this.focusOn(null, highlight);
        } else {
            return false;
        }
        return true;
    }

    private void selectNewComment() {
        this.focusOn((Control)this.addCommentsTextBox, false);
    }

    protected void focusAttributes() {
        if (this.attributesSection != null) {
            this.focusOn((Control)this.attributesSection, false);
        }
    }

    private void focusDescription() {
        if (this.descriptionTextViewer != null) {
            this.focusOn((Control)this.descriptionTextViewer.getTextWidget(), false);
        }
    }

    private void focusOn(Control selectionComposite, boolean highlight) {
        int pos = 0;
        if (selectionComposite != null) {
            pos = 0;
            Control s = selectionComposite;
            if (s.isDisposed()) {
                return;
            }
            s.setEnabled(true);
            s.setFocus();
            s.forceFocus();
            while (s != null && s != this.getEditorComposite()) {
                if (s.isDisposed()) continue;
                pos += s.getLocation().y;
                s = s.getParent();
            }
            pos -= 60;
        }
        if (!this.form.getBody().isDisposed()) {
            this.form.setOrigin(0, pos);
        }
    }

    public Object getAdapter(Class adapter) {
        return this.getAdapterDelgate(adapter);
    }

    public Object getAdapterDelgate(Class<?> adapter) {
        if (IContentOutlinePage.class.equals(adapter)) {
            if (this.outlinePage == null && this.editorInput != null && this.taskOutlineModel != null) {
                this.outlinePage = new RepositoryTaskOutlinePage(this.taskOutlineModel);
            }
            return this.outlinePage;
        }
        return super.getAdapter(adapter);
    }

    public RepositoryTaskOutlinePage getOutline() {
        return this.outlinePage;
    }

    public void close() {
        Display activeDisplay = this.getSite().getShell().getDisplay();
        activeDisplay.asyncExec(new Runnable(){

            public void run() {
                if (AbstractRepositoryTaskEditor.this.getSite() != null && AbstractRepositoryTaskEditor.this.getSite().getPage() != null && !AbstractRepositoryTaskEditor.this.getManagedForm().getForm().isDisposed()) {
                    if (AbstractRepositoryTaskEditor.this.parentEditor != null) {
                        AbstractRepositoryTaskEditor.this.getSite().getPage().closeEditor((IEditorPart)AbstractRepositoryTaskEditor.this.parentEditor, false);
                    } else {
                        AbstractRepositoryTaskEditor.this.getSite().getPage().closeEditor((IEditorPart)AbstractRepositoryTaskEditor.this, false);
                    }
                }
            }
        });
    }

    public void addAttributeListener(IRepositoryTaskAttributeListener listener) {
        this.attributesListeners.add(listener);
    }

    public void removeAttributeListener(IRepositoryTaskAttributeListener listener) {
        this.attributesListeners.remove(listener);
    }

    public void setParentEditor(TaskEditor parentEditor) {
        this.parentEditor = parentEditor;
    }

    public TaskEditor getParentEditor() {
        return this.parentEditor;
    }

    public RepositoryTaskOutlineNode getTaskOutlineModel() {
        return this.taskOutlineModel;
    }

    public void setTaskOutlineModel(RepositoryTaskOutlineNode taskOutlineModel) {
        this.taskOutlineModel = taskOutlineModel;
    }

    public Control getControl() {
        return this.form;
    }

    public void setSummaryText(String text) {
        if (this.summaryTextViewer != null && this.summaryTextViewer.getTextWidget() != null) {
            this.summaryTextViewer.getTextWidget().setText(text);
        }
    }

    public void setDescriptionText(String text) {
        this.descriptionTextViewer.getDocument().set(text);
    }

    protected void addRadioButtons(Composite buttonComposite) {
        int i = 0;
        Button selected = null;
        this.radios = new Button[this.taskData.getOperations().size()];
        this.radioOptions = new Control[this.taskData.getOperations().size()];
        for (RepositoryOperation o : this.taskData.getOperations()) {
            this.radios[i] = this.toolkit.createButton(buttonComposite, "", 16);
            this.radios[i].setFont(TEXT_FONT);
            GridData radioData = new GridData(32);
            radioData.horizontalSpan = !o.hasOptions() && !o.isInput() ? 4 : 1;
            radioData.heightHint = 20;
            String opName = o.getOperationName();
            opName = opName.replaceAll("</.*>", "");
            opName = opName.replaceAll("<.*>", "");
            this.radios[i].setText(opName);
            this.radios[i].setLayoutData((Object)radioData);
            this.radios[i].addSelectionListener((SelectionListener)new RadioButtonListener());
            if (o.hasOptions()) {
                radioData = new GridData(32);
                radioData.horizontalSpan = 3;
                radioData.heightHint = 20;
                radioData.widthHint = 120;
                this.radioOptions[i] = new CCombo(buttonComposite, 0x800008);
                this.radioOptions[i].setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
                this.toolkit.adapt(this.radioOptions[i], true, true);
                this.radioOptions[i].setFont(TEXT_FONT);
                this.radioOptions[i].setLayoutData((Object)radioData);
                Object[] a = o.getOptionNames().toArray();
                Arrays.sort(a);
                int j = 0;
                while (j < a.length) {
                    if (a[j] != null) {
                        ((CCombo)this.radioOptions[i]).add((String)a[j]);
                        if (((String)a[j]).equals(o.getOptionSelection())) {
                            ((CCombo)this.radioOptions[i]).select(j);
                        }
                    }
                    ++j;
                }
                ((CCombo)this.radioOptions[i]).addSelectionListener((SelectionListener)new RadioButtonListener());
            } else if (o.isInput()) {
                radioData = new GridData(32);
                radioData.horizontalSpan = 3;
                radioData.widthHint = 110;
                String assignmentValue = "";
                this.radioOptions[i] = this.toolkit.createText(buttonComposite, assignmentValue);
                this.radioOptions[i].setFont(TEXT_FONT);
                this.radioOptions[i].setLayoutData((Object)radioData);
                ((Text)this.radioOptions[i]).setText(o.getInputValue());
                ((Text)this.radioOptions[i]).addModifyListener((ModifyListener)new RadioButtonListener());
                if (this.hasContentAssist(o)) {
                    ContentAssistCommandAdapter adapter = this.applyContentAssist((Text)this.radioOptions[i], this.createContentProposalProvider(o));
                    ILabelProvider propsalLabelProvider = this.createProposalLabelProvider(o);
                    if (propsalLabelProvider != null) {
                        adapter.setLabelProvider(propsalLabelProvider);
                    }
                    adapter.setProposalAcceptanceStyle(2);
                }
            }
            if (i == 0 || o.isChecked()) {
                if (selected != null) {
                    selected.setSelection(false);
                }
                selected = this.radios[i];
                this.radios[i].setSelection(true);
                if (o.hasOptions() && o.getOptionSelection() != null) {
                    int j = 0;
                    String[] stringArray = ((CCombo)this.radioOptions[i]).getItems();
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        if (s.compareTo(o.getOptionSelection()) == 0) {
                            ((CCombo)this.radioOptions[i]).select(j);
                        }
                        ++j;
                        ++n2;
                    }
                }
                this.taskData.setSelectedOperation(o);
            }
            ++i;
        }
        this.toolkit.paintBordersFor(buttonComposite);
    }

    protected boolean hasVisibleAttributeChanges() {
        if (this.taskData == null) {
            return false;
        }
        for (RepositoryTaskAttribute attribute : this.taskData.getAttributes()) {
            if (attribute.isHidden() || !this.hasChanged(attribute)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasOutgoingChange(RepositoryTaskAttribute newAttribute) {
        return this.editorInput.getOldEdits().contains(newAttribute);
    }

    protected boolean hasChanged(RepositoryTaskAttribute newAttribute) {
        if (newAttribute == null) {
            return false;
        }
        RepositoryTaskData oldTaskData = this.editorInput.getOldTaskData();
        if (oldTaskData == null) {
            return false;
        }
        if (this.hasOutgoingChange(newAttribute)) {
            return false;
        }
        RepositoryTaskAttribute oldAttribute = oldTaskData.getAttribute(newAttribute.getId());
        if (oldAttribute == null) {
            return true;
        }
        if (oldAttribute.getValue() != null && !oldAttribute.getValue().equals(newAttribute.getValue())) {
            return true;
        }
        return oldAttribute.getValues() != null && !oldAttribute.getValues().equals(newAttribute.getValues());
    }

    protected void addAttachContextButton(Composite buttonComposite, AbstractTask task) {
        this.attachContextButton = this.toolkit.createButton(buttonComposite, "Attach Context", 32);
        this.attachContextButton.setImage(TasksUiImages.getImage(TasksUiImages.CONTEXT_ATTACH));
    }

    protected void addSelfToCC(Composite composite) {
        if (this.repository.getUserName() == null) {
            return;
        }
        RepositoryTaskAttribute owner = this.taskData.getAttribute("task.common.user.assigned");
        if (owner != null && owner.getValue().indexOf(this.repository.getUserName()) != -1) {
            return;
        }
        RepositoryTaskAttribute reporter = this.taskData.getAttribute("task.common.user.reporter");
        if (reporter != null && reporter.getValue().indexOf(this.repository.getUserName()) != -1) {
            return;
        }
        RepositoryTaskAttribute ccAttribute = this.taskData.getAttribute("task.common.user.cc");
        if (ccAttribute != null && ccAttribute.getValues().contains(this.repository.getUserName())) {
            return;
        }
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        toolkit.createLabel(composite, "");
        final Button addSelfButton = toolkit.createButton(composite, "Add me to CC", 32);
        addSelfButton.setSelection("1".equals(this.taskData.getAttributeValue("task.common.addselfcc")));
        addSelfButton.setImage(TasksUiImages.getImage(TasksUiImages.PERSON));
        addSelfButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (addSelfButton.getSelection()) {
                    AbstractRepositoryTaskEditor.this.taskData.setAttributeValue("task.common.addselfcc", "1");
                } else {
                    AbstractRepositoryTaskEditor.this.taskData.setAttributeValue("task.common.addselfcc", "0");
                }
                RepositoryTaskAttribute attribute = AbstractRepositoryTaskEditor.this.taskData.getAttribute("task.common.addselfcc");
                AbstractRepositoryTaskEditor.this.changedAttributes.add(attribute);
                AbstractRepositoryTaskEditor.this.markDirty(true);
            }
        });
    }

    public boolean getAttachContext() {
        if (this.attachContextButton == null || this.attachContextButton.isDisposed()) {
            return false;
        }
        return this.attachContextButton.getSelection();
    }

    public void setExpandAttributeSection(boolean expandAttributeSection) {
        this.expandedStateAttributes = expandAttributeSection;
    }

    public void setAttachContextEnabled(boolean attachContextEnabled) {
        this.attachContextEnabled = attachContextEnabled;
    }

    public void showBusy(boolean busy) {
        if (!this.getManagedForm().getForm().isDisposed() && busy != this.formBusy) {
            if (this.synchronizeEditorAction != null) {
                this.synchronizeEditorAction.setEnabled(!busy);
            }
            if (this.activateAction != null) {
                this.activateAction.setEnabled(!busy);
            }
            if (this.openBrowserAction != null) {
                this.openBrowserAction.setEnabled(!busy);
            }
            if (this.historyAction != null) {
                this.historyAction.setEnabled(!busy);
            }
            if (this.submitButton != null && !this.submitButton.isDisposed()) {
                this.submitButton.setEnabled(!busy);
            }
            this.setEnabledState(this.editorComposite, !busy);
            this.formBusy = busy;
        }
    }

    private void setEnabledState(Composite composite, boolean enabled) {
        if (!composite.isDisposed()) {
            composite.setEnabled(enabled);
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control control = controlArray[n2];
                control.setEnabled(enabled);
                if (control instanceof Composite) {
                    this.setEnabledState((Composite)control, enabled);
                }
                ++n2;
            }
        }
    }

    public void setGlobalBusy(boolean busy) {
        if (this.parentEditor != null) {
            this.parentEditor.showBusy(busy);
        } else {
            this.showBusy(busy);
        }
    }

    public void submitToRepository() {
        this.setGlobalBusy(true);
        if (this.isDirty()) {
            this.saveTaskOffline((IProgressMonitor)new NullProgressMonitor());
            this.markDirty(false);
        }
        final boolean attachContext = this.getAttachContext();
        Job submitJob = new Job(LABEL_JOB_SUBMIT){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected IStatus run(IProgressMonitor monitor) {
                AbstractTask modifiedTask = null;
                try {
                    monitor.beginTask("Submitting task", 3);
                    String taskId = AbstractRepositoryTaskEditor.this.connector.getTaskDataHandler().postTaskData(AbstractRepositoryTaskEditor.this.repository, AbstractRepositoryTaskEditor.this.taskData, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    final boolean isNew = AbstractRepositoryTaskEditor.this.taskData.isNew();
                    if (isNew) {
                        if (taskId == null) throw new CoreException((IStatus)new RepositoryStatus(4, "org.eclipse.mylyn.tasks.ui", 7, "Task could not be created. No additional information was provided by the connector."));
                        modifiedTask = AbstractRepositoryTaskEditor.this.updateSubmittedTask(taskId, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    } else {
                        modifiedTask = TasksUiPlugin.getTaskListManager().getTaskList().getTask(AbstractRepositoryTaskEditor.this.repository.getUrl(), AbstractRepositoryTaskEditor.this.taskData.getId());
                    }
                    if (modifiedTask != null) {
                        if (attachContext && AbstractRepositoryTaskEditor.this.connector.getAttachmentHandler() != null) {
                            AbstractRepositoryTaskEditor.this.connector.getAttachmentHandler().attachContext(AbstractRepositoryTaskEditor.this.repository, modifiedTask, "", (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                        modifiedTask.setSubmitting(true);
                        final AbstractTask finalModifiedTask = modifiedTask;
                        TasksUiPlugin.getSynchronizationManager().synchronize(AbstractRepositoryTaskEditor.this.connector, modifiedTask, true, (IJobChangeListener)new JobChangeAdapter(){

                            public void done(IJobChangeEvent event) {
                                if (isNew) {
                                    AbstractRepositoryTaskEditor.this.close();
                                    TasksUiPlugin.getSynchronizationManager().setTaskRead(finalModifiedTask, true);
                                    TasksUiUtil.openEditor(finalModifiedTask, false);
                                } else {
                                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                                        public void run() {
                                            AbstractRepositoryTaskEditor.this.refreshEditor();
                                        }
                                    });
                                }
                            }
                        });
                        TasksUiPlugin.getSynchronizationScheduler().synchNow(0L, Collections.singletonList(AbstractRepositoryTaskEditor.this.repository), false);
                    } else {
                        AbstractRepositoryTaskEditor.this.close();
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                TasksUiUtil.openRepositoryTask((this).AbstractRepositoryTaskEditor.this.repository.getUrl(), (this).AbstractRepositoryTaskEditor.this.taskData.getId(), AbstractRepositoryTaskEditor.this.connector.getTaskUrl((this).AbstractRepositoryTaskEditor.this.taskData.getRepositoryUrl(), (this).AbstractRepositoryTaskEditor.this.taskData.getId()));
                            }
                        });
                    }
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (CoreException e) {
                    if (modifiedTask != null) {
                        modifiedTask.setSubmitting(false);
                    }
                    IStatus iStatus = AbstractRepositoryTaskEditor.this.handleSubmitError(e);
                    return iStatus;
                }
                catch (Exception e) {
                    if (modifiedTask != null) {
                        modifiedTask.setSubmitting(false);
                    }
                    StatusHandler.fail((Throwable)e, (String)e.getMessage(), (boolean)true);
                    PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            AbstractRepositoryTaskEditor.this.setGlobalBusy(false);
                        }
                    });
                    return Status.OK_STATUS;
                }
                finally {
                    monitor.done();
                }
            }
        };
        IJobChangeListener jobListener = this.getSubmitJobListener();
        if (jobListener != null) {
            submitJob.addJobChangeListener(jobListener);
        }
        submitJob.schedule();
    }

    public void refreshEditor() {
        try {
            if (!this.getManagedForm().getForm().isDisposed()) {
                if (this.isDirty && !this.taskData.isNew()) {
                    this.doSave((IProgressMonitor)new NullProgressMonitor());
                }
                this.setGlobalBusy(true);
                this.changedAttributes.clear();
                this.commentStyleText.clear();
                this.controlBySelectableObject.clear();
                this.editorInput.refreshInput();
                if (this.repositoryTask != null) {
                    TasksUiPlugin.getSynchronizationManager().setTaskRead(this.repositoryTask, true);
                }
                this.setInputWithNotify(this.getEditorInput());
                this.init(this.getEditorSite(), this.getEditorInput());
                PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (AbstractRepositoryTaskEditor.this.editorComposite != null && !AbstractRepositoryTaskEditor.this.editorComposite.isDisposed()) {
                            if (AbstractRepositoryTaskEditor.this.taskData == null) {
                                AbstractRepositoryTaskEditor.this.parentEditor.setMessage("Task data not available. Press synchronize button (right) to retrieve latest data.", 2);
                            } else {
                                AbstractRepositoryTaskEditor.this.updateEditorTitle();
                                AbstractRepositoryTaskEditor.this.menu = AbstractRepositoryTaskEditor.this.editorComposite.getMenu();
                                AbstractRepositoryTaskEditor.this.removeSections();
                                AbstractRepositoryTaskEditor.this.editorComposite.setMenu(AbstractRepositoryTaskEditor.this.menu);
                                AbstractRepositoryTaskEditor.this.createSections();
                                AbstractRepositoryTaskEditor.this.markDirty(false);
                                AbstractRepositoryTaskEditor.this.parentEditor.setMessage(null, 0);
                                AbstractRepositoryTaskEditor.this.getEditor().setActivePage(AbstractRepositoryTaskEditor.this.getId());
                                if (AbstractRepositoryTaskEditor.this.taskOutlineModel != null && AbstractRepositoryTaskEditor.this.outlinePage != null && !AbstractRepositoryTaskEditor.this.outlinePage.getControl().isDisposed()) {
                                    AbstractRepositoryTaskEditor.this.outlinePage.getOutlineTreeViewer().setInput((Object)AbstractRepositoryTaskEditor.this.taskOutlineModel);
                                    AbstractRepositoryTaskEditor.this.outlinePage.getOutlineTreeViewer().refresh(true);
                                }
                                if (AbstractRepositoryTaskEditor.this.repositoryTask != null) {
                                    TasksUiPlugin.getSynchronizationManager().setTaskRead(AbstractRepositoryTaskEditor.this.repositoryTask, true);
                                }
                                AbstractRepositoryTaskEditor.this.setSubmitEnabled(true);
                            }
                        }
                    }
                });
            } else if (this.repositoryTask != null) {
                TasksUiPlugin.getSynchronizationManager().setTaskRead(this.repositoryTask, true);
            }
        }
        finally {
            if (!this.getManagedForm().getForm().isDisposed()) {
                this.setGlobalBusy(false);
            }
        }
    }

    private void setMenu(Composite comp, Menu menu) {
        if (!comp.isDisposed()) {
            comp.setMenu(null);
            Control[] controlArray = comp.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.setMenu(null);
                if (child instanceof Composite) {
                    this.setMenu((Composite)child, menu);
                }
                ++n2;
            }
        }
    }

    protected IJobChangeListener getSubmitJobListener() {
        return null;
    }

    protected AbstractTaskCategory getCategory() {
        return null;
    }

    protected IStatus handleSubmitError(final CoreException exception) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (AbstractRepositoryTaskEditor.this.form != null && !AbstractRepositoryTaskEditor.this.form.isDisposed()) {
                    if (exception.getStatus().getCode() == 5) {
                        AbstractRepositoryTaskEditor.this.parentEditor.setMessage(AbstractRepositoryTaskEditor.ERROR_NOCONNECTIVITY, 3);
                        StatusHandler.log((IStatus)exception.getStatus());
                    } else if (exception.getStatus().getCode() == 9) {
                        StatusHandler.displayStatus((String)"Comment required", (IStatus)exception.getStatus());
                        if (!AbstractRepositoryTaskEditor.this.getManagedForm().getForm().isDisposed() && AbstractRepositoryTaskEditor.this.newCommentTextViewer != null && !AbstractRepositoryTaskEditor.this.newCommentTextViewer.getControl().isDisposed()) {
                            AbstractRepositoryTaskEditor.this.newCommentTextViewer.getControl().setFocus();
                        }
                    } else if (exception.getStatus().getCode() == 3) {
                        if (TasksUiUtil.openEditRepositoryWizard(AbstractRepositoryTaskEditor.this.repository) == 0) {
                            AbstractRepositoryTaskEditor.this.submitToRepository();
                            return;
                        }
                    } else {
                        StatusHandler.displayStatus((String)"Submit failed", (IStatus)exception.getStatus());
                    }
                    AbstractRepositoryTaskEditor.this.setGlobalBusy(false);
                }
            }
        });
        return Status.OK_STATUS;
    }

    protected AbstractTask updateSubmittedTask(String postResult, IProgressMonitor monitor) throws CoreException {
        final AbstractTask newTask = this.connector.createTaskFromExistingId(this.repository, postResult, monitor);
        if (newTask != null) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (AbstractRepositoryTaskEditor.this.getCategory() != null) {
                        TasksUiPlugin.getTaskListManager().getTaskList().moveTask(newTask, (AbstractTaskContainer)AbstractRepositoryTaskEditor.this.getCategory());
                    }
                }
            });
        }
        return newTask;
    }

    public AbstractRepositoryConnector getConnector() {
        return this.connector;
    }

    public void setShowAttachments(boolean showAttachments) {
        this.showAttachments = showAttachments;
    }

    public String getCommonDateFormat() {
        return HEADER_DATE_FORMAT;
    }

    public Color getColorIncoming() {
        return this.colorIncoming;
    }

    public void addSelectableControl(Object item, Control control) {
        this.controlBySelectableObject.put(item, control);
    }

    public void removeSelectableControl(Object item) {
        this.controlBySelectableObject.remove(item);
    }

    protected void addAssignedTo(Composite peopleComposite) {
        boolean haveRealName = false;
        RepositoryTaskAttribute assignedAttribute = this.taskData.getAttribute("task.common.user.assigned.name");
        if (assignedAttribute == null) {
            assignedAttribute = this.taskData.getAttribute("task.common.user.assigned");
        } else {
            haveRealName = true;
        }
        if (assignedAttribute != null) {
            Text textField;
            Label label = this.createLabel(peopleComposite, assignedAttribute);
            GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)label);
            if (assignedAttribute.isReadOnly()) {
                textField = this.createTextField(peopleComposite, assignedAttribute, 0x800008);
            } else {
                textField = this.createTextField(peopleComposite, assignedAttribute, 0x800000);
                ContentAssistCommandAdapter adapter = this.applyContentAssist(textField, this.createContentProposalProvider(assignedAttribute));
                ILabelProvider propsalLabelProvider = this.createProposalLabelProvider(assignedAttribute);
                if (propsalLabelProvider != null) {
                    adapter.setLabelProvider(propsalLabelProvider);
                }
                adapter.setProposalAcceptanceStyle(2);
            }
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)textField);
            if (haveRealName) {
                textField.setText(String.valueOf(textField.getText()) + " <" + this.taskData.getAttributeValue("task.common.user.assigned") + ">");
            }
        }
    }

    protected void resetLayout() {
        this.form.layout(true, true);
        this.form.reflow(true);
    }

    protected class DescriptionListener
    implements Listener {
        public void handleEvent(Event event) {
            AbstractRepositoryTaskEditor.this.fireSelectionChanged(new SelectionChangedEvent(AbstractRepositoryTaskEditor.this.selectionProvider, (ISelection)new StructuredSelection((Object)new RepositoryTaskSelection(AbstractRepositoryTaskEditor.this.taskData.getId(), AbstractRepositoryTaskEditor.this.taskData.getRepositoryUrl(), AbstractRepositoryTaskEditor.this.taskData.getRepositoryKind(), AbstractRepositoryTaskEditor.this.getSectionLabel(SECTION_NAME.DESCRIPTION_SECTION), true, AbstractRepositoryTaskEditor.this.taskData.getSummary()))));
        }
    }

    private class NewCommentListener
    implements Listener {
        private NewCommentListener() {
        }

        public void handleEvent(Event event) {
            AbstractRepositoryTaskEditor.this.fireSelectionChanged(new SelectionChangedEvent(AbstractRepositoryTaskEditor.this.selectionProvider, (ISelection)new StructuredSelection((Object)new RepositoryTaskSelection(AbstractRepositoryTaskEditor.this.taskData.getId(), AbstractRepositoryTaskEditor.this.taskData.getRepositoryUrl(), AbstractRepositoryTaskEditor.this.taskData.getRepositoryKind(), AbstractRepositoryTaskEditor.this.getSectionLabel(SECTION_NAME.NEWCOMMENT_SECTION), false, AbstractRepositoryTaskEditor.this.taskData.getSummary()))));
        }
    }

    private class RadioButtonListener
    implements SelectionListener,
    ModifyListener {
        private RadioButtonListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }

        public void widgetSelected(SelectionEvent e) {
            Button selected = null;
            int i = 0;
            while (i < AbstractRepositoryTaskEditor.this.radios.length) {
                if (AbstractRepositoryTaskEditor.this.radios[i].getSelection()) {
                    selected = AbstractRepositoryTaskEditor.this.radios[i];
                }
                ++i;
            }
            i = 0;
            while (i < AbstractRepositoryTaskEditor.this.radios.length) {
                RepositoryOperation o;
                if (AbstractRepositoryTaskEditor.this.radios[i] != e.widget && AbstractRepositoryTaskEditor.this.radios[i] != selected) {
                    AbstractRepositoryTaskEditor.this.radios[i].setSelection(false);
                }
                if (e.widget == AbstractRepositoryTaskEditor.this.radios[i]) {
                    o = AbstractRepositoryTaskEditor.this.taskData.getOperation(AbstractRepositoryTaskEditor.this.radios[i].getText());
                    AbstractRepositoryTaskEditor.this.taskData.setSelectedOperation(o);
                    AbstractRepositoryTaskEditor.this.markDirty(true);
                } else if (e.widget == AbstractRepositoryTaskEditor.this.radioOptions[i]) {
                    o = AbstractRepositoryTaskEditor.this.taskData.getOperation(AbstractRepositoryTaskEditor.this.radios[i].getText());
                    o.setOptionSelection(((CCombo)AbstractRepositoryTaskEditor.this.radioOptions[i]).getItem(((CCombo)AbstractRepositoryTaskEditor.this.radioOptions[i]).getSelectionIndex()));
                    if (AbstractRepositoryTaskEditor.this.taskData.getSelectedOperation() != null) {
                        AbstractRepositoryTaskEditor.this.taskData.getSelectedOperation().setChecked(false);
                    }
                    o.setChecked(true);
                    AbstractRepositoryTaskEditor.this.taskData.setSelectedOperation(o);
                    AbstractRepositoryTaskEditor.this.radios[i].setSelection(true);
                    if (selected != null && selected != AbstractRepositoryTaskEditor.this.radios[i]) {
                        selected.setSelection(false);
                    }
                    AbstractRepositoryTaskEditor.this.markDirty(true);
                }
                ++i;
            }
            AbstractRepositoryTaskEditor.this.validateInput();
        }

        public void modifyText(ModifyEvent e) {
            Button selected = null;
            int i = 0;
            while (i < AbstractRepositoryTaskEditor.this.radios.length) {
                if (AbstractRepositoryTaskEditor.this.radios[i].getSelection()) {
                    selected = AbstractRepositoryTaskEditor.this.radios[i];
                }
                ++i;
            }
            i = 0;
            while (i < AbstractRepositoryTaskEditor.this.radios.length) {
                RepositoryOperation o;
                if (AbstractRepositoryTaskEditor.this.radios[i] != e.widget && AbstractRepositoryTaskEditor.this.radios[i] != selected) {
                    AbstractRepositoryTaskEditor.this.radios[i].setSelection(false);
                }
                if (e.widget == AbstractRepositoryTaskEditor.this.radios[i]) {
                    o = AbstractRepositoryTaskEditor.this.taskData.getOperation(AbstractRepositoryTaskEditor.this.radios[i].getText());
                    AbstractRepositoryTaskEditor.this.taskData.setSelectedOperation(o);
                    AbstractRepositoryTaskEditor.this.markDirty(true);
                } else if (e.widget == AbstractRepositoryTaskEditor.this.radioOptions[i]) {
                    o = AbstractRepositoryTaskEditor.this.taskData.getOperation(AbstractRepositoryTaskEditor.this.radios[i].getText());
                    o.setInputValue(((Text)AbstractRepositoryTaskEditor.this.radioOptions[i]).getText());
                    if (AbstractRepositoryTaskEditor.this.taskData.getSelectedOperation() != null) {
                        AbstractRepositoryTaskEditor.this.taskData.getSelectedOperation().setChecked(false);
                    }
                    o.setChecked(true);
                    AbstractRepositoryTaskEditor.this.taskData.setSelectedOperation(o);
                    AbstractRepositoryTaskEditor.this.radios[i].setSelection(true);
                    if (selected != null && selected != AbstractRepositoryTaskEditor.this.radios[i]) {
                        selected.setSelection(false);
                    }
                    AbstractRepositoryTaskEditor.this.markDirty(true);
                }
                ++i;
            }
            AbstractRepositoryTaskEditor.this.validateInput();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum SECTION_NAME {
        ATTRIBTUES_SECTION("Attributes"),
        ATTACHMENTS_SECTION("Attachments"),
        DESCRIPTION_SECTION("Description"),
        COMMENTS_SECTION("Comments"),
        NEWCOMMENT_SECTION("New Comment"),
        ACTIONS_SECTION("Actions"),
        PEOPLE_SECTION("People"),
        RELATEDBUGS_SECTION("Related Tasks");

        private String prettyName;

        public String getPrettyName() {
            return this.prettyName;
        }

        private SECTION_NAME(String prettyName) {
            this.prettyName = prettyName;
        }
    }

    private class TabVerifyKeyListener
    implements VerifyKeyListener {
        private TabVerifyKeyListener() {
        }

        public void verifyKey(VerifyEvent event) {
            if (event.keyCode == 9) {
                event.doit = false;
                if (AbstractRepositoryTaskEditor.this.headerInfoComposite != null) {
                    AbstractRepositoryTaskEditor.this.headerInfoComposite.setFocus();
                }
            }
        }
    }
}

