/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.mylyn.internal.trac.core.ITracClient;
import org.eclipse.mylyn.internal.trac.core.TracClientData;
import org.eclipse.mylyn.internal.trac.core.TracException;
import org.eclipse.mylyn.internal.trac.core.TracLoginException;
import org.eclipse.mylyn.internal.trac.core.model.TracComponent;
import org.eclipse.mylyn.internal.trac.core.model.TracMilestone;
import org.eclipse.mylyn.internal.trac.core.model.TracPriority;
import org.eclipse.mylyn.internal.trac.core.model.TracSeverity;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketField;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketResolution;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketStatus;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketType;
import org.eclipse.mylyn.internal.trac.core.model.TracVersion;
import org.eclipse.mylyn.web.core.AbstractWebLocation;
import org.eclipse.mylyn.web.core.AuthenticationCredentials;
import org.eclipse.mylyn.web.core.WebClientUtil;

public abstract class AbstractTracClient
implements ITracClient {
    protected static final String USER_AGENT = "TracConnector";
    private static final String LOGIN_COOKIE_NAME = "trac_auth";
    protected static final IProgressMonitor DEFAULT_MONITOR = new NullProgressMonitor();
    protected final String repositoryUrl;
    protected final ITracClient.Version version;
    protected final AbstractWebLocation location;
    protected TracClientData data;

    public AbstractTracClient(URL repositoryUrl, ITracClient.Version version, String username, String password, Proxy proxy) {
        this.repositoryUrl = repositoryUrl.toString();
        this.version = version;
        this.location = null;
        this.data = new TracClientData();
    }

    public AbstractTracClient(AbstractWebLocation location, ITracClient.Version version) {
        this.location = location;
        this.version = version;
        this.repositoryUrl = location.getUrl();
        this.data = new TracClientData();
    }

    public ITracClient.Version getVersion() {
        return this.version;
    }

    protected boolean credentialsValid(AuthenticationCredentials credentials) {
        return credentials != null && credentials.getUserName().length() > 0;
    }

    protected void authenticateAccountManager(HttpClient httpClient, AuthenticationCredentials credentials) throws IOException, TracLoginException {
        PostMethod post = new PostMethod(WebClientUtil.getRequestPath((String)(String.valueOf(this.repositoryUrl) + "/login")));
        post.setFollowRedirects(false);
        NameValuePair[] data = new NameValuePair[]{new NameValuePair("referer", ""), new NameValuePair("user", credentials.getUserName()), new NameValuePair("password", credentials.getPassword())};
        post.setRequestBody(data);
        try {
            int code = httpClient.executeMethod((HttpMethod)post);
            if (code == 200) {
                throw new TracLoginException();
            }
        }
        finally {
            post.releaseConnection();
        }
    }

    protected void validateAuthenticationState(HttpClient httpClient) throws TracLoginException {
        Cookie[] cookies;
        Cookie[] cookieArray = cookies = httpClient.getState().getCookies();
        int n = cookies.length;
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie = cookieArray[n2];
            if (LOGIN_COOKIE_NAME.equals(cookie.getName())) {
                return;
            }
            ++n2;
        }
        throw new TracLoginException();
    }

    public TracComponent[] getComponents() {
        return this.data.components != null ? this.data.components.toArray(new TracComponent[0]) : null;
    }

    public TracMilestone[] getMilestones() {
        return this.data.milestones != null ? this.data.milestones.toArray(new TracMilestone[0]) : null;
    }

    public TracPriority[] getPriorities() {
        return this.data.priorities != null ? this.data.priorities.toArray(new TracPriority[0]) : null;
    }

    public TracSeverity[] getSeverities() {
        return this.data.severities != null ? this.data.severities.toArray(new TracSeverity[0]) : null;
    }

    public TracTicketField[] getTicketFields() {
        return this.data.ticketFields != null ? this.data.ticketFields.toArray(new TracTicketField[0]) : null;
    }

    public TracTicketResolution[] getTicketResolutions() {
        return this.data.ticketResolutions != null ? this.data.ticketResolutions.toArray(new TracTicketResolution[0]) : null;
    }

    public TracTicketStatus[] getTicketStatus() {
        return this.data.ticketStatus != null ? this.data.ticketStatus.toArray(new TracTicketStatus[0]) : null;
    }

    public TracTicketType[] getTicketTypes() {
        return this.data.ticketTypes != null ? this.data.ticketTypes.toArray(new TracTicketType[0]) : null;
    }

    public TracVersion[] getVersions() {
        return this.data.versions != null ? this.data.versions.toArray(new TracVersion[0]) : null;
    }

    public boolean hasAttributes() {
        return this.data.lastUpdate != 0L;
    }

    public void updateAttributes(IProgressMonitor monitor, boolean force) throws TracException {
        if (!this.hasAttributes() || force) {
            this.updateAttributes(monitor);
            this.data.lastUpdate = System.currentTimeMillis();
        }
    }

    public abstract void updateAttributes(IProgressMonitor var1) throws TracException;

    public void setData(TracClientData data) {
        this.data = data;
    }

    public String[] getDefaultTicketResolutions() {
        return new String[]{"fixed", "invalid", "wontfix", "duplicate", "worksforme"};
    }

    public String[] getDefaultTicketActions(String status) {
        if ("new".equals(status)) {
            return new String[]{"leave", "resolve", "reassign", "accept"};
        }
        if ("assigned".equals(status)) {
            return new String[]{"leave", "resolve", "reassign"};
        }
        if ("reopened".equals(status)) {
            return new String[]{"leave", "resolve", "reassign"};
        }
        if ("closed".equals(status)) {
            return new String[]{"leave", "reopen"};
        }
        return null;
    }
}

