/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.internal.trac.core.ITracClient;
import org.eclipse.mylyn.internal.trac.core.TracClientData;
import org.eclipse.mylyn.internal.trac.core.TracClientFactory;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.tasks.core.ITaskRepositoryListener;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;
import org.eclipse.mylyn.web.core.AbstractWebLocation;

public class TracClientManager
implements ITaskRepositoryListener {
    private Map<String, ITracClient> clientByUrl = new HashMap<String, ITracClient>();
    private Map<String, TracClientData> clientDataByUrl = new HashMap<String, TracClientData>();
    private File cacheFile;
    private TaskRepositoryLocationFactory taskRepositoryLocationFactory;

    public TracClientManager(File cacheFile, TaskRepositoryLocationFactory taskRepositoryLocationFactory) {
        this.cacheFile = cacheFile;
        this.taskRepositoryLocationFactory = taskRepositoryLocationFactory;
        this.readCache();
    }

    public synchronized ITracClient getRepository(TaskRepository taskRepository) {
        ITracClient repository = this.clientByUrl.get(taskRepository.getUrl());
        if (repository == null) {
            AbstractWebLocation location = this.taskRepositoryLocationFactory.createWebLocation(taskRepository);
            repository = TracClientFactory.createClient(location, ITracClient.Version.fromVersion(taskRepository.getVersion()));
            this.clientByUrl.put(taskRepository.getUrl(), repository);
            TracClientData data = this.clientDataByUrl.get(taskRepository.getUrl());
            if (data == null) {
                data = new TracClientData();
                this.clientDataByUrl.put(taskRepository.getUrl(), data);
            }
            repository.setData(data);
        }
        return repository;
    }

    public void repositoriesRead() {
    }

    public synchronized void repositoryAdded(TaskRepository repository) {
        this.clientByUrl.remove(repository.getUrl());
        this.clientDataByUrl.remove(repository.getUrl());
    }

    public synchronized void repositoryRemoved(TaskRepository repository) {
        this.clientByUrl.remove(repository.getUrl());
        this.clientDataByUrl.remove(repository.getUrl());
    }

    public synchronized void repositorySettingsChanged(TaskRepository repository) {
        this.clientByUrl.remove(repository.getUrl());
    }

    public void readCache() {
        block17: {
            if (this.cacheFile == null || !this.cacheFile.exists()) {
                return;
            }
            ObjectInputStream in = null;
            try {
                try {
                    in = new ObjectInputStream(new FileInputStream(this.cacheFile));
                    int size = in.readInt();
                    int i = 0;
                    while (i < size) {
                        String url = (String)in.readObject();
                        TracClientData data = (TracClientData)in.readObject();
                        if (url != null && data != null) {
                            this.clientDataByUrl.put(url, data);
                        }
                        ++i;
                    }
                }
                catch (Throwable e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.trac.core", "The Trac respository configuration cache could not be read", e));
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block17;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void writeCache() {
        block16: {
            if (this.cacheFile == null) {
                return;
            }
            ObjectOutputStream out = null;
            try {
                try {
                    out = new ObjectOutputStream(new FileOutputStream(this.cacheFile));
                    out.writeInt(this.clientDataByUrl.size());
                    for (String url : this.clientDataByUrl.keySet()) {
                        out.writeObject(url);
                        out.writeObject(this.clientDataByUrl.get(url));
                    }
                }
                catch (IOException e) {
                    StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.trac.core", "The Trac respository configuration cache could not be written", (Throwable)e));
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block16;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public TaskRepositoryLocationFactory getTaskRepositoryLocationFactory() {
        return this.taskRepositoryLocationFactory;
    }

    public void setTaskRepositoryLocationFactory(TaskRepositoryLocationFactory taskRepositoryLocationFactory) {
        this.taskRepositoryLocationFactory = taskRepositoryLocationFactory;
    }
}

