/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.mylyn.internal.trac.core.AbstractTracClient;
import org.eclipse.mylyn.internal.trac.core.ITracClient;
import org.eclipse.mylyn.internal.trac.core.InvalidTicketException;
import org.eclipse.mylyn.internal.trac.core.TracException;
import org.eclipse.mylyn.internal.trac.core.TracLoginException;
import org.eclipse.mylyn.internal.trac.core.model.TracComponent;
import org.eclipse.mylyn.internal.trac.core.model.TracMilestone;
import org.eclipse.mylyn.internal.trac.core.model.TracPriority;
import org.eclipse.mylyn.internal.trac.core.model.TracSearch;
import org.eclipse.mylyn.internal.trac.core.model.TracSearchFilter;
import org.eclipse.mylyn.internal.trac.core.model.TracSeverity;
import org.eclipse.mylyn.internal.trac.core.model.TracTicket;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketResolution;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketStatus;
import org.eclipse.mylyn.internal.trac.core.model.TracTicketType;
import org.eclipse.mylyn.internal.trac.core.model.TracVersion;
import org.eclipse.mylyn.internal.trac.core.util.TracHttpClientTransportFactory;
import org.eclipse.mylyn.internal.trac.core.util.TracUtils;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.web.core.AbstractWebLocation;
import org.eclipse.mylyn.web.core.AuthenticationCredentials;
import org.eclipse.mylyn.web.core.AuthenticationType;
import org.eclipse.mylyn.web.core.HtmlStreamTokenizer;
import org.eclipse.mylyn.web.core.HtmlTag;
import org.eclipse.mylyn.web.core.WebClientUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TracWebClient
extends AbstractTracClient {
    private final HttpClient httpClient = new HttpClient();
    private boolean authenticated;

    public TracWebClient(AbstractWebLocation location, ITracClient.Version version) {
        super(location, version);
        this.httpClient.setHttpConnectionManager((HttpConnectionManager)new MultiThreadedHttpConnectionManager());
        this.httpClient.getParams().setCookiePolicy("rfc2109");
    }

    private synchronized GetMethod connect(String serverURL) throws TracException {
        return this.connect(serverURL, DEFAULT_MONITOR);
    }

    private synchronized GetMethod connect(String serverURL, IProgressMonitor monitor) throws TracException {
        try {
            return this.connectInternal(serverURL, monitor);
        }
        catch (TracException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TracException(e);
        }
    }

    private GetMethod connectInternal(String serverURL, IProgressMonitor monitor) throws TracLoginException, IOException, TracHttpClientTransportFactory.TracHttpException {
        WebClientUtil.setupHttpClient((HttpClient)this.httpClient, (String)"TracConnector", (AbstractWebLocation)this.location);
        int attempt = 0;
        while (attempt < 2) {
            int code;
            AuthenticationCredentials credentials;
            if (!this.authenticated && this.credentialsValid(credentials = this.location.getCredentials(AuthenticationType.REPOSITORY))) {
                this.authenticate(monitor);
            }
            GetMethod method = new GetMethod(WebClientUtil.getRequestPath((String)serverURL));
            try {
                code = this.httpClient.executeMethod((HttpMethod)method);
            }
            catch (IOException e) {
                method.releaseConnection();
                throw e;
            }
            if (code == 200) {
                return method;
            }
            if (code != 401 && code != 403) {
                throw new TracHttpClientTransportFactory.TracHttpException(code);
            }
            method.releaseConnection();
            this.authenticated = false;
            this.authenticate(monitor);
            ++attempt;
        }
        throw new TracLoginException();
    }

    private void authenticate(IProgressMonitor monitor) throws TracLoginException, IOException {
        int code;
        AuthenticationCredentials credentials;
        while (true) {
            if (!this.credentialsValid(credentials = this.location.getCredentials(AuthenticationType.REPOSITORY))) {
                throw new TracLoginException();
            }
            AuthScope authScope = new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM);
            this.httpClient.getState().setCredentials(authScope, WebClientUtil.getHttpClientCredentials((AuthenticationCredentials)credentials, (String)WebClientUtil.getDomain((String)this.repositoryUrl)));
            GetMethod method = new GetMethod(WebClientUtil.getRequestPath((String)(String.valueOf(this.repositoryUrl) + "/login")));
            method.setFollowRedirects(false);
            try {
                this.httpClient.getParams().setAuthenticationPreemptive(true);
                code = this.httpClient.executeMethod((HttpMethod)method);
                if (!this.needsReauthentication(code)) break;
                continue;
            }
            finally {
                method.releaseConnection();
                this.httpClient.getParams().setAuthenticationPreemptive(false);
                continue;
            }
            break;
        }
        if (code == 200) {
            this.authenticateAccountManager(this.httpClient, credentials);
        }
        this.validateAuthenticationState(this.httpClient);
        this.authenticated = true;
    }

    private boolean needsReauthentication(int code) throws IOException, TracLoginException {
        AuthenticationType authenticationType;
        if (code == 401 || code == 403) {
            authenticationType = AuthenticationType.REPOSITORY;
        } else if (code == 407) {
            authenticationType = AuthenticationType.PROXY;
        } else {
            return false;
        }
        if (this.location.requestCredentials(authenticationType, null) == AbstractWebLocation.ResultType.NOT_SUPPORTED) {
            throw new TracLoginException();
        }
        WebClientUtil.setupHttpClient((HttpClient)this.httpClient, (String)"TracConnector", (AbstractWebLocation)this.location);
        return true;
    }

    @Override
    public TracTicket getTicket(int id) throws TracException {
        GetMethod method = this.connect(String.valueOf(this.repositoryUrl) + "/ticket/" + id);
        try {
            TracTicket ticket = new TracTicket(id);
            BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF-8"));
            HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer((Reader)reader, null);
            HtmlStreamTokenizer.Token token = tokenizer.nextToken();
            while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                if (token.getType() == HtmlStreamTokenizer.Token.TAG) {
                    String text;
                    String clazz;
                    HtmlTag tag = (HtmlTag)token.getValue();
                    if (tag.getTagType() == HtmlTag.Type.TD) {
                        String headers = tag.getAttribute("headers");
                        if ("h_component".equals(headers)) {
                            ticket.putBuiltinValue(TracTicket.Key.COMPONENT, this.getText(tokenizer));
                        } else if ("h_milestone".equals(headers)) {
                            ticket.putBuiltinValue(TracTicket.Key.MILESTONE, this.getText(tokenizer));
                        } else if ("h_priority".equals(headers)) {
                            ticket.putBuiltinValue(TracTicket.Key.PRIORITY, this.getText(tokenizer));
                        } else if ("h_severity".equals(headers)) {
                            ticket.putBuiltinValue(TracTicket.Key.SEVERITY, this.getText(tokenizer));
                        } else if ("h_version".equals(headers)) {
                            ticket.putBuiltinValue(TracTicket.Key.VERSION, this.getText(tokenizer));
                        } else if ("h_keywords".equals(headers)) {
                            ticket.putBuiltinValue(TracTicket.Key.KEYWORDS, this.getText(tokenizer));
                        } else if ("h_cc".equals(headers)) {
                            ticket.putBuiltinValue(TracTicket.Key.CC, this.getText(tokenizer));
                        } else if ("h_owner".equals(headers)) {
                            ticket.putBuiltinValue(TracTicket.Key.OWNER, this.getText(tokenizer));
                        } else if ("h_reporter".equals(headers)) {
                            ticket.putBuiltinValue(TracTicket.Key.REPORTER, this.getText(tokenizer));
                        }
                    } else if (tag.getTagType() == HtmlTag.Type.H2 && "summary".equals(tag.getAttribute("class"))) {
                        ticket.putBuiltinValue(TracTicket.Key.SUMMARY, this.getText(tokenizer));
                    } else if (tag.getTagType() == HtmlTag.Type.H3 && "status".equals(tag.getAttribute("class"))) {
                        String text2 = this.getStrongText(tokenizer);
                        if (text2.length() > 0) {
                            int i = text2.indexOf(" (");
                            if (i != -1) {
                                ticket.putBuiltinValue(TracTicket.Key.STATUS, text2.substring(0, i));
                                ticket.putBuiltinValue(TracTicket.Key.RESOLUTION, text2.substring(i + 2, text2.length() - 1));
                            } else {
                                ticket.putBuiltinValue(TracTicket.Key.STATUS, text2);
                            }
                        }
                    } else if (tag.getTagType() == HtmlTag.Type.SPAN && "status".equals(clazz = tag.getAttribute("class")) && (text = this.getText(tokenizer)).startsWith("(") && text.endsWith(")")) {
                        StringTokenizer t = new StringTokenizer(text.substring(1, text.length() - 1), " :");
                        if (t.hasMoreTokens()) {
                            ticket.putBuiltinValue(TracTicket.Key.STATUS, t.nextToken());
                        }
                        if (t.hasMoreTokens()) {
                            ticket.putBuiltinValue(TracTicket.Key.TYPE, t.nextToken());
                        }
                        if (t.hasMoreTokens()) {
                            ticket.putBuiltinValue(TracTicket.Key.RESOLUTION, t.nextToken());
                        }
                    }
                }
                token = tokenizer.nextToken();
            }
            if (ticket.isValid() && ticket.getValue(TracTicket.Key.SUMMARY) != null) {
                TracTicket tracTicket = ticket;
                return tracTicket;
            }
            try {
                throw new InvalidTicketException();
            }
            catch (IOException e) {
                throw new TracException(e);
            }
            catch (ParseException e) {
                throw new TracException(e);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public void search(TracSearch query, List<TracTicket> tickets) throws TracException {
        GetMethod method = this.connect(String.valueOf(this.repositoryUrl) + "/query?format=tab" + query.toUrl());
        try {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF-8"));
                Map<String, String> constantValues = this.getExactMatchValues(query);
                String line = reader.readLine();
                if (line == null) {
                    throw new InvalidTicketException();
                }
                StringTokenizer t = new StringTokenizer(line, "\t");
                TracTicket.Key[] fields = new TracTicket.Key[t.countTokens()];
                int i = 0;
                while (i < fields.length) {
                    fields[i] = TracTicket.Key.fromKey(t.nextToken());
                    ++i;
                }
                while ((line = reader.readLine()) != null) {
                    t = new StringTokenizer(line, "\t");
                    TracTicket ticket = new TracTicket();
                    int i2 = 0;
                    while (i2 < fields.length && t.hasMoreTokens()) {
                        if (fields[i2] != null) {
                            try {
                                if (fields[i2] == TracTicket.Key.ID) {
                                    ticket.setId(Integer.parseInt(t.nextToken()));
                                } else if (fields[i2] == TracTicket.Key.TIME) {
                                    ticket.setCreated(TracUtils.parseDate(Integer.parseInt(t.nextToken())));
                                } else if (fields[i2] == TracTicket.Key.CHANGE_TIME) {
                                    ticket.setLastChanged(TracUtils.parseDate(Integer.parseInt(t.nextToken())));
                                } else {
                                    ticket.putBuiltinValue(fields[i2], this.parseTicketValue(t.nextToken()));
                                }
                            }
                            catch (NumberFormatException e) {
                                StatusHandler.log((Throwable)e, (String)("Error parsing response: " + line));
                            }
                        }
                        ++i2;
                    }
                    if (!ticket.isValid()) continue;
                    for (String key : constantValues.keySet()) {
                        ticket.putValue(key, this.parseTicketValue(constantValues.get(key)));
                    }
                    tickets.add(ticket);
                }
            }
            catch (IOException e) {
                throw new TracException(e);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    private String parseTicketValue(String value) {
        if ("--".equals(value)) {
            return "";
        }
        return value;
    }

    private Map<String, String> getExactMatchValues(TracSearch query) {
        HashMap<String, String> values = new HashMap<String, String>();
        List<TracSearchFilter> filters = query.getFilters();
        for (TracSearchFilter filter : filters) {
            if (filter.getOperator() != TracSearchFilter.CompareOperator.IS || filter.getValues().size() != 1) continue;
            values.put(filter.getFieldName(), filter.getValues().get(0));
        }
        return values;
    }

    @Override
    public void validate(IProgressMonitor monitor) throws TracException {
        GetMethod method = this.connect(String.valueOf(this.repositoryUrl) + "/", monitor);
        try {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF-8"));
                boolean inFooter = false;
                boolean valid = false;
                String version = null;
                HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer((Reader)reader, null);
                HtmlStreamTokenizer.Token token = tokenizer.nextToken();
                while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                    if (token.getType() == HtmlStreamTokenizer.Token.TAG) {
                        String id;
                        HtmlTag tag = (HtmlTag)token.getValue();
                        if (tag.getTagType() == HtmlTag.Type.DIV) {
                            id = tag.getAttribute("id");
                            inFooter = !tag.isEndTag() && "footer".equals(id);
                        } else if (tag.getTagType() == HtmlTag.Type.STRONG && inFooter) {
                            version = this.getText(tokenizer);
                        } else if (tag.getTagType() == HtmlTag.Type.A && "tracpowered".equals(id = tag.getAttribute("id"))) {
                            valid = true;
                        }
                    }
                    token = tokenizer.nextToken();
                }
                if (version != null && !version.startsWith("Trac 0.9") && !version.startsWith("Trac 0.10")) {
                    throw new TracException("The Trac version " + version + " is unsupported. Please use version 0.9.x or 0.10.x.");
                }
                if (!valid) {
                    throw new TracException("Not a valid Trac repository");
                }
            }
            catch (IOException e) {
                throw new TracException(e);
            }
            catch (ParseException e) {
                throw new TracException(e);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public void updateAttributes(IProgressMonitor monitor) throws TracException {
        monitor.beginTask("Updating attributes", -1);
        GetMethod method = this.connect(String.valueOf(this.repositoryUrl) + "/query");
        try {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF-8"));
                HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer((Reader)reader, null);
                HtmlStreamTokenizer.Token token = tokenizer.nextToken();
                while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                    String text;
                    HtmlTag tag;
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (token.getType() == HtmlStreamTokenizer.Token.TAG && (tag = (HtmlTag)token.getValue()).getTagType() == HtmlTag.Type.SCRIPT && (text = this.getText(tokenizer).trim()).startsWith("var properties=")) {
                        this.parseAttributes(text);
                    }
                    token = tokenizer.nextToken();
                }
                this.addResolutionAndStatus();
            }
            catch (IOException e) {
                throw new TracException(e);
            }
            catch (ParseException e) {
                throw new TracException(e);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    private void parseAttributes(String text) throws IOException {
        int tokenType;
        StreamTokenizer t = new StreamTokenizer(new StringReader(text));
        t.quoteChar(34);
        AttributeFactory attributeFactory = null;
        String attributeType = null;
        AttributeState state = AttributeState.INIT;
        block10: while ((tokenType = t.nextToken()) != -1) {
            switch (tokenType) {
                case -3: {
                    if (state == AttributeState.IN_LIST) {
                        if ("component".equals(t.sval)) {
                            this.data.components = new ArrayList<TracComponent>();
                            attributeFactory = new AttributeFactory(){

                                public void addAttribute(String value) {
                                    TracWebClient.this.data.components.add(new TracComponent(value));
                                }
                            };
                            break;
                        }
                        if ("milestone".equals(t.sval)) {
                            this.data.milestones = new ArrayList<TracMilestone>();
                            attributeFactory = new AttributeFactory(){

                                public void addAttribute(String value) {
                                    TracWebClient.this.data.milestones.add(new TracMilestone(value));
                                }
                            };
                            break;
                        }
                        if ("priority".equals(t.sval)) {
                            this.data.priorities = new ArrayList<TracPriority>();
                            attributeFactory = new AttributeFactory(){

                                public void addAttribute(String value) {
                                    TracWebClient.this.data.priorities.add(new TracPriority(value, TracWebClient.this.data.priorities.size() + 1));
                                }
                            };
                            break;
                        }
                        if ("resolution".equals(t.sval)) {
                            this.data.ticketResolutions = new ArrayList<TracTicketResolution>();
                            attributeFactory = new AttributeFactory(){

                                public void addAttribute(String value) {
                                    TracWebClient.this.data.ticketResolutions.add(new TracTicketResolution(value, TracWebClient.this.data.ticketResolutions.size() + 1));
                                }
                            };
                            break;
                        }
                        if ("severity".equals(t.sval)) {
                            this.data.severities = new ArrayList<TracSeverity>();
                            attributeFactory = new AttributeFactory(){

                                public void addAttribute(String value) {
                                    TracWebClient.this.data.severities.add(new TracSeverity(value, TracWebClient.this.data.severities.size() + 1));
                                }
                            };
                            break;
                        }
                        if ("status".equals(t.sval)) {
                            this.data.ticketStatus = new ArrayList<TracTicketStatus>();
                            attributeFactory = new AttributeFactory(){

                                public void addAttribute(String value) {
                                    TracWebClient.this.data.ticketStatus.add(new TracTicketStatus(value, TracWebClient.this.data.ticketStatus.size() + 1));
                                }
                            };
                            break;
                        }
                        if ("type".equals(t.sval)) {
                            this.data.ticketTypes = new ArrayList<TracTicketType>();
                            attributeFactory = new AttributeFactory(){

                                public void addAttribute(String value) {
                                    TracWebClient.this.data.ticketTypes.add(new TracTicketType(value, TracWebClient.this.data.ticketTypes.size() + 1));
                                }
                            };
                            break;
                        }
                        if ("version".equals(t.sval)) {
                            this.data.versions = new ArrayList<TracVersion>();
                            attributeFactory = new AttributeFactory(){

                                public void addAttribute(String value) {
                                    TracWebClient.this.data.versions.add(new TracVersion(value));
                                }
                            };
                            break;
                        }
                        attributeFactory = null;
                        break;
                    }
                    if (state != AttributeState.IN_ATTRIBUTE_KEY) break;
                    attributeType = t.sval;
                    break;
                }
                case 34: {
                    if (state != AttributeState.IN_ATTRIBUTE_VALUE_LIST || !"options".equals(attributeType) || attributeFactory == null) continue block10;
                    attributeFactory.addAttribute(t.sval);
                    break;
                }
                case 58: {
                    if (state != AttributeState.IN_ATTRIBUTE_KEY) break;
                    state = AttributeState.IN_ATTRIBUTE_VALUE;
                    break;
                }
                case 44: {
                    if (state != AttributeState.IN_ATTRIBUTE_VALUE) break;
                    state = AttributeState.IN_ATTRIBUTE_KEY;
                    break;
                }
                case 91: {
                    if (state != AttributeState.IN_ATTRIBUTE_VALUE) break;
                    state = AttributeState.IN_ATTRIBUTE_VALUE_LIST;
                    break;
                }
                case 93: {
                    if (state != AttributeState.IN_ATTRIBUTE_VALUE_LIST) break;
                    state = AttributeState.IN_ATTRIBUTE_VALUE;
                    break;
                }
                case 123: {
                    if (state == AttributeState.INIT) {
                        state = AttributeState.IN_LIST;
                        break;
                    }
                    if (state == AttributeState.IN_LIST) {
                        state = AttributeState.IN_ATTRIBUTE_KEY;
                        break;
                    }
                    throw new IOException("Error parsing attributes: unexpected token '{'");
                }
                case 125: {
                    if (state == AttributeState.IN_ATTRIBUTE_KEY || state == AttributeState.IN_ATTRIBUTE_VALUE) {
                        state = AttributeState.IN_LIST;
                        break;
                    }
                    if (state == AttributeState.IN_LIST) {
                        state = AttributeState.INIT;
                        break;
                    }
                    throw new IOException("Error parsing attributes: unexpected token '}'");
                }
            }
        }
    }

    public void updateAttributesNewTicketPage(IProgressMonitor monitor) throws TracException {
        monitor.beginTask("Updating attributes", -1);
        GetMethod method = this.connect(String.valueOf(this.repositoryUrl) + "/newticket");
        try {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(method.getResponseBodyAsStream(), "UTF-8"));
                HtmlStreamTokenizer tokenizer = new HtmlStreamTokenizer((Reader)reader, null);
                HtmlStreamTokenizer.Token token = tokenizer.nextToken();
                while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
                    HtmlTag tag;
                    if (monitor.isCanceled()) {
                        throw new OperationCanceledException();
                    }
                    if (token.getType() == HtmlStreamTokenizer.Token.TAG && (tag = (HtmlTag)token.getValue()).getTagType() == HtmlTag.Type.SELECT) {
                        List<String> values;
                        String name = tag.getAttribute("id");
                        if ("component".equals(name)) {
                            values = this.getOptionValues(tokenizer);
                            this.data.components = new ArrayList<TracComponent>(values.size());
                            for (String value : values) {
                                this.data.components.add(new TracComponent(value));
                            }
                        } else if ("milestone".equals(name)) {
                            values = this.getOptionValues(tokenizer);
                            this.data.milestones = new ArrayList<TracMilestone>(values.size());
                            for (String value : values) {
                                this.data.milestones.add(new TracMilestone(value));
                            }
                        } else if ("priority".equals(name)) {
                            values = this.getOptionValues(tokenizer);
                            this.data.priorities = new ArrayList<TracPriority>(values.size());
                            int i = 0;
                            while (i < values.size()) {
                                this.data.priorities.add(new TracPriority(values.get(i), i + 1));
                                ++i;
                            }
                        } else if ("severity".equals(name)) {
                            values = this.getOptionValues(tokenizer);
                            this.data.severities = new ArrayList<TracSeverity>(values.size());
                            int i = 0;
                            while (i < values.size()) {
                                this.data.severities.add(new TracSeverity(values.get(i), i + 1));
                                ++i;
                            }
                        } else if ("type".equals(name)) {
                            values = this.getOptionValues(tokenizer);
                            this.data.ticketTypes = new ArrayList<TracTicketType>(values.size());
                            int i = 0;
                            while (i < values.size()) {
                                this.data.ticketTypes.add(new TracTicketType(values.get(i), i + 1));
                                ++i;
                            }
                        } else if ("version".equals(name)) {
                            values = this.getOptionValues(tokenizer);
                            this.data.versions = new ArrayList<TracVersion>(values.size());
                            for (String value : values) {
                                this.data.versions.add(new TracVersion(value));
                            }
                        }
                    }
                    token = tokenizer.nextToken();
                }
                this.addResolutionAndStatus();
            }
            catch (IOException e) {
                throw new TracException(e);
            }
            catch (ParseException e) {
                throw new TracException(e);
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    private void addResolutionAndStatus() {
        this.data.ticketResolutions = new ArrayList<TracTicketResolution>(5);
        this.data.ticketResolutions.add(new TracTicketResolution("fixed", 1));
        this.data.ticketResolutions.add(new TracTicketResolution("invalid", 2));
        this.data.ticketResolutions.add(new TracTicketResolution("wontfix", 3));
        this.data.ticketResolutions.add(new TracTicketResolution("duplicate", 4));
        this.data.ticketResolutions.add(new TracTicketResolution("worksforme", 5));
        this.data.ticketStatus = new ArrayList<TracTicketStatus>(4);
        this.data.ticketStatus.add(new TracTicketStatus("new", 1));
        this.data.ticketStatus.add(new TracTicketStatus("assigned", 2));
        this.data.ticketStatus.add(new TracTicketStatus("reopened", 3));
        this.data.ticketStatus.add(new TracTicketStatus("closed", 4));
    }

    private List<String> getOptionValues(HtmlStreamTokenizer tokenizer) throws IOException, ParseException {
        ArrayList<String> values = new ArrayList<String>();
        HtmlStreamTokenizer.Token token = tokenizer.nextToken();
        while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
            if (token.getType() == HtmlStreamTokenizer.Token.TAG) {
                HtmlTag tag = (HtmlTag)token.getValue();
                if (tag.getTagType() == HtmlTag.Type.OPTION && !tag.isEndTag()) {
                    String value = this.getText(tokenizer).trim();
                    if (value.length() > 0) {
                        values.add(value);
                    }
                } else {
                    return values;
                }
            }
            token = tokenizer.nextToken();
        }
        return values;
    }

    private String getText(HtmlStreamTokenizer tokenizer) throws IOException, ParseException {
        StringBuffer sb = new StringBuffer();
        HtmlStreamTokenizer.Token token = tokenizer.nextToken();
        while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
            if (token.getType() == HtmlStreamTokenizer.Token.TEXT) {
                sb.append(token.toString());
            } else if (token.getType() != HtmlStreamTokenizer.Token.COMMENT) break;
            token = tokenizer.nextToken();
        }
        return HtmlStreamTokenizer.unescape((StringBuffer)sb).toString();
    }

    private String getStrongText(HtmlStreamTokenizer tokenizer) throws IOException, ParseException {
        HtmlStreamTokenizer.Token token = tokenizer.nextToken();
        while (token.getType() != HtmlStreamTokenizer.Token.EOF) {
            if (token.getType() == HtmlStreamTokenizer.Token.TAG && ((HtmlTag)token.getValue()).getTagType() == HtmlTag.Type.STRONG) {
                return this.getText(tokenizer);
            }
            if (token.getType() != HtmlStreamTokenizer.Token.COMMENT && token.getType() != HtmlStreamTokenizer.Token.TEXT) break;
            token = tokenizer.nextToken();
        }
        return "";
    }

    @Override
    public InputStream getAttachmentData(int id, String filename) throws TracException {
        GetMethod method = this.connect(String.valueOf(this.repositoryUrl) + "/attachment/ticket/" + id + "/" + filename + "?format=raw");
        try {
            return method.getResponseBodyAsStream();
        }
        catch (IOException e) {
            method.releaseConnection();
            throw new TracException(e);
        }
    }

    @Override
    public void putAttachmentData(int id, String name, String description, InputStream in) throws TracException {
        throw new TracException("Unsupported operation");
    }

    @Override
    public void deleteAttachment(int ticketId, String filename) throws TracException {
        throw new TracException("Unsupported operation");
    }

    @Override
    public int createTicket(TracTicket ticket) throws TracException {
        throw new TracException("Unsupported operation");
    }

    @Override
    public void updateTicket(TracTicket ticket, String comment) throws TracException {
        throw new TracException("Unsupported operation");
    }

    @Override
    public Set<Integer> getChangedTickets(Date since) throws TracException {
        return null;
    }

    @Override
    public Date getTicketLastChanged(Integer id) {
        throw new UnsupportedOperationException();
    }

    private static interface AttributeFactory {
        public void addAttribute(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum AttributeState {
        INIT,
        IN_LIST,
        IN_ATTRIBUTE_KEY,
        IN_ATTRIBUTE_VALUE,
        IN_ATTRIBUTE_VALUE_LIST;

    }
}

