/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.core.util;

import java.io.InputStream;
import java.lang.reflect.Field;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientException;
import org.apache.xmlrpc.client.XmlRpcCommonsTransport;
import org.apache.xmlrpc.client.XmlRpcHttpClientConfig;
import org.apache.xmlrpc.client.XmlRpcTransport;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;
import org.eclipse.mylyn.web.core.AbstractWebLocation;
import org.eclipse.mylyn.web.core.WebClientUtil;

public class TracHttpClientTransportFactory
implements XmlRpcTransportFactory {
    protected static final String USER_AGENT = "TracConnector Apache XML-RPC/3.0";
    private XmlRpcClient client;
    private Cookie[] cookies;
    private AbstractWebLocation location;

    public TracHttpClientTransportFactory(XmlRpcClient client) {
        this.client = client;
    }

    public XmlRpcTransport getTransport() {
        return new TracHttpClientTransport(this.client, this.location, this.cookies);
    }

    public Cookie[] getCookies() {
        return this.cookies;
    }

    public void setCookies(Cookie[] cookies) {
        this.cookies = cookies;
    }

    public void setLocation(AbstractWebLocation location) {
        this.location = location;
    }

    public AbstractWebLocation getLocation() {
        return this.location;
    }

    public static class TracHttpClientTransport
    extends XmlRpcCommonsTransport {
        private AbstractWebLocation location;
        private Cookie[] cookies;

        public TracHttpClientTransport(XmlRpcClient client, AbstractWebLocation location, Cookie[] cookies) {
            super(client);
            this.location = location;
            this.cookies = cookies;
            XmlRpcHttpClientConfig config = (XmlRpcHttpClientConfig)client.getConfig();
            this.getHttpClient().getParams().setAuthenticationPreemptive(config.getBasicUserName() != null);
        }

        protected String getUserAgent() {
            return WebClientUtil.USER_AGENT;
        }

        public HttpClient getHttpClient() {
            return (HttpClient)this.getValue("client");
        }

        public PostMethod getMethod() {
            return (PostMethod)this.getValue("method");
        }

        public void setMethod(PostMethod method) {
            this.setValue("method", method);
        }

        private Object getValue(String name) {
            try {
                Field field = XmlRpcCommonsTransport.class.getDeclaredField(name);
                field.setAccessible(true);
                return field.get((Object)this);
            }
            catch (Throwable t) {
                throw new RuntimeException("Internal error accessing field: " + name, t);
            }
        }

        private void setValue(String name, Object value) {
            try {
                Field field = XmlRpcCommonsTransport.class.getDeclaredField(name);
                field.setAccessible(true);
                field.set((Object)this, value);
            }
            catch (Throwable t) {
                throw new RuntimeException("Internal error accessing field: " + name, t);
            }
        }

        protected InputStream getInputStream() throws XmlRpcException {
            int responseCode = this.getMethod().getStatusCode();
            if (responseCode != 200) {
                throw new TracHttpException(responseCode);
            }
            return super.getInputStream();
        }

        protected void initHttpHeaders(XmlRpcRequest request) throws XmlRpcClientException {
            super.initHttpHeaders(request);
            XmlRpcHttpClientConfig config = (XmlRpcHttpClientConfig)request.getConfig();
            String url = config.getServerURL().toString();
            WebClientUtil.setupHttpClient((HttpClient)this.getHttpClient(), (String)"Apache XML RPC 3.0", (AbstractWebLocation)this.location);
            if (this.cookies != null) {
                this.getHttpClient().getState().addCookies(this.cookies);
            }
            PostMethod method = new PostMethod(WebClientUtil.getRequestPath((String)url));
            this.setMethod(method);
            this.setRequestHeader("Content-Type", "text/xml");
            this.setRequestHeader("User-Agent", this.getUserAgent());
            this.setCredentials(config);
            this.setCompressionHeaders(config);
            if (config.getConnectionTimeout() != 0) {
                this.getHttpClient().getHttpConnectionManager().getParams().setConnectionTimeout(config.getConnectionTimeout());
            }
            if (config.getReplyTimeout() != 0) {
                this.getHttpClient().getHttpConnectionManager().getParams().setSoTimeout(config.getConnectionTimeout());
            }
            method.getParams().setVersion(HttpVersion.HTTP_1_1);
        }
    }

    public static class TracHttpException
    extends XmlRpcException {
        private static final long serialVersionUID = 9032521978140685830L;

        public TracHttpException(int responseCode) {
            super(responseCode, "HTTP Error " + responseCode);
        }
    }
}

