/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.ui.editor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.internal.tasks.ui.TasksUiImages;
import org.eclipse.mylyn.internal.trac.core.TracRepositoryConnector;
import org.eclipse.mylyn.internal.trac.core.TracTask;
import org.eclipse.mylyn.internal.trac.ui.editor.BrowserFormPage;
import org.eclipse.mylyn.internal.trac.ui.editor.NewTracTaskEditor;
import org.eclipse.mylyn.internal.trac.ui.editor.TracTaskEditor;
import org.eclipse.mylyn.tasks.core.AbstractTask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.ui.TasksUiPlugin;
import org.eclipse.mylyn.tasks.ui.editors.AbstractTaskEditorFactory;
import org.eclipse.mylyn.tasks.ui.editors.RepositoryTaskEditorInput;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditor;
import org.eclipse.mylyn.tasks.ui.editors.TaskEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.forms.editor.FormEditor;

public class TracTaskEditorFactory
extends AbstractTaskEditorFactory {
    private static final String TITLE = "Browser";

    public boolean canCreateEditorFor(AbstractTask task) {
        return task instanceof TracTask;
    }

    public boolean canCreateEditorFor(IEditorInput input) {
        if (input instanceof RepositoryTaskEditorInput) {
            RepositoryTaskEditorInput taskInput = (RepositoryTaskEditorInput)input;
            return taskInput.getTaskData() != null && "trac".equals(taskInput.getRepository().getConnectorKind());
        }
        if (input instanceof TaskEditorInput) {
            TaskEditorInput taskInput = (TaskEditorInput)input;
            return taskInput.getTask() instanceof TracTask;
        }
        return false;
    }

    public IEditorPart createEditor(TaskEditor parentEditor, IEditorInput editorInput) {
        if (editorInput instanceof RepositoryTaskEditorInput) {
            RepositoryTaskEditorInput taskInput = (RepositoryTaskEditorInput)editorInput;
            if (taskInput.getTaskData().isNew()) {
                return new NewTracTaskEditor((FormEditor)parentEditor);
            }
            return new TracTaskEditor((FormEditor)parentEditor);
        }
        if (editorInput instanceof TaskEditorInput) {
            TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository("trac", ((TaskEditorInput)editorInput).getTask().getRepositoryUrl());
            if (TracRepositoryConnector.hasRichEditor((TaskRepository)repository)) {
                return new TracTaskEditor((FormEditor)parentEditor);
            }
            return new BrowserFormPage((FormEditor)parentEditor, TITLE);
        }
        return null;
    }

    public IEditorInput createEditorInput(AbstractTask task) {
        TracTask tracTask = (TracTask)task;
        TaskRepository repository = TasksUiPlugin.getRepositoryManager().getRepository("trac", tracTask.getRepositoryUrl());
        if (TracRepositoryConnector.hasRichEditor((TaskRepository)repository)) {
            return new RepositoryTaskEditorInput(repository, tracTask.getTaskId(), tracTask.getUrl());
        }
        return new TaskEditorInput(task, false){

            public ImageDescriptor getImageDescriptor() {
                return TasksUiImages.BROWSER_SMALL;
            }
        };
    }

    public String getTitle() {
        return "Trac";
    }

    public boolean providesOutline() {
        return true;
    }
}

