/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.trac.ui.wizard;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mylyn.internal.trac.core.ITracClient;
import org.eclipse.mylyn.internal.trac.core.TracClientFactory;
import org.eclipse.mylyn.internal.trac.core.TracException;
import org.eclipse.mylyn.internal.trac.core.TracLoginException;
import org.eclipse.mylyn.internal.trac.core.TracPermissionDeniedException;
import org.eclipse.mylyn.tasks.core.RepositoryStatus;
import org.eclipse.mylyn.tasks.core.RepositoryTemplate;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.TaskRepositoryLocationFactory;
import org.eclipse.mylyn.tasks.ui.AbstractRepositoryConnectorUi;
import org.eclipse.mylyn.tasks.ui.wizards.AbstractRepositorySettingsPage;
import org.eclipse.mylyn.web.core.AbstractWebLocation;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

public class TracRepositorySettingsPage
extends AbstractRepositorySettingsPage {
    private static final String TITLE = "Trac Repository Settings";
    private static final String DESCRIPTION = "Example: http://trac.edgewall.org";
    private Combo accessTypeCombo;
    private ITracClient.Version[] versions;

    public TracRepositorySettingsPage(AbstractRepositoryConnectorUi repositoryUi) {
        super(TITLE, DESCRIPTION, repositoryUi);
        this.setNeedsAnonymousLogin(true);
        this.setNeedsEncoding(false);
        this.setNeedsTimeZone(false);
    }

    protected void createAdditionalControls(Composite parent) {
        for (RepositoryTemplate template : this.connector.getTemplates()) {
            this.serverUrlCombo.add(template.label);
        }
        this.serverUrlCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = TracRepositorySettingsPage.this.serverUrlCombo.getText();
                RepositoryTemplate template = TracRepositorySettingsPage.this.connector.getTemplate(text);
                if (template != null) {
                    TracRepositorySettingsPage.this.repositoryLabelEditor.setStringValue(template.label);
                    TracRepositorySettingsPage.this.setUrl(template.repositoryUrl);
                    TracRepositorySettingsPage.this.setAnonymous(template.anonymous);
                    try {
                        ITracClient.Version version = ITracClient.Version.valueOf((String)template.version);
                        TracRepositorySettingsPage.this.setTracVersion(version);
                    }
                    catch (RuntimeException runtimeException) {
                        TracRepositorySettingsPage.this.setTracVersion(ITracClient.Version.TRAC_0_9);
                    }
                    TracRepositorySettingsPage.this.getContainer().updateButtons();
                    return;
                }
            }
        });
        Label accessTypeLabel = new Label(parent, 0);
        accessTypeLabel.setText("Access Type: ");
        this.accessTypeCombo = new Combo(parent, 8);
        this.accessTypeCombo.add("Automatic (Use Validate Settings)");
        ITracClient.Version[] versionArray = this.versions = ITracClient.Version.values();
        int n = this.versions.length;
        int n2 = 0;
        while (n2 < n) {
            ITracClient.Version version = versionArray[n2];
            this.accessTypeCombo.add(version.toString());
            ++n2;
        }
        if (this.repository != null) {
            this.setTracVersion(ITracClient.Version.fromVersion((String)this.repository.getVersion()));
        } else {
            this.setTracVersion(null);
        }
        this.accessTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (TracRepositorySettingsPage.this.accessTypeCombo.getSelectionIndex() > 0) {
                    TracRepositorySettingsPage.this.setVersion(TracRepositorySettingsPage.this.versions[TracRepositorySettingsPage.this.accessTypeCombo.getSelectionIndex() - 1].name());
                }
                TracRepositorySettingsPage.this.getWizard().getContainer().updateButtons();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public boolean isPageComplete() {
        return super.isPageComplete() && this.accessTypeCombo != null && this.accessTypeCombo.getSelectionIndex() != 0;
    }

    protected boolean isValidUrl(String name) {
        if ((name.startsWith("https://") || name.startsWith("http://")) && !name.endsWith("/")) {
            try {
                new URL(name);
                return true;
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return false;
    }

    public ITracClient.Version getTracVersion() {
        if (this.accessTypeCombo.getSelectionIndex() == 0) {
            return null;
        }
        return this.versions[this.accessTypeCombo.getSelectionIndex() - 1];
    }

    public void setTracVersion(ITracClient.Version version) {
        if (version == null) {
            this.accessTypeCombo.select(0);
        } else {
            int i = this.accessTypeCombo.indexOf(version.toString());
            if (i != -1) {
                this.accessTypeCombo.select(i);
            }
            this.setVersion(version.name());
        }
    }

    protected void applyValidatorResult(AbstractRepositorySettingsPage.Validator validator) {
        super.applyValidatorResult(validator);
        if (((TracValidator)validator).getResult() != null) {
            this.setTracVersion(((TracValidator)validator).getResult());
        }
    }

    protected AbstractRepositorySettingsPage.Validator getValidator(TaskRepository repository) {
        return new TracValidator(repository, this.getTracVersion());
    }

    public class TracValidator
    extends AbstractRepositorySettingsPage.Validator {
        private final String repositoryUrl;
        private final TaskRepository taskRepository;
        private final ITracClient.Version version;
        private ITracClient.Version result;

        public TracValidator(TaskRepository taskRepository, ITracClient.Version version) {
            super((AbstractRepositorySettingsPage)TracRepositorySettingsPage.this);
            this.repositoryUrl = taskRepository.getUrl();
            this.taskRepository = taskRepository;
            this.version = version;
        }

        public void run(IProgressMonitor monitor) throws CoreException {
            try {
                this.validate(monitor);
            }
            catch (MalformedURLException malformedURLException) {
                throw new CoreException((IStatus)RepositoryStatus.createStatus((String)this.repositoryUrl, (int)4, (String)"org.eclipse.mylyn.trac.ui", (String)"Repository url is invalid."));
            }
            catch (TracLoginException tracLoginException) {
                throw new CoreException((IStatus)RepositoryStatus.createStatus((String)this.repositoryUrl, (int)4, (String)"org.eclipse.mylyn.trac.ui", (String)"Unable to authenticate with repository. Login credentials invalid."));
            }
            catch (TracPermissionDeniedException tracPermissionDeniedException) {
                throw new CoreException((IStatus)RepositoryStatus.createStatus((String)this.repositoryUrl, (int)4, (String)"org.eclipse.mylyn.trac.ui", (String)"Insufficient permissions for selected access type."));
            }
            catch (TracException e) {
                String message = "No Trac repository found at url";
                if (e.getMessage() != null) {
                    message = String.valueOf(message) + ": " + e.getMessage();
                }
                throw new CoreException((IStatus)RepositoryStatus.createStatus((String)this.repositoryUrl, (int)4, (String)"org.eclipse.mylyn.trac.ui", (String)message));
            }
        }

        public void validate(IProgressMonitor monitor) throws MalformedURLException, TracException {
            AbstractWebLocation location = new TaskRepositoryLocationFactory().createWebLocation(this.taskRepository);
            if (this.version != null) {
                ITracClient client = TracClientFactory.createClient((AbstractWebLocation)location, (ITracClient.Version)this.version);
                client.validate(monitor);
            } else {
                try {
                    ITracClient client = TracClientFactory.createClient((AbstractWebLocation)location, (ITracClient.Version)ITracClient.Version.XML_RPC);
                    client.validate(monitor);
                    this.result = ITracClient.Version.XML_RPC;
                }
                catch (TracException e) {
                    try {
                        ITracClient client = TracClientFactory.createClient((AbstractWebLocation)location, (ITracClient.Version)ITracClient.Version.TRAC_0_9);
                        client.validate(monitor);
                        this.result = ITracClient.Version.TRAC_0_9;
                        if (e instanceof TracPermissionDeniedException) {
                            this.setStatus((IStatus)RepositoryStatus.createStatus((String)this.repositoryUrl, (int)1, (String)"org.eclipse.mylyn.trac.ui", (String)"Authentication credentials are valid. Note: Insufficient permissions for XML-RPC access, falling back to web access."));
                        }
                    }
                    catch (TracLoginException tracLoginException) {
                        throw e;
                    }
                    catch (TracException tracException) {
                        throw new TracException();
                    }
                }
            }
        }

        public ITracClient.Version getResult() {
            return this.result;
        }
    }
}

