/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.viewsupport.IProblemChangedListener;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.internal.java.ui.JavaStructureBridge;
import org.eclipse.mylyn.internal.java.ui.JavaUiBridgePlugin;
import org.eclipse.mylyn.monitor.core.StatusHandler;

public class InterestInducingProblemListener
implements IProblemChangedListener,
IPropertyChangeListener {
    public static final String PREDICTED_INTEREST_ERRORS = "org.eclipse.mylyn.java.ui.interest.prediction.errors";
    private JavaStructureBridge javaStructureBridge = new JavaStructureBridge();

    public void problemsChanged(IResource[] changedResources, boolean isMarkerChange) {
        try {
            if (!ContextCorePlugin.getContextManager().isContextActive()) {
                return;
            }
            int i = 0;
            while (i < changedResources.length) {
                IJavaElement javaElement;
                IResource resource = changedResources[i];
                if (resource instanceof IFile && (javaElement = (IJavaElement)resource.getAdapter(IJavaElement.class)) != null) {
                    IInteractionElement element = ContextCorePlugin.getContextManager().getElement(javaElement.getHandleIdentifier());
                    if (!this.javaStructureBridge.containsProblem(element)) {
                        ContextCorePlugin.getContextManager().removeErrorPredictedInterest(element.getHandleIdentifier(), "java", true);
                    } else {
                        ContextCorePlugin.getContextManager().addErrorPredictedInterest(element.getHandleIdentifier(), "java", true);
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            StatusHandler.log((Throwable)e, (String)"could not update on marker change");
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (PREDICTED_INTEREST_ERRORS.equals(event.getProperty())) {
            if (JavaUiBridgePlugin.getDefault().getPreferenceStore().getBoolean(PREDICTED_INTEREST_ERRORS)) {
                this.enable();
            } else {
                this.disable();
            }
        }
    }

    public void enable() {
        JavaPlugin.getDefault().getProblemMarkerManager().addListener((IProblemChangedListener)this);
    }

    public void disable() {
        JavaPlugin.getDefault().getProblemMarkerManager().removeListener((IProblemChangedListener)this);
    }
}

