/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.OpenTypeAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaStackTraceFileHyperlink
implements IHyperlink {
    private IRegion region;
    private String traceLine;

    public JavaStackTraceFileHyperlink(IRegion region, String traceLine) {
        this.region = region;
        this.traceLine = traceLine;
    }

    public IRegion getHyperlinkRegion() {
        return this.region;
    }

    public String getHyperlinkText() {
        return null;
    }

    public String getTypeLabel() {
        return null;
    }

    public void open() {
        try {
            String editorId;
            IDebugModelPresentation presentation;
            IEditorInput editorInput;
            Object sourceElement;
            String typeName = this.getTypeName();
            int lineNumber = this.getLineNumber();
            if (lineNumber > 0) {
                --lineNumber;
            }
            if ((sourceElement = this.getSourceElement(typeName)) != null && (editorInput = (presentation = JDIDebugUIPlugin.getDefault().getModelPresentation()).getEditorInput(sourceElement)) != null && (editorId = presentation.getEditorId(editorInput, sourceElement)) != null) {
                IEditorPart editorPart = JDIDebugUIPlugin.getActivePage().openEditor(editorInput, editorId);
                if (editorPart instanceof ITextEditor && lineNumber >= 0) {
                    ITextEditor textEditor = (ITextEditor)editorPart;
                    IDocumentProvider provider = textEditor.getDocumentProvider();
                    provider.connect((Object)editorInput);
                    IDocument document = provider.getDocument((Object)editorInput);
                    try {
                        IRegion line = document.getLineInformation(lineNumber);
                        textEditor.selectAndReveal(line.getOffset(), line.getLength());
                    }
                    catch (BadLocationException badLocationException) {
                        MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Open Type", (String)"Line not found in type.");
                    }
                    provider.disconnect((Object)editorInput);
                }
                return;
            }
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Open Type", (String)"Type could not be located.");
        }
        catch (CoreException coreException) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Open Type", (String)"Failed to open type.");
            return;
        }
    }

    private Object getSourceElement(String typeName) throws CoreException {
        IType result = null;
        result = OpenTypeAction.findTypeInWorkspace((String)typeName);
        return result;
    }

    private String getTypeName() {
        int start = this.traceLine.indexOf(40);
        int end = this.traceLine.indexOf(58);
        if (start >= 0 && end > start) {
            String typeName = this.traceLine.substring(start + 1, end);
            typeName = typeName.substring(0, typeName.indexOf("."));
            String qualifier = this.traceLine.substring(0, start);
            if ((start = qualifier.lastIndexOf(46)) >= 0 && (start = qualifier.subSequence(0, start).toString().lastIndexOf(46)) == -1) {
                start = 0;
            }
            if (start >= 0) {
                qualifier = qualifier.substring(0, start);
            }
            if (qualifier.length() > 0) {
                typeName = String.valueOf(qualifier) + "." + typeName;
            }
            return typeName.trim();
        }
        return "error";
    }

    private int getLineNumber() throws CoreException {
        int index = this.traceLine.lastIndexOf(58);
        if (index >= 0) {
            String numText = this.traceLine.substring(index + 1);
            if ((index = numText.indexOf(41)) >= 0) {
                numText = numText.substring(0, index);
            }
            try {
                return Integer.parseInt(numText);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CoreException(null);
            }
        }
        throw new CoreException(null);
    }
}

