/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.java.ui;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.mylyn.context.core.ContextCorePlugin;
import org.eclipse.mylyn.context.core.IInteractionContextListener;
import org.eclipse.mylyn.internal.context.ui.AbstractContextUiPlugin;
import org.eclipse.mylyn.internal.java.ui.ActiveFoldingEditorTracker;
import org.eclipse.mylyn.internal.java.ui.InterestInducingProblemListener;
import org.eclipse.mylyn.internal.java.ui.InterestUpdateDeltaListener;
import org.eclipse.mylyn.internal.java.ui.JavaEditingMonitor;
import org.eclipse.mylyn.internal.java.ui.JavaUiUtil;
import org.eclipse.mylyn.internal.java.ui.LandmarkMarkerManager;
import org.eclipse.mylyn.internal.java.ui.TypeHistoryManager;
import org.eclipse.mylyn.internal.java.ui.editor.ActiveFoldingListener;
import org.eclipse.mylyn.monitor.core.StatusHandler;
import org.eclipse.mylyn.monitor.ui.MonitorUiPlugin;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class JavaUiBridgePlugin
extends AbstractContextUiPlugin {
    public static final String PLUGIN_ID = "org.eclipse.mylyn.java.ui";
    private static JavaUiBridgePlugin INSTANCE;
    private ResourceBundle resourceBundle;
    private ActiveFoldingEditorTracker editorTracker;
    private TypeHistoryManager typeHistoryManager = null;
    private LandmarkMarkerManager landmarkMarkerManager = new LandmarkMarkerManager();
    private InterestInducingProblemListener problemListener = new InterestInducingProblemListener();
    private JavaEditingMonitor javaEditingMonitor;
    private InterestUpdateDeltaListener javaElementChangeListener = new InterestUpdateDeltaListener();

    public JavaUiBridgePlugin() {
        INSTANCE = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.initDefaultPrefs();
        if (this.getPreferenceStore().getBoolean("org.eclipse.mylyn.ui.first.run.0_4_9")) {
            this.getPreferenceStore().setValue("org.eclipse.mylyn.ui.first.run.0_4_9", false);
            JavaUiUtil.installContentAssist(JavaPlugin.getDefault().getPreferenceStore(), true);
        }
    }

    protected void lazyStart(IWorkbench workbench) {
        ContextCorePlugin.getContextManager().addListener((IInteractionContextListener)this.landmarkMarkerManager);
        this.javaEditingMonitor = new JavaEditingMonitor();
        MonitorUiPlugin.getDefault().getSelectionMonitors().add(this.javaEditingMonitor);
        this.installEditorTracker(workbench);
        JavaCore.addElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.problemListener);
        if (this.getPreferenceStore().getBoolean("org.eclipse.mylyn.java.ui.interest.prediction.errors")) {
            this.problemListener.enable();
        }
        try {
            this.typeHistoryManager = new TypeHistoryManager();
            ContextCorePlugin.getContextManager().addListener((IInteractionContextListener)this.typeHistoryManager);
        }
        catch (Throwable t) {
            StatusHandler.log((Throwable)t, (String)"Could not install type history manager, incompatible Eclipse version.");
        }
    }

    private void initDefaultPrefs() {
        this.getPreferenceStore().setDefault("org.eclipse.mylyn.java.ui.interest.prediction.errors", false);
        this.getPreferenceStore().setDefault("org.eclipse.mylyn.ui.first.run.0_4_9", true);
    }

    protected void lazyStop() {
        ContextCorePlugin.getContextManager().removeListener((IInteractionContextListener)this.typeHistoryManager);
        ContextCorePlugin.getContextManager().removeListener((IInteractionContextListener)this.landmarkMarkerManager);
        MonitorUiPlugin.getDefault().getSelectionMonitors().remove((Object)this.javaEditingMonitor);
        JavaCore.removeElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        INSTANCE = null;
        this.resourceBundle = null;
    }

    private void installEditorTracker(IWorkbench workbench) {
        this.editorTracker = new ActiveFoldingEditorTracker();
        this.editorTracker.install(workbench);
        IWorkbenchWindow[] iWorkbenchWindowArray = PlatformUI.getWorkbench().getWorkbenchWindows();
        int n = iWorkbenchWindowArray.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchWindow w = iWorkbenchWindowArray[n2];
            IWorkbenchPage page = w.getActivePage();
            if (page != null) {
                IEditorReference[] references = page.getEditorReferences();
                int i = 0;
                while (i < references.length) {
                    IEditorPart part = references[i].getEditor(false);
                    if (part != null && part instanceof JavaEditor) {
                        JavaEditor editor = (JavaEditor)part;
                        this.editorTracker.registerEditor(editor);
                        ActiveFoldingListener.resetProjection(editor);
                    }
                    ++i;
                }
            }
            ++n2;
        }
    }

    public static JavaUiBridgePlugin getDefault() {
        return INSTANCE;
    }

    @Deprecated
    public static String getResourceString(String key) {
        ResourceBundle bundle = JavaUiBridgePlugin.getDefault().getResourceBundle();
        try {
            return bundle != null ? bundle.getString(key) : key;
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    @Deprecated
    public ResourceBundle getResourceBundle() {
        try {
            if (this.resourceBundle == null) {
                this.resourceBundle = ResourceBundle.getBundle("org.eclipse.mylyn.java.JavaPluginResources");
            }
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        return this.resourceBundle;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public ActiveFoldingEditorTracker getEditorTracker() {
        return this.editorTracker;
    }
}

